/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jface.tests.viewers;

import java.util.ArrayList;
import org.eclipse.jface.tests.viewers.ViewerTestCase;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.ICellModifier;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.TextCellEditor;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.TreeColumn;
import org.junit.Assert;
import org.junit.Test;

public class Bug201002TreeViewerTest
extends ViewerTestCase {
    @Override
    protected StructuredViewer createViewer(Composite parent) {
        TreeViewer treeViewer = new TreeViewer(parent, 65536);
        treeViewer.setContentProvider((IContentProvider)new ITreeContentProvider(){

            public Object[] getElements(Object inputElement) {
                return ((MyModel)inputElement).child.toArray();
            }

            public void dispose() {
            }

            public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
            }

            public Object[] getChildren(Object parentElement) {
                return this.getElements(parentElement);
            }

            public Object getParent(Object element) {
                if (element == null) {
                    return null;
                }
                return ((MyModel)element).parent;
            }

            public boolean hasChildren(Object element) {
                return !((MyModel)element).child.isEmpty();
            }
        });
        treeViewer.setCellEditors(new CellEditor[]{new TextCellEditor((Composite)treeViewer.getTree())});
        treeViewer.setColumnProperties(new String[]{"0"});
        treeViewer.setCellModifier(new ICellModifier(){

            public boolean canModify(Object element, String property) {
                return true;
            }

            public Object getValue(Object element, String property) {
                return "";
            }

            public void modify(Object element, String property, Object value) {
            }
        });
        new TreeColumn(treeViewer.getTree(), 0).setWidth(200);
        return treeViewer;
    }

    @Override
    protected void setUpModel() {
    }

    @Override
    protected void setInput() {
        MyModel root = new MyModel(0, null);
        root.counter = 0;
        int i = 1;
        while (i < 100) {
            MyModel tmp = new MyModel(i, root);
            root.child.add(tmp);
            int j = 1;
            while (j < i) {
                tmp.child.add(new MyModel(j, tmp));
                ++j;
            }
            ++i;
        }
        this.getTreeViewer().setInput((Object)root);
    }

    private TreeViewer getTreeViewer() {
        return (TreeViewer)this.fViewer;
    }

    @Test
    public void testBug201002() {
        this.getTreeViewer().getTree().setTopItem(this.getTreeViewer().getTree().getItem(0));
        this.getTreeViewer().editElement((Object)((MyModel)this.getTreeViewer().getInput()).child.get((int)90).child.get(10), 0);
        while (this.getTreeViewer().getTree().getDisplay().readAndDispatch()) {
        }
        Assert.assertTrue((this.getTreeViewer().getTree().getTopItem() != this.getTreeViewer().getTree().getItem(0) ? 1 : 0) != 0);
    }

    public static class MyModel {
        public MyModel parent;
        public ArrayList<MyModel> child = new ArrayList();
        public int counter;

        public MyModel(int counter, MyModel parent) {
            this.parent = parent;
            this.counter = counter;
        }

        public String toString() {
            Object rv = "Item ";
            if (this.parent != null) {
                rv = String.valueOf(this.parent) + ".";
            }
            rv = (String)rv + this.counter;
            return rv;
        }
    }
}

