/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jface.tests.viewers;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Shell;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class Bug205700TreeViewerTest {
    private Shell shell;
    private TreeViewer viewer;
    private TreeNode rootNode;
    private final TreeNode child1 = new TreeNode("Child1");
    private final TreeNode child5 = new TreeNode("Child5");
    private final TreeNode child10 = new TreeNode("Child10");

    @Before
    public void setUp() throws Exception {
        this.shell = new Shell();
        this.viewer = new TreeViewer((Composite)this.shell, 770);
        this.viewer.setContentProvider((IContentProvider)new InternalContentProvider());
        this.viewer.setLabelProvider((IBaseLabelProvider)new InternalLabelProvider());
        this.viewer.setInput(this.createInput());
        this.shell.open();
    }

    @After
    public void tearDown() throws Exception {
        this.shell.close();
    }

    @Test
    public void testAddWithoutSorter() throws Exception {
        this.assertItemNames(new String[]{"Child1", "Child5", "Child10"});
        this.rootNode.add(new TreeNode("Child2"));
        this.rootNode.add(new TreeNode("Child3"));
        this.rootNode.add(new TreeNode("Child4"));
        this.rootNode.add(new TreeNode("Child6"));
        this.rootNode.add(new TreeNode("Child7"));
        this.rootNode.add(new TreeNode("Child8"));
        this.rootNode.add(new TreeNode("Child9"));
        this.viewer.add((Object)this.rootNode, this.rootNode.getChildren().toArray());
        this.assertItemNames(new String[]{"Child1", "Child5", "Child10", "Child2", "Child3", "Child4", "Child6", "Child7", "Child8", "Child9"});
    }

    private void assertItemNames(String[] names) {
        int i = 0;
        while (i < names.length) {
            this.assertItemName(i, names[i]);
            ++i;
        }
    }

    private void assertItemName(int index, String name) {
        Assert.assertEquals((String)("at " + index), (Object)name, (Object)this.viewer.getTree().getItem(index).getText());
    }

    @Test
    public void testAddWithSorter() throws Exception {
        this.assertItemNames(new String[]{"Child1", "Child5", "Child10"});
        this.viewer.setComparator(new ViewerComparator());
        this.assertItemNames(new String[]{"Child1", "Child10", "Child5"});
        this.rootNode.add(new TreeNode("Child2"));
        this.rootNode.add(new TreeNode("Child3"));
        this.rootNode.add(new TreeNode("Child4"));
        this.rootNode.add(new TreeNode("Child6"));
        this.rootNode.add(new TreeNode("Child7"));
        this.rootNode.add(new TreeNode("Child8"));
        this.rootNode.add(new TreeNode("Child9"));
        this.viewer.add((Object)this.rootNode, this.rootNode.getChildren().toArray());
        this.assertItemNames(new String[]{"Child1", "Child10", "Child2", "Child3", "Child4", "Child5", "Child6", "Child7", "Child8", "Child9"});
    }

    @Test
    public void testAddEquallySortedElements() throws Exception {
        this.assertItemNames(new String[]{"Child1", "Child5", "Child10"});
        this.viewer.setComparator(new ViewerComparator());
        this.assertItemNames(new String[]{"Child1", "Child10", "Child5"});
        this.rootNode.getChildren().add(0, new TreeNode("Child1"));
        this.viewer.add((Object)this.rootNode, this.rootNode.getChildren().toArray());
        this.assertItemNames(new String[]{"Child1", "Child1", "Child10", "Child5"});
    }

    private Object createInput() {
        this.rootNode = new TreeNode("Root");
        this.rootNode.add(this.child1);
        this.rootNode.add(this.child5);
        this.rootNode.add(this.child10);
        return this.rootNode;
    }

    private static class InternalContentProvider
    implements ITreeContentProvider {
        private InternalContentProvider() {
        }

        public Object[] getChildren(Object parentElement) {
            if (parentElement instanceof TreeNode) {
                TreeNode treeNode = (TreeNode)parentElement;
                return treeNode.getChildren().toArray();
            }
            return new Object[0];
        }

        public Object getParent(Object element) {
            if (element instanceof TreeNode) {
                TreeNode treeNode = (TreeNode)element;
                return treeNode.getParent();
            }
            return null;
        }

        public boolean hasChildren(Object element) {
            if (element instanceof TreeNode) {
                TreeNode treeNode = (TreeNode)element;
                return treeNode.getChildren().isEmpty();
            }
            return false;
        }

        public Object[] getElements(Object inputElement) {
            return this.getChildren(inputElement);
        }

        public void dispose() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }
    }

    private static class InternalLabelProvider
    extends LabelProvider {
        private InternalLabelProvider() {
        }

        public String getText(Object element) {
            if (element instanceof TreeNode) {
                TreeNode treeNode = (TreeNode)element;
                return treeNode.getName();
            }
            return null;
        }
    }

    private static class TreeNode {
        private final String name;
        private final TreeNode parent = null;
        private final List<TreeNode> children = new ArrayList<TreeNode>();

        public TreeNode(String name) {
            this.name = name;
        }

        public void add(TreeNode newChild) {
            if (newChild != null) {
                this.children.add(newChild);
            }
        }

        public List<TreeNode> getChildren() {
            return this.children;
        }

        public TreeNode getParent() {
            return this.parent;
        }

        public String getName() {
            return this.name;
        }

        public String toString() {
            return this.getName();
        }
    }
}

