/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jface.tests.viewers;

import org.eclipse.jface.tests.viewers.TestElement;
import org.eclipse.jface.tests.viewers.TestModelContentProvider;
import org.eclipse.jface.tests.viewers.ViewerTestCase;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.ColumnLabelProvider;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.ComboBoxCellEditor;
import org.eclipse.jface.viewers.EditingSupport;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.swt.widgets.Composite;
import org.junit.Assert;
import org.junit.Test;

public class Bug242231Test
extends ViewerTestCase {
    protected static final String[] COMBO_ITEMS = new String[]{"default value", "some value", "value changed"};
    private TableViewer tableViewer;

    @Override
    protected StructuredViewer createViewer(Composite parent) {
        this.tableViewer = new TableViewer(parent, 0);
        this.tableViewer.setContentProvider((IContentProvider)new TestModelContentProvider());
        TableViewerColumn tableColumn = new TableViewerColumn(this.tableViewer, 0);
        tableColumn.setEditingSupport(this.getEditingSupport());
        tableColumn.setLabelProvider((CellLabelProvider)new ColumnLabelProvider());
        return this.tableViewer;
    }

    private EditingSupport getEditingSupport() {
        return new EditingSupport((ColumnViewer)this.tableViewer){

            protected void setValue(Object element, Object value) {
                ((TestElement)element).setLabel("value set");
            }

            protected Object getValue(Object element) {
                return 0;
            }

            protected CellEditor getCellEditor(Object element) {
                return new ComboBoxCellEditor(Bug242231Test.this.tableViewer.getControl().getParent(), COMBO_ITEMS);
            }

            protected boolean canEdit(Object element) {
                return true;
            }
        };
    }

    @Test
    public void testBug242231() {
        TestElement testElement = this.fRootElement.getChildAt(0);
        testElement.setLabel("default value");
        this.tableViewer.editElement((Object)testElement, 0);
        this.tableViewer.applyEditorValue();
        Assert.assertEquals((Object)"value set", (Object)testElement.getLabel());
    }
}

