/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jface.tests.viewers;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.jface.tests.viewers.ViewerTestCase;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILazyContentProvider;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.junit.Before;
import org.junit.Test;

public class Bug256889TableViewerTest
extends ViewerTestCase {
    private static final int ADD_ENTRIES = 100;
    private static final int PREFETCH_TRESHOLD = 50;
    private static final int MAX_ENTRIES = 205;
    private int rowcounter = 0;
    private final List<String> model = new ArrayList<String>();
    private Table table;
    private TableViewer tableViewer;

    @Override
    protected StructuredViewer createViewer(Composite parent) {
        this.tableViewer = new TableViewer(parent, 268437506);
        this.tableViewer.setContentProvider((IContentProvider)new ILazyContentProvider(){

            public void updateElement(int index) {
                if (index >= 0 && index < Bug256889TableViewerTest.this.tableViewer.getTable().getItemCount()) {
                    if (index > Bug256889TableViewerTest.this.getModel().size() - 50 && Bug256889TableViewerTest.this.getModel().size() < 205) {
                        int approxRecordCount = Bug256889TableViewerTest.this.addElementsToModel();
                        System.out.println("approx. record count: " + approxRecordCount);
                        Bug256889TableViewerTest.this.tableViewer.setItemCount(approxRecordCount);
                    }
                    if (index < Bug256889TableViewerTest.this.getModel().size()) {
                        Bug256889TableViewerTest.this.tableViewer.replace((Object)Bug256889TableViewerTest.this.getModel().get(index), index);
                    } else {
                        System.out.println("invalid index " + index + " model count " + Bug256889TableViewerTest.this.getModel().size());
                    }
                } else {
                    System.out.println("invalid index " + index + " tableItemCount " + Bug256889TableViewerTest.this.tableViewer.getTable().getItemCount());
                }
            }

            public void dispose() {
            }

            public void inputChanged(Viewer arg0, Object arg1, Object arg2) {
            }
        });
        String[] columnProperties = new String[]{"Spalte 1", "Virtual Tables rock"};
        this.tableViewer.setColumnProperties(columnProperties);
        this.table = this.tableViewer.getTable();
        TableColumn col = new TableColumn(this.table, 0);
        col.setText(columnProperties[0]);
        col.setWidth(200);
        col = new TableColumn(this.table, 0);
        col.setText(columnProperties[1]);
        col.setWidth(400);
        this.table.setHeaderVisible(true);
        this.table.setLinesVisible(true);
        this.tableViewer.setItemCount(this.getModel().size());
        return this.tableViewer;
    }

    @Override
    protected void setInput() {
        this.tableViewer.setInput(this.getModel());
        this.tableViewer.setItemCount(this.getModel().size());
        this.fShell.setSize(300, 1000);
    }

    @Before
    public void initModel() {
        this.rowcounter = 0;
        this.getModel().clear();
        this.addElementsToModel();
    }

    protected int addElementsToModel() {
        int approxRecordCount = 0;
        int itemsToAdd = this.getModel().size() + 100 < 205 ? 100 : 205 - this.getModel().size();
        int i = 0;
        while (i < itemsToAdd) {
            this.getModel().add("Item " + this.rowcounter++);
            ++i;
        }
        approxRecordCount = this.getModel().size() == 205 ? 205 : this.getModel().size() + 100;
        return approxRecordCount;
    }

    private List<String> getModel() {
        return this.model;
    }

    @Test
    public void testBug256889() {
        this.table.selectAll();
        this.tableViewer.getStructuredSelection();
    }
}

