/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jface.tests.viewers;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;

public class Bug287765Test {
    private TreeViewer treeViewer;
    private Node root;

    @Before
    public void setUp() throws Exception {
        Shell shell = new Shell();
        shell.setLayout((Layout)new GridLayout());
        shell.setSize(new Point(500, 200));
        this.treeViewer = new TreeViewer((Composite)shell);
        this.treeViewer.getControl().setLayoutData((Object)new GridData(4, 4, true, true));
        this.treeViewer.setUseHashlookup(true);
        SimpleTreeContentProvider provider = new SimpleTreeContentProvider();
        this.treeViewer.setContentProvider((IContentProvider)provider);
        this.treeViewer.setLabelProvider((IBaseLabelProvider)provider);
        this.root = new Node(null, 0);
        this.treeViewer.setInput((Object)this.root);
        shell.open();
    }

    @After
    public void tearDown() throws Exception {
        this.treeViewer.getControl().getShell().dispose();
        this.treeViewer = null;
        this.root = null;
    }

    @Test
    public void testException() {
        this.treeViewer.expandAll();
        this.treeViewer.refresh();
        this.treeViewer.getExpandedTreePaths();
    }

    private static class Node {
        private final Node parent;
        private final List<Node> children = new ArrayList<Node>();
        private final int level;

        private Node(Node parentNode, int nodeLevel) {
            this.parent = parentNode;
            this.level = nodeLevel;
            if (this.parent != null) {
                this.parent.children.add(this);
            }
        }
    }

    private final class SimpleTreeContentProvider
    implements ITreeContentProvider,
    ILabelProvider {
        private SimpleTreeContentProvider() {
        }

        public Image getImage(Object element) {
            return null;
        }

        public String getText(Object element) {
            Node node = (Node)element;
            return Integer.toString(node.level);
        }

        public void addListener(ILabelProviderListener listener) {
        }

        public boolean isLabelProperty(Object element, String property) {
            return false;
        }

        public void removeListener(ILabelProviderListener listener) {
        }

        public Object[] getChildren(Object parentElement) {
            Node node = (Node)parentElement;
            return node.children.toArray();
        }

        public boolean hasChildren(Object element) {
            Node node = (Node)element;
            return !node.children.isEmpty();
        }

        public Object[] getElements(Object inputElement) {
            Node node;
            int depth = 4;
            Node parentNode = node = new Node(Bug287765Test.this.root, 1);
            int i = 2;
            while (i <= depth) {
                Node newNode;
                parentNode = newNode = new Node(parentNode, i);
                ++i;
            }
            return new Object[]{node};
        }

        public Object getParent(Object element) {
            Node node = (Node)element;
            return node.parent;
        }

        public void dispose() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }
    }
}

