/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jface.tests.viewers;

import org.eclipse.jface.util.LocalSelectionTransfer;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerDropAdapter;
import org.eclipse.swt.dnd.DragSourceEvent;
import org.eclipse.swt.dnd.DragSourceListener;
import org.eclipse.swt.dnd.DropTargetListener;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.dnd.TransferData;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class Bug553483ViewerDropAdapterTest {
    private Display display;
    private Shell shell;
    private Point srcPos1;
    private Point tgtPos1;
    private Point srcPos2;
    private Point tgtPos2;
    private int numberOfDrops;

    @Before
    public void setUp() throws Exception {
        this.display = new Display();
        this.shell = new Shell(this.display);
        this.shell.setLayout((Layout)new RowLayout(256));
        TreeViewer srcViewer = new TreeViewer((Composite)this.shell);
        srcViewer.setContentProvider((IContentProvider)new ContentProvider());
        srcViewer.setInput((Object)new String[]{"1", "2", "3", "4"});
        int dragOps = 1;
        Transfer[] transfers = new Transfer[]{LocalSelectionTransfer.getTransfer()};
        srcViewer.addDragSupport(dragOps, transfers, (DragSourceListener)new ViewerDragSource((Viewer)srcViewer));
        TreeViewer tgtViewer = new TreeViewer((Composite)this.shell);
        tgtViewer.setContentProvider((IContentProvider)new ContentProvider());
        tgtViewer.setInput((Object)new String[]{"A", "B", "C", "D"});
        int dropOps = 3;
        Transfer[] dropTransfers = new Transfer[]{LocalSelectionTransfer.getTransfer()};
        tgtViewer.addDropSupport(dropOps, dropTransfers, (DropTargetListener)new ViewerDropTarget((Viewer)tgtViewer));
        this.shell.pack();
        this.shell.open();
        while (!this.shell.isDisposed()) {
            if (this.display.readAndDispatch()) continue;
            Rectangle srcItemBounds = srcViewer.getTree().getItem(1).getBounds();
            this.srcPos1 = srcViewer.getTree().toDisplay(srcItemBounds.x + srcItemBounds.width / 2, srcItemBounds.y + srcItemBounds.height / 2);
            this.tgtPos1 = new Point(this.srcPos1.x + tgtViewer.getTree().getBounds().x - srcViewer.getTree().getBounds().x, this.srcPos1.y);
            srcItemBounds = srcViewer.getTree().getItem(2).getBounds();
            this.srcPos2 = srcViewer.getTree().toDisplay(srcItemBounds.x + srcItemBounds.width / 2, srcItemBounds.y + srcItemBounds.height / 2);
            this.tgtPos2 = new Point(this.srcPos2.x + tgtViewer.getTree().getBounds().x - srcViewer.getTree().getBounds().x, this.srcPos2.y);
            return;
        }
    }

    @After
    public void tearDown() throws Exception {
        Assert.assertTrue((boolean)this.shell.isDisposed());
        this.display.dispose();
    }

    @Test
    public void testBug553483() {
        boolean copyWasPosted = false;
        boolean moveWasPosted = false;
        while (!this.shell.isDisposed()) {
            if (this.display.readAndDispatch()) continue;
            if (!copyWasPosted) {
                Assert.assertEquals((long)0L, (long)this.numberOfDrops);
                this.postDragAndDropCopyEvents();
                copyWasPosted = true;
                continue;
            }
            if (!moveWasPosted) {
                Assert.assertEquals((long)1L, (long)this.numberOfDrops);
                this.postDragAndDropMoveEvents();
                moveWasPosted = true;
                continue;
            }
            this.display.asyncExec(() -> this.shell.dispose());
        }
        Assert.assertEquals((long)1L, (long)this.numberOfDrops);
    }

    private void postDragAndDropCopyEvents() {
        this.shell.forceActive();
        Event keyEvent = new Event();
        Event mouseEvent = new Event();
        keyEvent.keyCode = 262144;
        keyEvent.stateMask = 0;
        keyEvent.type = 1;
        this.display.post(keyEvent);
        mouseEvent.x = this.srcPos1.x;
        mouseEvent.y = this.srcPos1.y;
        mouseEvent.type = 5;
        mouseEvent.stateMask = 262144;
        this.display.post(mouseEvent);
        mouseEvent.button = 1;
        mouseEvent.count = 1;
        mouseEvent.type = 3;
        mouseEvent.stateMask = 262144;
        this.display.post(mouseEvent);
        mouseEvent.x = this.tgtPos1.x;
        mouseEvent.y = this.tgtPos1.y;
        mouseEvent.type = 5;
        mouseEvent.stateMask = 262144;
        this.display.post(mouseEvent);
        mouseEvent.type = 4;
        mouseEvent.stateMask = 262144;
        this.display.post(mouseEvent);
        keyEvent.keyCode = 262144;
        keyEvent.stateMask = 262144;
        keyEvent.type = 2;
        this.display.post(keyEvent);
    }

    private void postDragAndDropMoveEvents() {
        this.shell.forceActive();
        Event mouseEvent = new Event();
        mouseEvent.x = this.srcPos2.x;
        mouseEvent.y = this.srcPos2.y;
        mouseEvent.type = 5;
        this.display.post(mouseEvent);
        mouseEvent.button = 1;
        mouseEvent.count = 1;
        mouseEvent.type = 3;
        this.display.post(mouseEvent);
        mouseEvent.x = this.tgtPos2.x;
        mouseEvent.y = this.tgtPos2.y;
        mouseEvent.type = 5;
        this.display.post(mouseEvent);
        mouseEvent.type = 4;
        this.display.post(mouseEvent);
    }

    private static class ContentProvider
    implements ITreeContentProvider {
        private ContentProvider() {
        }

        public boolean hasChildren(Object element) {
            return false;
        }

        public Object getParent(Object element) {
            return null;
        }

        public Object[] getElements(Object inputElement) {
            return ArrayContentProvider.getInstance().getElements(inputElement);
        }

        public Object[] getChildren(Object parentElement) {
            return null;
        }
    }

    private static class ViewerDragSource
    implements DragSourceListener {
        private final Viewer viewer;

        ViewerDragSource(Viewer v) {
            this.viewer = v;
        }

        public void dragStart(DragSourceEvent event) {
            LocalSelectionTransfer.getTransfer().setSelection(this.viewer.getSelection());
        }

        public void dragSetData(DragSourceEvent event) {
        }

        public void dragFinished(DragSourceEvent event) {
            LocalSelectionTransfer.getTransfer().setSelection(null);
        }
    }

    private class ViewerDropTarget
    extends ViewerDropAdapter {
        ViewerDropTarget(Viewer viewer) {
            super(viewer);
        }

        public boolean validateDrop(Object target, int operation, TransferData transferType) {
            return true;
        }

        public boolean performDrop(Object data) {
            ++Bug553483ViewerDropAdapterTest.this.numberOfDrops;
            return true;
        }
    }
}

