/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jface.tests.viewers;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.jface.tests.viewers.MyFocusBorderCellHighlighter;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.ColumnLabelProvider;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.ColumnViewerEditorActivationEvent;
import org.eclipse.jface.viewers.ColumnViewerEditorActivationStrategy;
import org.eclipse.jface.viewers.EditingSupport;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.SWTFocusCellManager;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TextCellEditor;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.TreeViewerColumn;
import org.eclipse.jface.viewers.TreeViewerEditor;
import org.eclipse.jface.viewers.TreeViewerFocusCellManager;
import org.eclipse.jface.viewers.ViewerCell;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Tree;

public class Bug566936TreeViewerTest {
    public static boolean flag = true;

    public Bug566936TreeViewerTest(Shell shell) {
        final TreeViewer v = new TreeViewer((Composite)shell, 67584);
        v.setContentProvider((IContentProvider)new MyColumnLabelProvider(v.getTree(), 0));
        TreeViewerFocusCellManager focusCellManager = new TreeViewerFocusCellManager(v, new MyFocusBorderCellHighlighter((ColumnViewer)v)){

            public ViewerCell getFocusCell() {
                ViewerCell cell = super.getFocusCell();
                if (cell != null) {
                    return cell;
                }
                return v.getCell(new Point(5, 5));
            }
        };
        ColumnViewerEditorActivationStrategy actSupport = new ColumnViewerEditorActivationStrategy((ColumnViewer)v){

            protected boolean isEditorActivationEvent(ColumnViewerEditorActivationEvent event) {
                return event.eventType == 5 || event.eventType == 3 || event.eventType == 1 && event.keyCode == 13 || event.eventType == 4;
            }
        };
        int feature = 58;
        TreeViewerEditor.create((TreeViewer)v, (SWTFocusCellManager)focusCellManager, (ColumnViewerEditorActivationStrategy)actSupport, (int)feature);
        String[] columLabels = new String[]{"Column 1", "Column 2", "Column 3", "Col 4", "Col 5", "Col 6", "Col 7", "Col 8", "Col 9", "Col 10", "Col 11", "Col 12"};
        int property = 0;
        String[] stringArray = columLabels;
        int n = columLabels.length;
        int n2 = 0;
        while (n2 < n) {
            String label = stringArray[n2];
            this.createColumnFor(v, label, property++);
            ++n2;
        }
        List<MyModel> model = Bug566936TreeViewerTest.createModel();
        v.setInput(model);
        v.setSelection((ISelection)new StructuredSelection((Object)model.get(0)));
        v.getTree().setLinesVisible(true);
        v.getTree().setHeaderVisible(true);
        v.getTree().setFocus();
    }

    private void createColumnFor(TreeViewer v, String label, int columnIndex) {
        TreeViewerColumn viewerColumn = new TreeViewerColumn(v, 0, columnIndex);
        viewerColumn.getColumn().setWidth(300);
        viewerColumn.getColumn().setMoveable(true);
        viewerColumn.getColumn().setText(label);
        viewerColumn.getColumn().setResizable(true);
        viewerColumn.setEditingSupport((EditingSupport)new MyEditingSupport((ColumnViewer)v, "" + columnIndex));
        viewerColumn.setLabelProvider((CellLabelProvider)new MyColumnLabelProvider(v.getTree(), columnIndex));
    }

    private static List<MyModel> createModel() {
        ArrayList<MyModel> elements = new ArrayList<MyModel>();
        int i = 0;
        while (i < 10) {
            elements.add(new MyModel(i));
            ++i;
        }
        return elements;
    }

    public static void main(String[] args) {
        Display display = new Display();
        Shell shell = new Shell(display);
        shell.setLayout((Layout)new FillLayout());
        new Bug566936TreeViewerTest(shell);
        shell.open();
        while (!shell.isDisposed()) {
            if (display.readAndDispatch()) continue;
            display.sleep();
        }
        display.dispose();
    }

    private static class MyColumnLabelProvider
    extends ColumnLabelProvider
    implements ITreeContentProvider {
        private final int columnIndex;
        private final Tree tree;

        public MyColumnLabelProvider(Tree tree, int columnIndex) {
            this.tree = tree;
            this.columnIndex = columnIndex;
        }

        public String getText(Object element) {
            return "Column " + this.tree.getColumnOrder()[this.columnIndex] + " => " + String.valueOf(element);
        }

        public Object[] getElements(Object inputElement) {
            if (inputElement instanceof List) {
                List list = (List)inputElement;
                return list.toArray();
            }
            return new Object[0];
        }

        public Object[] getChildren(Object parentElement) {
            return new Object[0];
        }

        public Object getParent(Object element) {
            return new Object[0];
        }

        public boolean hasChildren(Object element) {
            return true;
        }
    }

    private class MyEditingSupport
    extends EditingSupport {
        private final String property;

        public MyEditingSupport(ColumnViewer viewer, String property) {
            super(viewer);
            this.property = property;
        }

        protected CellEditor getCellEditor(Object element) {
            return new TextCellEditor((Composite)this.getViewer().getControl());
        }

        protected boolean canEdit(Object element) {
            return true;
        }

        protected Object getValue(Object element) {
            return "Column " + this.property + " => " + String.valueOf(element);
        }

        protected void setValue(Object element, Object value) {
        }
    }

    private static class MyModel {
        public int counter;

        public MyModel(int counter) {
            this.counter = counter;
        }

        public String toString() {
            return "Item " + this.counter;
        }
    }
}

