/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jface.tests.viewers;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.jface.tests.viewers.TestElement;
import org.eclipse.jface.viewers.ICheckStateProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.jface.viewers.ViewerFilter;

public class CheckStateProviderTestsUtil {
    private static final int NUMBER_OF_STATES = 4;

    public static int constructNumber(TestElement te) {
        String id = te.getID();
        int number = Integer.parseInt(id.substring(id.lastIndexOf(45) + 1)) + id.length();
        return number % 4;
    }

    public static boolean shouldBeChecked(TestElement te, int shift) {
        return (CheckStateProviderTestsUtil.constructNumber(te) + shift) % 4 > 1;
    }

    public static boolean shouldBeGrayed(TestElement te, int shift) {
        return (CheckStateProviderTestsUtil.constructNumber(te) + shift) % 4 % 2 == 1;
    }

    public static final class Filter
    extends ViewerFilter {
        public boolean select(Viewer viewer, Object parentElement, Object element) {
            return CheckStateProviderTestsUtil.constructNumber((TestElement)element) % 7 == 3;
        }
    }

    public static final class Sorter
    extends ViewerComparator {
        public int compare(Viewer viewer, Object e1, Object e2) {
            return CheckStateProviderTestsUtil.constructNumber((TestElement)e1) - CheckStateProviderTestsUtil.constructNumber((TestElement)e2);
        }
    }

    public static final class TestCheckStateProvider
    extends TestMethodsInvokedCheckStateProvider {
        private final int shift;

        public TestCheckStateProvider(int shift) {
            this.shift = shift;
        }

        @Override
        public boolean isChecked(Object element) {
            super.isChecked(element);
            return CheckStateProviderTestsUtil.shouldBeChecked((TestElement)element, this.shift);
        }

        @Override
        public boolean isGrayed(Object element) {
            super.isGrayed(element);
            return CheckStateProviderTestsUtil.shouldBeGrayed((TestElement)element, this.shift);
        }
    }

    public static class TestMethodsInvokedCheckStateProvider
    implements ICheckStateProvider {
        public List<TestElement> isCheckedInvokedOn = new ArrayList<TestElement>();
        public List<TestElement> isGrayedInvokedOn = new ArrayList<TestElement>();

        public boolean isChecked(Object element) {
            this.isCheckedInvokedOn.add((TestElement)element);
            return true;
        }

        public boolean isGrayed(Object element) {
            this.isGrayedInvokedOn.add((TestElement)element);
            return true;
        }

        public void reset() {
            this.isCheckedInvokedOn = new ArrayList<TestElement>();
            this.isGrayedInvokedOn = new ArrayList<TestElement>();
        }
    }
}

