/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jface.tests.viewers;

import java.util.ArrayList;
import org.eclipse.jface.tests.viewers.CheckStateProviderTestsUtil;
import org.eclipse.jface.tests.viewers.StructuredViewerTest;
import org.eclipse.jface.tests.viewers.TableViewerTest;
import org.eclipse.jface.tests.viewers.TestElement;
import org.eclipse.jface.tests.viewers.TestModelContentProvider;
import org.eclipse.jface.viewers.CheckboxTableViewer;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICheckStateProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.TableLayout;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.junit.Assert;
import org.junit.Test;

public class CheckboxTableViewerTest
extends TableViewerTest {
    @Override
    protected StructuredViewer createViewer(Composite parent) {
        Table table = new Table(parent, 2080);
        table.setLinesVisible(true);
        TableLayout layout = new TableLayout();
        table.setLayout((Layout)layout);
        table.setHeaderVisible(true);
        String[] headers = new String[]{"column 1 header", "column 2 header"};
        ColumnLayoutData[] layouts = new ColumnLayoutData[]{new ColumnWeightData(100), new ColumnWeightData(100)};
        TableColumn[] columns = new TableColumn[headers.length];
        int i = 0;
        while (i < headers.length) {
            layout.addColumnData(layouts[i]);
            TableColumn tc = new TableColumn(table, 0, i);
            tc.setResizable(layouts[i].resizable);
            tc.setText(headers[i]);
            columns[i] = tc;
            ++i;
        }
        CheckboxTableViewer viewer = new CheckboxTableViewer(table);
        viewer.setContentProvider((IContentProvider)new TestModelContentProvider());
        viewer.setLabelProvider((IBaseLabelProvider)new TableViewerTest.TableTestLabelProvider());
        return viewer;
    }

    @Test
    public void testCheckAllElements() {
        CheckboxTableViewer ctv = (CheckboxTableViewer)this.fViewer;
        ctv.setAllChecked(true);
        Assert.assertTrue((boolean)ctv.getChecked((Object)this.fRootElement.getFirstChild()));
        Assert.assertTrue((boolean)ctv.getChecked((Object)this.fRootElement.getLastChild()));
        ctv.setAllChecked(false);
        Assert.assertTrue((!ctv.getChecked((Object)this.fRootElement.getFirstChild()) ? 1 : 0) != 0);
        Assert.assertTrue((!ctv.getChecked((Object)this.fRootElement.getLastChild()) ? 1 : 0) != 0);
    }

    @Test
    public void testGrayAllElements() {
        CheckboxTableViewer ctv = (CheckboxTableViewer)this.fViewer;
        ctv.setAllGrayed(true);
        Assert.assertTrue((boolean)ctv.getGrayed((Object)this.fRootElement.getFirstChild()));
        Assert.assertTrue((boolean)ctv.getGrayed((Object)this.fRootElement.getLastChild()));
        ctv.setAllGrayed(false);
        Assert.assertTrue((!ctv.getGrayed((Object)this.fRootElement.getFirstChild()) ? 1 : 0) != 0);
        Assert.assertTrue((!ctv.getGrayed((Object)this.fRootElement.getLastChild()) ? 1 : 0) != 0);
    }

    @Test
    public void testGrayed() {
        CheckboxTableViewer ctv = (CheckboxTableViewer)this.fViewer;
        TestElement element = this.fRootElement.getFirstChild();
        Assert.assertEquals((long)0L, (long)ctv.getGrayedElements().length);
        Assert.assertTrue((!ctv.getGrayed((Object)element) ? 1 : 0) != 0);
        ctv.setGrayed((Object)element, true);
        Assert.assertEquals((long)1L, (long)ctv.getGrayedElements().length);
        Assert.assertTrue((boolean)ctv.getGrayed((Object)element));
        ctv.setGrayed((Object)element, false);
        Assert.assertEquals((long)0L, (long)ctv.getGrayedElements().length);
        Assert.assertTrue((!ctv.getGrayed((Object)element) ? 1 : 0) != 0);
        ctv.setAllGrayed(false);
    }

    @Test
    public void testGrayedElements() {
        CheckboxTableViewer ctv = (CheckboxTableViewer)this.fViewer;
        TestElement first = this.fRootElement.getFirstChild();
        TestElement last = this.fRootElement.getLastChild();
        Assert.assertEquals((long)0L, (long)ctv.getGrayedElements().length);
        Assert.assertTrue((!ctv.getGrayed((Object)first) ? 1 : 0) != 0);
        Assert.assertTrue((!ctv.getGrayed((Object)last) ? 1 : 0) != 0);
        ctv.setGrayed((Object)first, true);
        ctv.setGrayed((Object)last, true);
        Object[] elements = ctv.getGrayedElements();
        Assert.assertEquals((long)2L, (long)elements.length);
        Assert.assertEquals((Object)first, (Object)elements[0]);
        Assert.assertEquals((Object)last, (Object)elements[1]);
        ctv.setGrayed((Object)first, false);
        ctv.setGrayed((Object)last, false);
        Assert.assertEquals((long)0L, (long)ctv.getGrayedElements().length);
        ctv.setAllGrayed(false);
    }

    @Test
    public void testWithoutCheckProvider() {
        CheckboxTableViewer ctv = (CheckboxTableViewer)this.fViewer;
        ctv.refresh();
    }

    @Test
    public void testCheckProviderInvoked() {
        CheckboxTableViewer ctv = (CheckboxTableViewer)this.fViewer;
        CheckStateProviderTestsUtil.TestMethodsInvokedCheckStateProvider provider = new CheckStateProviderTestsUtil.TestMethodsInvokedCheckStateProvider();
        ctv.setCheckStateProvider((ICheckStateProvider)provider);
        Assert.assertTrue((String)"isChecked should be invoked on a refresh", (!provider.isCheckedInvokedOn.isEmpty() ? 1 : 0) != 0);
        Assert.assertTrue((String)"isGrayed should be invoked on a refresh", (!provider.isGrayedInvokedOn.isEmpty() ? 1 : 0) != 0);
        provider.reset();
        ctv.refresh();
        Assert.assertTrue((String)"isChecked should be invoked on a refresh", (!provider.isCheckedInvokedOn.isEmpty() ? 1 : 0) != 0);
        Assert.assertTrue((String)"isGrayed should be invoked on a refresh", (!provider.isGrayedInvokedOn.isEmpty() ? 1 : 0) != 0);
    }

    @Test
    public void testCheckedFalseGrayedFalse() {
        this.testSpecificState(false, false);
    }

    @Test
    public void testCheckedFalseGrayedTrue() {
        this.testSpecificState(false, true);
    }

    @Test
    public void testCheckedTrueGrayedFalse() {
        this.testSpecificState(true, false);
    }

    @Test
    public void testCheckedTrueGrayedTrue() {
        this.testSpecificState(true, true);
    }

    private void testSpecificState(final boolean isChecked, final boolean isGrayed) {
        CheckboxTableViewer ctv = (CheckboxTableViewer)this.fViewer;
        ctv.setCheckStateProvider(new ICheckStateProvider(){

            public boolean isChecked(Object element) {
                return isChecked;
            }

            public boolean isGrayed(Object element) {
                return isGrayed;
            }
        });
        TableItem item = ctv.getTable().getItem(0);
        Assert.assertEquals((Object)item.getChecked(), (Object)isChecked);
        Assert.assertEquals((Object)item.getGrayed(), (Object)isGrayed);
    }

    @Test
    public void testSetCheckProviderRefreshesItems() {
        CheckboxTableViewer ctv = (CheckboxTableViewer)this.fViewer;
        ctv.setCheckStateProvider((ICheckStateProvider)new CheckStateProviderTestsUtil.TestCheckStateProvider(0));
        CheckboxTableViewerTest.checkAllStates("Testing checkbox state after refresh", ctv, 0);
        ctv.setCheckStateProvider(null);
        TestElement update = this.fRootElement.getChildAt(5);
        ctv.update((Object)update, null);
        ctv.refresh();
    }

    @Test
    public void testCheckProviderWithSorter() {
        CheckboxTableViewer ctv = (CheckboxTableViewer)this.fViewer;
        ctv.setComparator((ViewerComparator)new CheckStateProviderTestsUtil.Sorter());
        ctv.setCheckStateProvider((ICheckStateProvider)new CheckStateProviderTestsUtil.TestCheckStateProvider(0));
        CheckboxTableViewerTest.checkAllStates("Testing checkbox state with a sorter", ctv, 0);
    }

    @Test
    public void testCheckProviderWithFilter() {
        CheckboxTableViewer ctv = (CheckboxTableViewer)this.fViewer;
        CheckStateProviderTestsUtil.Filter filter = new CheckStateProviderTestsUtil.Filter();
        ctv.addFilter((ViewerFilter)filter);
        CheckStateProviderTestsUtil.TestCheckStateProvider checkStateProvider = new CheckStateProviderTestsUtil.TestCheckStateProvider(0);
        ctv.setCheckStateProvider((ICheckStateProvider)checkStateProvider);
        CheckboxTableViewerTest.checkAllStates("Testing checkbox state with a sorter", ctv, 0);
        for (TestElement element : checkStateProvider.isCheckedInvokedOn) {
            Assert.assertTrue((String)"The check provider should not be invoked on elements which did not get through the filter", (boolean)filter.select((Viewer)ctv, null, element));
        }
        for (TestElement element : checkStateProvider.isGrayedInvokedOn) {
            Assert.assertTrue((String)"The check provider should not be invoked on elements which did not get through the filter", (boolean)filter.select((Viewer)ctv, null, element));
        }
    }

    @Test
    public void testCheckProviderUpdate() {
        CheckboxTableViewer ctv = (CheckboxTableViewer)this.fViewer;
        ctv.setCheckStateProvider((ICheckStateProvider)new CheckStateProviderTestsUtil.TestCheckStateProvider(0));
        CheckboxTableViewerTest.checkAllStates("Testing checkbox state after refresh", ctv, 0);
        ctv.setCheckStateProvider((ICheckStateProvider)new CheckStateProviderTestsUtil.TestCheckStateProvider(1));
        CheckboxTableViewerTest.checkAllStates("Testing checkbox state after refresh", ctv, 1);
    }

    private static void checkAllStates(String comment, CheckboxTableViewer ctv, int shift) {
        TableItem[] items;
        TableItem[] tableItemArray = items = ctv.getTable().getItems();
        int n = items.length;
        int n2 = 0;
        while (n2 < n) {
            TableItem item = tableItemArray[n2];
            TestElement element = (TestElement)item.getData();
            CheckboxTableViewerTest.checkState(comment, element, item, shift);
            CheckboxTableViewerTest.checkState(comment, element, ctv, shift);
            ++n2;
        }
    }

    private static void checkState(String comment, TestElement te, CheckboxTableViewer viewer, int shift) {
        Assert.assertEquals((String)comment, (Object)CheckStateProviderTestsUtil.shouldBeChecked(te, shift), (Object)viewer.getChecked((Object)te));
        Assert.assertEquals((String)comment, (Object)CheckStateProviderTestsUtil.shouldBeGrayed(te, shift), (Object)viewer.getGrayed((Object)te));
    }

    private static void checkState(String comment, TestElement te, TableItem item, int shift) {
        Assert.assertEquals((String)("Wrong checkstate: " + comment), (Object)CheckStateProviderTestsUtil.shouldBeChecked(te, shift), (Object)item.getChecked());
        Assert.assertEquals((String)("Wrong checkstate: " + comment), (Object)CheckStateProviderTestsUtil.shouldBeGrayed(te, shift), (Object)item.getGrayed());
    }

    @Test
    public void testGetCheckedElements() {
        Object[] actuallyChecked;
        CheckboxTableViewer ctv = (CheckboxTableViewer)this.fViewer;
        TestElement[] children = this.fRootElement.getChildren();
        ArrayList<TestElement> checked = new ArrayList<TestElement>((children.length + 1) / 2);
        int i = 0;
        while (i < children.length) {
            ctv.setChecked((Object)children[i], true);
            checked.add(children[i]);
            i += 2;
        }
        Object[] objectArray = actuallyChecked = ctv.getCheckedElements();
        int n = actuallyChecked.length;
        int n2 = 0;
        while (n2 < n) {
            Object element = objectArray[n2];
            Assert.assertTrue((String)"getCheckedElements should include all checked elements", (boolean)checked.remove(element));
            ++n2;
        }
        Assert.assertTrue((String)"getCheckedElements should not include any unchecked elements", (boolean)checked.isEmpty());
    }

    @Test
    public void testSetCheckedElements() {
        CheckboxTableViewer ctv = (CheckboxTableViewer)this.fViewer;
        TestElement[] children = this.fRootElement.getChildren();
        ArrayList<TestElement> toCheck = new ArrayList<TestElement>((children.length + 1) / 2);
        int i = 0;
        while (i < children.length) {
            toCheck.add(children[i]);
            i += 2;
        }
        ctv.setCheckedElements(toCheck.toArray());
        i = 0;
        while (i < children.length) {
            if (i % 2 == 0) {
                Assert.assertTrue((String)"an element passed through setCheckedElements should be checked", (boolean)ctv.getChecked((Object)children[i]));
            } else {
                Assert.assertFalse((String)"an element not passed through setCheckedElements should be unchecked", (boolean)ctv.getChecked((Object)children[i]));
            }
            ++i;
        }
    }

    @Test
    public void testSetGrayedElements() {
        CheckboxTableViewer ctv = (CheckboxTableViewer)this.fViewer;
        TestElement[] children = this.fRootElement.getChildren();
        ArrayList<TestElement> toGray = new ArrayList<TestElement>((children.length + 1) / 2);
        int i = 0;
        while (i < children.length) {
            toGray.add(children[i]);
            i += 2;
        }
        ctv.setGrayedElements(toGray.toArray());
        i = 0;
        while (i < children.length) {
            if (i % 2 == 0) {
                Assert.assertTrue((String)"an element passed through setGrayedElements should be grayed", (boolean)ctv.getGrayed((Object)children[i]));
            } else {
                Assert.assertFalse((String)"an element not passed through setGrayedElements should not be grayed", (boolean)ctv.getGrayed((Object)children[i]));
            }
            ++i;
        }
    }

    public static class CheckboxTableTestLabelProvider
    extends StructuredViewerTest.TestLabelProvider
    implements ITableLabelProvider {
        public boolean fExtended = false;

        @Override
        public String getText(Object element) {
            if (this.fExtended) {
                return CheckboxTableViewerTest.providedString((String)element);
            }
            return element.toString();
        }

        public String getColumnText(Object element, int index) {
            if (this.fExtended) {
                return CheckboxTableViewerTest.providedString((TestElement)element);
            }
            return element.toString();
        }

        public Image getColumnImage(Object element, int columnIndex) {
            return null;
        }
    }

    public static class DeprecatedConstructor
    extends CheckboxTableViewerTest {
        @Override
        protected StructuredViewer createViewer(Composite parent) {
            CheckboxTableViewer viewer = CheckboxTableViewer.newCheckList((Composite)parent, (int)0);
            Table table = viewer.getTable();
            table.setLinesVisible(true);
            TableLayout layout = new TableLayout();
            table.setLayout((Layout)layout);
            table.setHeaderVisible(true);
            String[] headers = new String[]{"column 1 header", "column 2 header"};
            ColumnLayoutData[] layouts = new ColumnLayoutData[]{new ColumnWeightData(100), new ColumnWeightData(100)};
            TableColumn[] columns = new TableColumn[headers.length];
            int i = 0;
            while (i < headers.length) {
                layout.addColumnData(layouts[i]);
                TableColumn tc = new TableColumn(table, 0, i);
                tc.setResizable(layouts[i].resizable);
                tc.setText(headers[i]);
                columns[i] = tc;
                ++i;
            }
            viewer.setContentProvider((IContentProvider)new TestModelContentProvider());
            viewer.setLabelProvider((IBaseLabelProvider)new TableViewerTest.TableTestLabelProvider());
            return viewer;
        }

        @Override
        @Test
        public void testViewerColumn() {
            Assert.assertNull((Object)this.getViewerColumn((ColumnViewer)((TableViewer)this.fViewer), -1));
            Assert.assertNotNull((Object)this.getViewerColumn((ColumnViewer)((TableViewer)this.fViewer), 0));
            Assert.assertNotNull((Object)this.getViewerColumn((ColumnViewer)((TableViewer)this.fViewer), 1));
            Assert.assertNull((Object)this.getViewerColumn((ColumnViewer)((TableViewer)this.fViewer), 3));
        }
    }

    public static class FactoryMethod
    extends CheckboxTableViewerTest {
        @Override
        protected StructuredViewer createViewer(Composite parent) {
            CheckboxTableViewer viewer = CheckboxTableViewer.newCheckList((Composite)parent, (int)0);
            Table table = viewer.getTable();
            table.setLinesVisible(true);
            TableLayout layout = new TableLayout();
            table.setLayout((Layout)layout);
            table.setHeaderVisible(true);
            String[] headers = new String[]{"column 1 header", "column 2 header"};
            ColumnLayoutData[] layouts = new ColumnLayoutData[]{new ColumnWeightData(100), new ColumnWeightData(100)};
            TableColumn[] columns = new TableColumn[headers.length];
            int i = 0;
            while (i < headers.length) {
                layout.addColumnData(layouts[i]);
                TableColumn tc = new TableColumn(table, 0, i);
                tc.setResizable(layouts[i].resizable);
                tc.setText(headers[i]);
                columns[i] = tc;
                ++i;
            }
            viewer.setContentProvider((IContentProvider)new TestModelContentProvider());
            viewer.setLabelProvider((IBaseLabelProvider)new TableViewerTest.TableTestLabelProvider());
            return viewer;
        }
    }
}

