/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jface.tests.viewers;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import org.eclipse.jface.tests.viewers.CheckStateProviderTestsUtil;
import org.eclipse.jface.tests.viewers.StructuredViewerTest;
import org.eclipse.jface.tests.viewers.TestElement;
import org.eclipse.jface.tests.viewers.TestModelContentProvider;
import org.eclipse.jface.tests.viewers.TreeViewerTest;
import org.eclipse.jface.viewers.CheckboxTreeViewer;
import org.eclipse.jface.viewers.ICheckStateProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.TreeItem;
import org.junit.Assert;
import org.junit.Test;

public class CheckboxTreeViewerTest
extends TreeViewerTest {
    @Override
    protected StructuredViewer createViewer(Composite parent) {
        this.fTreeViewer = new CheckboxTreeViewer(parent);
        this.fTreeViewer.setContentProvider((IContentProvider)new TestModelContentProvider());
        return this.fTreeViewer;
    }

    @Test
    public void testCheckSubtree() {
        CheckboxTreeViewer ctv = (CheckboxTreeViewer)this.fViewer;
        TestElement first = this.fRootElement.getFirstChild();
        TestElement firstfirst = first.getFirstChild();
        TestElement firstfirstfirst = firstfirst.getFirstChild();
        this.fTreeViewer.expandToLevel((Object)firstfirst, 0);
        ctv.setSubtreeChecked((Object)first, true);
        Assert.assertTrue((boolean)ctv.getChecked((Object)firstfirst));
        ctv.setSubtreeChecked((Object)first, false);
        Assert.assertTrue((!ctv.getChecked((Object)firstfirst) ? 1 : 0) != 0);
        Assert.assertTrue((boolean)ctv.setSubtreeChecked((Object)firstfirstfirst, false));
        Assert.assertTrue((!ctv.getChecked((Object)firstfirstfirst) ? 1 : 0) != 0);
    }

    @Test
    public void testGrayed() {
        CheckboxTreeViewer ctv = (CheckboxTreeViewer)this.fViewer;
        TestElement element = this.fRootElement.getFirstChild();
        Assert.assertEquals((long)0L, (long)ctv.getGrayedElements().length);
        Assert.assertTrue((!ctv.getGrayed((Object)element) ? 1 : 0) != 0);
        ctv.setGrayed((Object)element, true);
        Assert.assertEquals((long)1L, (long)ctv.getGrayedElements().length);
        Assert.assertTrue((boolean)ctv.getGrayed((Object)element));
        ctv.setGrayed((Object)element, false);
        Assert.assertEquals((long)0L, (long)ctv.getGrayedElements().length);
        Assert.assertTrue((!ctv.getGrayed((Object)element) ? 1 : 0) != 0);
    }

    @Test
    public void testParentGrayed() {
        CheckboxTreeViewer ctv = (CheckboxTreeViewer)this.fViewer;
        TestElement first = this.fRootElement.getFirstChild();
        TestElement firstfirst = first.getFirstChild();
        TestElement firstfirstfirst = firstfirst.getFirstChild();
        ctv.expandToLevel((Object)firstfirstfirst, 0);
        ctv.setParentsGrayed((Object)firstfirstfirst, true);
        Object[] elements = ctv.getGrayedElements();
        Assert.assertEquals((long)3L, (long)elements.length);
        Object[] objectArray = elements;
        int n = elements.length;
        int n2 = 0;
        while (n2 < n) {
            Object element = objectArray[n2];
            Assert.assertTrue((boolean)ctv.getGrayed(element));
            ++n2;
        }
        Assert.assertEquals((Object)first, (Object)elements[0]);
        Assert.assertEquals((Object)firstfirst, (Object)elements[1]);
        Assert.assertEquals((Object)firstfirstfirst, (Object)elements[2]);
        ctv.setParentsGrayed((Object)firstfirstfirst, false);
    }

    @Test
    public void testWithoutCheckProvider() {
        CheckboxTreeViewer ctv = (CheckboxTreeViewer)this.fViewer;
        ctv.expandAll();
        ctv.refresh();
    }

    @Test
    public void testCheckProviderInvoked() {
        CheckboxTreeViewer ctv = (CheckboxTreeViewer)this.fViewer;
        CheckStateProviderTestsUtil.TestMethodsInvokedCheckStateProvider provider = new CheckStateProviderTestsUtil.TestMethodsInvokedCheckStateProvider();
        ctv.setCheckStateProvider((ICheckStateProvider)provider);
        Assert.assertFalse((String)"isChecked should be invoked on a refresh", (boolean)provider.isCheckedInvokedOn.isEmpty());
        Assert.assertFalse((String)"isGrayed should be invoked on a refresh", (boolean)provider.isGrayedInvokedOn.isEmpty());
        provider.reset();
        ctv.refresh();
        Assert.assertFalse((String)"isChecked should be invoked on a refresh", (boolean)provider.isCheckedInvokedOn.isEmpty());
        Assert.assertFalse((String)"isGrayed should be invoked on a refresh", (boolean)provider.isGrayedInvokedOn.isEmpty());
    }

    @Test
    public void testCheckProviderLazilyInvoked() {
        int j;
        boolean firstLevelElement;
        TestElement element;
        TestElement testElement;
        CheckboxTreeViewer ctv = (CheckboxTreeViewer)this.fViewer;
        CheckStateProviderTestsUtil.TestMethodsInvokedCheckStateProvider provider = new CheckStateProviderTestsUtil.TestMethodsInvokedCheckStateProvider();
        ctv.setCheckStateProvider((ICheckStateProvider)provider);
        ctv.refresh();
        TestElement[] expected = this.fRootElement.getChildren();
        Iterator<TestElement> iterator = provider.isCheckedInvokedOn.iterator();
        while (iterator.hasNext()) {
            element = testElement = iterator.next();
            firstLevelElement = false;
            j = 0;
            while (j < expected.length && !firstLevelElement) {
                firstLevelElement = element.equals(expected[j]);
                ++j;
            }
            Assert.assertTrue((String)"The check provider should only be invoked with visible elements", (boolean)firstLevelElement);
        }
        iterator = provider.isGrayedInvokedOn.iterator();
        while (iterator.hasNext()) {
            element = testElement = iterator.next();
            firstLevelElement = false;
            j = 0;
            while (j < expected.length && !firstLevelElement) {
                firstLevelElement = element.equals(expected[j]);
                ++j;
            }
            Assert.assertTrue((String)"The check provider should only be invoked with visible elements", (boolean)firstLevelElement);
        }
    }

    @Test
    public void testCheckedFalseGrayedFalse() {
        this.testSpecificState(false, false);
    }

    @Test
    public void testCheckedFalseGrayedTrue() {
        this.testSpecificState(false, true);
    }

    @Test
    public void testCheckedTrueGrayedFalse() {
        this.testSpecificState(true, false);
    }

    @Test
    public void testCheckedTrueGrayedTrue() {
        this.testSpecificState(true, true);
    }

    private void testSpecificState(final boolean isChecked, final boolean isGrayed) {
        CheckboxTreeViewer ctv = (CheckboxTreeViewer)this.fViewer;
        ctv.setCheckStateProvider(new ICheckStateProvider(){

            public boolean isChecked(Object element) {
                return isChecked;
            }

            public boolean isGrayed(Object element) {
                return isGrayed;
            }
        });
        TreeItem item = ctv.getTree().getItem(0);
        Assert.assertEquals((Object)item.getChecked(), (Object)isChecked);
        Assert.assertEquals((Object)item.getGrayed(), (Object)isGrayed);
    }

    @Test
    public void testSetCheckProviderRefreshesItems() {
        CheckboxTreeViewer ctv = (CheckboxTreeViewer)this.fViewer;
        ctv.setCheckStateProvider((ICheckStateProvider)new CheckStateProviderTestsUtil.TestCheckStateProvider(0));
        ctv.expandAll();
        this.checkAllStates("Testing checkbox state after refresh", ctv, 0);
        ctv.setCheckStateProvider(null);
        TestElement update = this.fRootElement.getFirstChild().getChildAt(5);
        ctv.update((Object)update, null);
        ctv.refresh();
    }

    @Test
    public void testCheckProviderWithSorter() {
        CheckboxTreeViewer ctv = (CheckboxTreeViewer)this.fViewer;
        ctv.setComparator((ViewerComparator)new CheckStateProviderTestsUtil.Sorter());
        ctv.setCheckStateProvider((ICheckStateProvider)new CheckStateProviderTestsUtil.TestCheckStateProvider(0));
        ctv.expandAll();
        this.checkAllStates("Testing checkbox state with a sorter", ctv, 0);
    }

    @Test
    public void testCheckProviderWithFilter() {
        CheckboxTreeViewer ctv = (CheckboxTreeViewer)this.fViewer;
        CheckStateProviderTestsUtil.Filter filter = new CheckStateProviderTestsUtil.Filter();
        ctv.addFilter((ViewerFilter)filter);
        CheckStateProviderTestsUtil.TestCheckStateProvider checkStateProvider = new CheckStateProviderTestsUtil.TestCheckStateProvider(0);
        ctv.setCheckStateProvider((ICheckStateProvider)checkStateProvider);
        ctv.expandAll();
        this.checkAllStates("Testing checkbox state with a sorter", ctv, 0);
        for (TestElement element : checkStateProvider.isCheckedInvokedOn) {
            Assert.assertTrue((String)"The check provider should not be invoked on elements which did not get through the filter", (boolean)filter.select((Viewer)ctv, null, element));
        }
        for (TestElement element : checkStateProvider.isGrayedInvokedOn) {
            Assert.assertTrue((String)"The check provider should not be invoked on elements which did not get through the filter", (boolean)filter.select((Viewer)ctv, null, element));
        }
    }

    @Test
    public void testSetNewCheckProvider() {
        CheckboxTreeViewer ctv = (CheckboxTreeViewer)this.fViewer;
        ctv.setCheckStateProvider((ICheckStateProvider)new CheckStateProviderTestsUtil.TestCheckStateProvider(0));
        ctv.expandAll();
        this.checkAllStates("Testing checkbox state after first refresh", ctv, 0);
        ctv.setCheckStateProvider((ICheckStateProvider)new CheckStateProviderTestsUtil.TestCheckStateProvider(1));
        this.checkAllStates("Testing checkbox state after setting new check provider", ctv, 1);
    }

    private void collectElementsInBranch(TreeItem item, Collection<TreeItem> treeItems, Collection<TestElement> testElements) {
        TreeItem[] children;
        treeItems.add(item);
        testElements.add((TestElement)item.getData());
        TreeItem[] treeItemArray = children = item.getItems();
        int n = children.length;
        int n2 = 0;
        while (n2 < n) {
            TreeItem element = treeItemArray[n2];
            this.collectElementsInBranch(element, treeItems, testElements);
            ++n2;
        }
    }

    private void checkAllStates(String comment, CheckboxTreeViewer ctv, int shift) {
        ArrayList<TreeItem> items = new ArrayList<TreeItem>();
        ArrayList<TestElement> elements = new ArrayList<TestElement>();
        this.collectElementsInBranch(ctv.getTree().getItem(0), items, elements);
        Iterator i = items.iterator();
        Iterator j = elements.iterator();
        while (i.hasNext()) {
            TreeItem item = (TreeItem)i.next();
            TestElement element = (TestElement)j.next();
            CheckboxTreeViewerTest.checkState(comment, element, item, shift);
            CheckboxTreeViewerTest.checkState(comment, element, ctv, shift);
        }
    }

    private static void checkState(String comment, TestElement te, CheckboxTreeViewer viewer, int shift) {
        Assert.assertEquals((String)comment, (Object)CheckStateProviderTestsUtil.shouldBeChecked(te, shift), (Object)viewer.getChecked((Object)te));
        Assert.assertEquals((String)comment, (Object)CheckStateProviderTestsUtil.shouldBeGrayed(te, shift), (Object)viewer.getGrayed((Object)te));
    }

    private static void checkState(String comment, TestElement te, TreeItem item, int shift) {
        Assert.assertEquals((String)("Wrong checkstate: " + comment), (Object)CheckStateProviderTestsUtil.shouldBeChecked(te, shift), (Object)item.getChecked());
        Assert.assertEquals((String)("Wrong checkstate: " + comment), (Object)CheckStateProviderTestsUtil.shouldBeGrayed(te, shift), (Object)item.getGrayed());
    }

    @Test
    public void testGetCheckedElements() {
        Object[] actuallyChecked;
        CheckboxTreeViewer ctv = (CheckboxTreeViewer)this.fViewer;
        TestElement[] children = this.fRootElement.getChildren();
        ArrayList<TestElement> checked = new ArrayList<TestElement>((children.length + 1) / 2);
        int i = 0;
        while (i < children.length) {
            ctv.setChecked((Object)children[i], true);
            checked.add(children[i]);
            i += 2;
        }
        Object[] objectArray = actuallyChecked = ctv.getCheckedElements();
        int n = actuallyChecked.length;
        int n2 = 0;
        while (n2 < n) {
            Object element = objectArray[n2];
            Assert.assertTrue((String)"getCheckedElements should include all checked elements", (boolean)checked.remove(element));
            ++n2;
        }
        Assert.assertTrue((String)"getCheckedElements should not include any unchecked elements", (boolean)checked.isEmpty());
    }

    @Test
    public void testSetCheckedElements() {
        CheckboxTreeViewer ctv = (CheckboxTreeViewer)this.fViewer;
        TestElement[] children = this.fRootElement.getChildren();
        ArrayList<TestElement> toCheck = new ArrayList<TestElement>((children.length + 1) / 2);
        int i = 0;
        while (i < children.length) {
            toCheck.add(children[i]);
            i += 2;
        }
        ctv.setCheckedElements(toCheck.toArray());
        i = 0;
        while (i < children.length) {
            if (i % 2 == 0) {
                Assert.assertTrue((String)"an element passed through setCheckedElements should be checked", (boolean)ctv.getChecked((Object)children[i]));
            } else {
                Assert.assertFalse((String)"an element not passed through setCheckedElements should be unchecked", (boolean)ctv.getChecked((Object)children[i]));
            }
            ++i;
        }
    }

    @Test
    public void testSetGrayedElements() {
        CheckboxTreeViewer ctv = (CheckboxTreeViewer)this.fViewer;
        TestElement[] children = this.fRootElement.getChildren();
        ArrayList<TestElement> toGray = new ArrayList<TestElement>((children.length + 1) / 2);
        int i = 0;
        while (i < children.length) {
            toGray.add(children[i]);
            i += 2;
        }
        ctv.setGrayedElements(toGray.toArray());
        i = 0;
        while (i < children.length) {
            if (i % 2 == 0) {
                Assert.assertTrue((String)"an element passed through setGrayedElements should be grayed", (boolean)ctv.getGrayed((Object)children[i]));
            } else {
                Assert.assertFalse((String)"an element not passed through setGrayedElements should not be grayed", (boolean)ctv.getGrayed((Object)children[i]));
            }
            ++i;
        }
    }

    @Test
    public void testSetAllChecked() {
        Object expandedElement;
        Object[] expandedElements;
        CheckboxTreeViewer ctv = (CheckboxTreeViewer)this.fViewer;
        ctv.expandToLevel(2);
        ctv.setAllChecked(true);
        Object[] objectArray = expandedElements = ctv.getExpandedElements();
        int n = expandedElements.length;
        int n2 = 0;
        while (n2 < n) {
            expandedElement = objectArray[n2];
            Assert.assertTrue((String)"all expanded items should be checked", (boolean)ctv.getChecked(expandedElement));
            ++n2;
        }
        ctv.setAllChecked(false);
        objectArray = expandedElements;
        n = expandedElements.length;
        n2 = 0;
        while (n2 < n) {
            expandedElement = objectArray[n2];
            Assert.assertFalse((String)"all expanded items should be unchecked", (boolean)ctv.getChecked(expandedElement));
            ++n2;
        }
    }

    @Test
    public void testSetGrayChecked() {
        CheckboxTreeViewer ctv = (CheckboxTreeViewer)this.fViewer;
        TestElement[] children = this.fRootElement.getChildren();
        ctv.setGrayChecked((Object)children[0], true);
        ctv.setGrayChecked((Object)children[1], false);
        Assert.assertTrue((String)"an item invoked with setGrayChecked(true) should be checked", (boolean)ctv.getChecked((Object)children[0]));
        Assert.assertTrue((String)"an item invoked with setGrayChecked(true) should be grayed", (boolean)ctv.getGrayed((Object)children[0]));
        Assert.assertFalse((String)"an item invoked with setGrayChecked(false) should be unchecked", (boolean)ctv.getChecked((Object)children[1]));
        Assert.assertFalse((String)"an item invoked with setGrayChecked(false) should not be grayed", (boolean)ctv.getGrayed((Object)children[1]));
    }

    public static class CheckboxTableTestLabelProvider
    extends StructuredViewerTest.TestLabelProvider
    implements ITableLabelProvider {
        public boolean fExtended = false;

        @Override
        public String getText(Object element) {
            if (this.fExtended) {
                return CheckboxTreeViewerTest.providedString((String)element);
            }
            return element.toString();
        }

        public String getColumnText(Object element, int index) {
            if (this.fExtended) {
                return CheckboxTreeViewerTest.providedString((TestElement)element);
            }
            return element.toString();
        }

        public Image getColumnImage(Object element, int columnIndex) {
            return null;
        }
    }
}

