/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jface.tests.viewers;

import org.eclipse.jface.util.ILogger;
import org.eclipse.jface.util.ISafeRunnableRunner;
import org.eclipse.jface.util.Policy;
import org.eclipse.jface.util.SafeRunnable;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.ComboViewer;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IElementComparer;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class ComboViewerComparerTest {
    private Shell shell;
    private StructuredViewer viewer;
    private ILogger oldLogger;
    private ISafeRunnableRunner oldRunner;

    @Test
    public void testSetSelection() {
        this.viewer.setContentProvider((IContentProvider)ArrayContentProvider.getInstance());
        this.viewer.setComparer(new IElementComparer(){

            public boolean equals(Object element1, Object element2) {
                TestElement testElement1 = (TestElement)element1;
                TestElement testElement2 = (TestElement)element2;
                return testElement1.getName().equals(testElement2.getName());
            }

            public int hashCode(Object element) {
                TestElement testElement = (TestElement)element;
                return testElement.getName().hashCode();
            }
        });
        this.viewer.setInput((Object)new TestElement[]{new TestElement("a"), new TestElement("b")});
        TestElement aElement = new TestElement("a");
        this.viewer.setSelection((ISelection)new StructuredSelection((Object)aElement));
        IStructuredSelection sel = this.viewer.getStructuredSelection();
        Assert.assertEquals((Object)false, (Object)sel.isEmpty());
        TestElement selectedElement = (TestElement)sel.getFirstElement();
        Assert.assertEquals((Object)aElement.getName(), (Object)selectedElement.getName());
    }

    @Before
    public void setUp() {
        this.oldLogger = Policy.getLog();
        this.oldRunner = SafeRunnable.getRunner();
        Policy.setLog(status -> Assert.fail((String)status.getMessage()));
        SafeRunnable.setRunner(code -> {
            try {
                code.run();
            }
            catch (Throwable th) {
                throw new RuntimeException(th);
            }
        });
        Display display = Display.getCurrent();
        if (display == null) {
            display = new Display();
        }
        this.shell = new Shell(display);
        this.shell.setSize(500, 500);
        this.shell.setLayout((Layout)new FillLayout());
        this.viewer = this.createViewer(this.shell);
        this.shell.open();
    }

    @After
    public void tearDown() {
        Policy.setLog((ILogger)this.oldLogger);
        SafeRunnable.setRunner((ISafeRunnableRunner)this.oldRunner);
        this.processEvents();
        this.viewer = null;
        if (this.shell != null) {
            this.shell.dispose();
            this.shell = null;
        }
    }

    protected StructuredViewer createViewer(Shell parent) {
        return new ComboViewer((Composite)parent, 0);
    }

    private void processEvents() {
        Display display;
        if (this.shell != null && !this.shell.isDisposed() && (display = this.shell.getDisplay()) != null) {
            while (display.readAndDispatch()) {
            }
        }
    }

    private static final class TestElement {
        private final String name;

        public TestElement(String name) {
            this.name = name;
        }

        public String getName() {
            return this.name;
        }
    }
}

