/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jface.tests.viewers;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.part.DrillDownAdapter;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class DrillDownAdapterTest {
    private Shell shell;

    @Before
    public void setUp() {
        this.shell = new Shell();
        this.shell.open();
    }

    @After
    public void tearDown() {
        this.shell.close();
    }

    @Test
    public void test_goInto_and_goHome() {
        MyModel home = new MyModel("Home", null);
        MyModel node1 = new MyModel("Node1", home);
        MyModel node2 = new MyModel("Node2", node1);
        MyModel node3 = new MyModel("Node3", node2);
        MyModel node4 = new MyModel("Node4", node3);
        TreeViewer viewer = new TreeViewer((Composite)this.shell);
        viewer.setLabelProvider((IBaseLabelProvider)new LabelProvider());
        viewer.setContentProvider((IContentProvider)new MyContentProvider());
        viewer.setInput((Object)home);
        viewer.expandAll();
        DrillDownAdapter dda = new DrillDownAdapter(viewer);
        Assert.assertSame((Object)home, (Object)viewer.getInput());
        viewer.setSelection((ISelection)new StructuredSelection((Object)node1));
        dda.goInto();
        Assert.assertSame((Object)node1, (Object)viewer.getInput());
        viewer.setSelection((ISelection)new StructuredSelection((Object)node2));
        dda.goInto();
        Assert.assertSame((Object)node2, (Object)viewer.getInput());
        viewer.setSelection((ISelection)new StructuredSelection((Object)node3));
        dda.goInto();
        Assert.assertSame((Object)node3, (Object)viewer.getInput());
        viewer.setSelection((ISelection)new StructuredSelection((Object)node4));
        dda.goInto();
        Assert.assertSame((Object)node3, (Object)viewer.getInput());
        dda.goHome();
        viewer.setSelection((ISelection)new StructuredSelection((Object)node1));
        Assert.assertSame((Object)home, (Object)viewer.getInput());
    }

    static class MyContentProvider
    implements ITreeContentProvider {
        MyContentProvider() {
        }

        public Object[] getElements(Object inputElement) {
            return ((MyModel)inputElement).children.toArray();
        }

        public Object[] getChildren(Object parentElement) {
            return this.getElements(parentElement);
        }

        public Object getParent(Object element) {
            if (element == null) {
                return null;
            }
            return ((MyModel)element).parent;
        }

        public boolean hasChildren(Object element) {
            return element != null && ((MyModel)element).children.size() > 0;
        }
    }

    static class MyModel {
        public MyModel parent;
        public List<MyModel> children = new ArrayList<MyModel>();
        public String name;

        public MyModel(String name, MyModel parent) {
            this.name = name;
            this.parent = parent;
            if (parent != null) {
                parent.children.add(this);
            }
        }

        public String toString() {
            return this.name;
        }
    }
}

