/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jface.tests.viewers;

import java.util.Arrays;
import java.util.Comparator;
import java.util.Iterator;
import java.util.TreeSet;
import org.eclipse.jface.tests.viewers.TestComparator;
import org.eclipse.jface.viewers.deferred.LazySortedCollection;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class LazySortedCollectionTest {
    private TestComparator comparator;
    private TestComparator comparisonComparator;
    private LazySortedCollection collection;
    private TreeSet<Object> comparisonCollection;
    private final String[] se = new String[]{"v00 aaaaaa", "v01 apple", "v02 booger", "v03 car", "v04 dog", "v05 elephant", "v06 fox", "v07 goose", "v08 hippie", "v09 iguana", "v10 junk", "v11 karma", "v12 lemon", "v13 mongoose", "v14 noodle", "v15 opal", "v16 pumpkin", "v17 quirks", "v18 resteraunt", "v19 soap", "v20 timmy", "v21 ugly", "v22 virus", "v23 wigwam", "v24 xerxes", "v25 yellow", "v26 zero"};
    private final String[] elements = new String[]{this.se[19], this.se[7], this.se[6], this.se[1], this.se[20], this.se[8], this.se[0], this.se[23], this.se[17], this.se[18], this.se[24], this.se[25], this.se[10], this.se[5], this.se[15], this.se[16], this.se[21], this.se[26], this.se[22], this.se[3], this.se[9], this.se[4], this.se[11], this.se[12], this.se[13], this.se[14], this.se[2]};

    public static void printArray(Object[] array) {
        int i = 0;
        while (i < array.length) {
            System.out.println("[" + i + "] = " + String.valueOf(array[i]));
            ++i;
        }
    }

    @Before
    public void setUp() throws Exception {
        this.comparator = new TestComparator();
        this.collection = new LazySortedCollection((Comparator)this.comparator);
        this.collection.enableDebug = true;
        this.comparisonComparator = new TestComparator();
        this.comparisonCollection = new TreeSet<Object>(this.comparisonComparator);
        this.addAll(this.elements);
    }

    @After
    public void tearDown() throws Exception {
        System.out.println("Comparisons required by lazy collection: " + this.comparator.comparisons);
        System.out.println("Comparisons required by reference implementation: " + this.comparisonComparator.comparisons);
        System.out.println("");
    }

    private Object[] computeExpectedElementsInRange(int start, int length) {
        int counter = 0;
        Iterator<Object> iter = this.comparisonCollection.iterator();
        while (iter.hasNext() && counter < start) {
            iter.next();
            ++counter;
        }
        Object[] result = new Object[length];
        int i = 0;
        while (i < result.length) {
            result[i] = iter.next();
            ++i;
        }
        return result;
    }

    private void addAll(Object[] elements) {
        this.collection.addAll(elements);
        this.comparisonCollection.addAll(Arrays.asList(elements));
    }

    private void add(Object toAdd) {
        this.collection.add(toAdd);
        this.comparisonCollection.add(toAdd);
    }

    private void remove(Object toRemove) {
        this.collection.remove(toRemove);
        this.comparisonCollection.remove(toRemove);
    }

    private void removeRange(int start, int length) {
        Object[] expected;
        this.collection.removeRange(start, length);
        Object[] objectArray = expected = this.computeExpectedElementsInRange(start, length);
        int n = expected.length;
        int n2 = 0;
        while (n2 < n) {
            Object element = objectArray[n2];
            this.comparisonCollection.remove(element);
            ++n2;
        }
    }

    private void clear() {
        this.collection.clear();
        this.comparisonCollection.clear();
    }

    private void forceFullSort() {
        this.queryRange(0, this.elements.length, true);
    }

    private void assertContentsValid() {
        this.queryRange(0, this.comparisonCollection.size(), false);
        Assert.assertEquals((long)this.comparisonCollection.size(), (long)this.collection.size());
        Assert.assertEquals((Object)this.comparisonCollection.isEmpty(), (Object)this.collection.isEmpty());
    }

    private static void assertIsPermutation(Object[] array1, Object[] array2) {
        Object[] sorted1 = new Object[array1.length];
        System.arraycopy(array1, 0, sorted1, 0, array1.length);
        Arrays.sort(sorted1, new TestComparator());
        Object[] sorted2 = new Object[array2.length];
        System.arraycopy(array2, 0, sorted2, 0, array2.length);
        Arrays.sort(sorted2, new TestComparator());
        Assert.assertArrayEquals((Object[])sorted1, (Object[])sorted2);
    }

    private Object[] queryRange(int start, int length, boolean sorted) {
        Object[] result = new Object[length];
        int returnValue = this.collection.getRange(result, start, sorted);
        Assert.assertEquals((long)returnValue, (long)length);
        Object[] expectedResult = this.computeExpectedElementsInRange(start, length);
        if (sorted) {
            Assert.assertArrayEquals((Object[])expectedResult, (Object[])result);
        } else {
            LazySortedCollectionTest.assertIsPermutation(result, expectedResult);
        }
        this.collection.testInvariants();
        return result;
    }

    @Test
    public void testComparisonCount() {
        Assert.assertEquals((String)"additions should not require any comparisons", (long)0L, (long)this.comparator.comparisons);
        this.queryRange(0, this.elements.length, false);
        Assert.assertEquals((String)"requesting the complete set of unsorted elements should not require any comparisons", (long)0L, (long)this.comparator.comparisons);
    }

    @Test
    public void testSortAll() {
        this.queryRange(0, this.elements.length, true);
        int comparisons = this.comparator.comparisons;
        this.queryRange(this.elements.length - 10, 10, true);
        this.queryRange(0, 10, false);
        Assert.assertEquals((String)"Once the lazy collection is fully sorted, it should not require further comparisons", (long)comparisons, (long)this.comparator.comparisons);
    }

    @Test
    public void testRemoveLeafNode() {
        this.forceFullSort();
        this.remove(this.se[9]);
        this.assertContentsValid();
    }

    @Test
    public void testRemoveNodeWithNoLeftChild() {
        this.forceFullSort();
        this.remove(this.se[23]);
        this.assertContentsValid();
    }

    @Test
    public void testRemoveNodeWithNoRightChild() {
        this.forceFullSort();
        this.remove(this.se[13]);
        this.assertContentsValid();
    }

    @Test
    public void testRemoveRootNode() {
        this.forceFullSort();
        this.remove(this.se[19]);
        this.assertContentsValid();
    }

    @Test
    public void testRemoveWhereSwappedNodeIsntLeaf() {
        this.forceFullSort();
        this.remove(this.se[14]);
        this.assertContentsValid();
    }

    @Test
    public void testRemoveWithUnsortedSwap() {
        this.queryRange(14, 1, true);
        this.queryRange(13, 1, true);
        this.addAll(new String[]{"v13 n", "v13 l"});
        this.queryRange(8, 1, true);
        this.addAll(new String[]{"v14 m", "v14 o"});
        this.queryRange(7, 1, true);
        this.remove(this.se[14]);
        this.assertContentsValid();
    }

    @Test
    public void testRemoveFromUnsorted() {
        this.remove(this.se[10]);
        this.assertContentsValid();
    }

    @Test
    public void testRemoveRootFromUnsorted() {
        this.remove(this.se[19]);
        this.assertContentsValid();
    }

    @Test
    public void testRemoveUnknown() {
        this.remove("some unknown element");
        this.assertContentsValid();
    }

    @Test
    public void testRemovePreviouslySwappedNode() {
        this.queryRange(0, this.elements.length, true);
        this.remove(this.se[14]);
        this.add("something new");
        this.assertContentsValid();
        this.remove(this.se[13]);
        this.assertContentsValid();
    }

    @Test
    public void testRemoveFullRange() {
        this.removeRange(0, this.se.length);
        this.assertContentsValid();
    }

    @Test
    public void testRemoveFromStart() {
        this.removeRange(0, this.se.length / 2);
        this.assertContentsValid();
    }

    @Test
    public void testRemoveFromEnd() {
        int start = this.se.length / 2;
        this.removeRange(start, this.se.length - start);
        this.assertContentsValid();
    }

    @Test
    public void testRemoveIncludingRoot() {
        this.removeRange(14, 6);
        this.assertContentsValid();
    }

    @Test
    public void testRemoveRightSubtree() {
        this.removeRange(9, 5);
        this.assertContentsValid();
    }

    @Test
    public void testRemoveLeftSubtree() {
        this.removeRange(3, 4);
        this.assertContentsValid();
    }

    @Test
    public void testRemoveRightIncludingRoot() {
        this.removeRange(3, 5);
        this.assertContentsValid();
    }

    @Test
    public void testClear() {
        this.clear();
        this.assertContentsValid();
    }

    @Test
    public void testClearSorted() {
        this.forceFullSort();
        this.clear();
        this.assertContentsValid();
    }
}

