/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jface.tests.viewers;

import org.eclipse.jface.tests.viewers.ViewerComparatorTest;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ListViewer;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.swt.widgets.Composite;
import org.junit.Assert;
import org.junit.Test;

public class ListViewerComparatorTest
extends ViewerComparatorTest {
    @Override
    protected StructuredViewer createViewer(Composite parent) {
        ListViewer viewer = new ListViewer(parent);
        viewer.setContentProvider((IContentProvider)new ViewerComparatorTest.TeamModelContentProvider(this));
        viewer.setLabelProvider((IBaseLabelProvider)new ViewerComparatorTest.TeamModelLabelProvider());
        return viewer;
    }

    @Test
    public void testViewerSorter() {
        this.fViewer.setSorter(new ViewerSorter());
        this.assertSortedResult(this.TEAM1_SORTED);
    }

    @Test
    public void testViewerSorterInsertElement() {
        this.fViewer.setSorter(new ViewerSorter());
        this.team1.addMember("Duong");
        this.assertSortedResult(this.TEAM1_SORTED_WITH_INSERT);
    }

    @Test
    public void testViewerComparator() {
        this.fViewer.setComparator(new ViewerComparator());
        this.assertSortedResult(this.TEAM1_SORTED);
    }

    @Test
    public void testViewerComparatorInsertElement() {
        this.fViewer.setComparator(new ViewerComparator());
        this.team1.addMember("Duong");
        this.assertSortedResult(this.TEAM1_SORTED_WITH_INSERT);
    }

    private void assertSortedResult(String[] expected) {
        String[] items = this.getListViewer().getList().getItems();
        int i = 0;
        while (i < items.length) {
            String item = items[i];
            Assert.assertEquals((String)("Item not expected.  actual=" + item + " expected="), (Object)expected[i], (Object)item);
            ++i;
        }
    }

    @Override
    protected void setInput() {
        this.fViewer.setInput((Object)this.team1);
    }

    protected ListViewer getListViewer() {
        return (ListViewer)this.fViewer;
    }
}

