/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jface.tests.viewers;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.ListViewer;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.tests.harness.util.DisplayHelper;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class ListViewerRefreshTest {
    private static final int DELAY = 0;
    private Shell shell = null;
    private Label label = null;
    private ListViewer viewer = null;
    private ArrayList<String> input = null;

    @Before
    public void setUp() throws Exception {
        this.shell = new Shell();
        this.shell.setSize(400, 200);
        this.shell.setLayout((Layout)new FillLayout());
        this.label = new Label((Composite)this.shell, 64);
        this.viewer = new ListViewer((Composite)this.shell);
        this.input = new ArrayList();
        int i = 0;
        while (i < 50) {
            this.input.add("item " + i);
            ++i;
        }
        this.viewer.setContentProvider((IContentProvider)new ContentProvider());
        this.viewer.setInput(this.input);
        this.shell.layout();
        this.shell.open();
    }

    @After
    public void tearDown() throws Exception {
        this.shell.dispose();
        this.shell = null;
    }

    @Test
    public void testNoSelectionRefresh() throws Exception {
        this.shell.setText("Lost Scrolled Position Test");
        ListViewerRefreshTest.readAndDispatch();
        this.run("Scrolled to position 30.", () -> this.viewer.reveal((Object)this.input.get(30)));
        this.run("Refreshed viewer without a selection.", () -> this.viewer.refresh());
        DisplayHelper.waitAndAssertCondition((Display)this.shell.getDisplay(), () -> Assert.assertNotEquals((long)this.viewer.getList().getTopIndex(), (long)0L));
    }

    @Test
    public void testSelectionRefresh() throws Exception {
        this.shell.setText("Preserved Scrolled Position Test");
        ListViewerRefreshTest.readAndDispatch();
        this.run("Setting selection to index 30.", () -> this.viewer.setSelection((ISelection)new StructuredSelection((Object)this.input.get(30))));
        this.viewer.getList().setTopIndex(0);
        this.run("Refreshed viewer with selection.", () -> this.viewer.refresh());
        Assert.assertEquals((long)0L, (long)this.viewer.getList().getTopIndex());
        this.viewer.getList().showSelection();
        DisplayHelper.waitAndAssertCondition((Display)this.shell.getDisplay(), () -> Assert.assertNotEquals((long)this.viewer.getList().getTopIndex(), (long)0L));
    }

    private void run(String description, Runnable runnable) {
        runnable.run();
        this.label.setText(description);
        ListViewerRefreshTest.readAndDispatch();
    }

    private static void readAndDispatch() {
        Display display = Display.getCurrent();
        while (display.readAndDispatch()) {
        }
        try {
            Thread.sleep(0L);
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
    }

    private static class ContentProvider
    implements IStructuredContentProvider {
        private ContentProvider() {
        }

        public Object[] getElements(Object inputElement) {
            return ((List)inputElement).toArray();
        }

        public void dispose() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }
    }
}

