/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jface.tests.viewers;

import org.eclipse.jface.tests.viewers.StructuredViewerTest;
import org.eclipse.jface.tests.viewers.TestElement;
import org.eclipse.jface.tests.viewers.TestModelContentProvider;
import org.eclipse.jface.util.Util;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ListViewer;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.List;
import org.eclipse.ui.tests.harness.util.DisplayHelper;
import org.junit.Assert;
import org.junit.Assume;
import org.junit.Test;

public class ListViewerTest
extends StructuredViewerTest {
    @Override
    protected StructuredViewer createViewer(Composite parent) {
        ListViewer viewer = new ListViewer(parent);
        viewer.setContentProvider((IContentProvider)new TestModelContentProvider());
        return viewer;
    }

    @Override
    protected int getItemCount() {
        TestElement first = this.fRootElement.getFirstChild();
        List list = (List)this.fViewer.testFindItem((Object)first);
        return list.getItemCount();
    }

    @Override
    protected String getItemText(int at) {
        List list = (List)this.fViewer.getControl();
        return list.getItem(at);
    }

    @Test
    public void testInsert() {
        ListViewer v = (ListViewer)this.fViewer;
        TestElement element = new TestElement(this.fModel, this.fRootElement);
        v.insert((Object)element, 1);
        Assert.assertSame((String)"test insert", (Object)element, (Object)v.getElementAt(1));
        Assert.assertEquals((String)"test insert", (Object)element.toString(), (Object)v.getList().getItem(1));
        v.addFilter(new ViewerFilter(){

            public boolean select(Viewer viewer, Object parentElement, Object element) {
                return true;
            }
        });
        TestElement element1 = new TestElement(this.fModel, this.fRootElement);
        v.insert((Object)element1, 1);
        Assert.assertNotSame((String)"test insert", (Object)element1, (Object)v.getElementAt(1));
        v.setFilters(new ViewerFilter[0]);
        v.remove((Object)element);
        v.remove((Object)element1);
    }

    @Test
    public void testRevealBug69076() {
        Assume.assumeFalse((String)"See bug 116105", (boolean)Util.isLinux());
        this.fViewer = null;
        if (this.fShell != null) {
            this.fShell.dispose();
            this.fShell = null;
        }
        this.openBrowser();
        int i = 40;
        while (i < 45) {
            this.fRootElement = TestElement.createModel(1, i);
            this.fModel = this.fRootElement.getModel();
            this.fViewer.setInput((Object)this.fRootElement);
            int j = 30;
            while (j < this.fRootElement.getChildCount()) {
                this.fViewer.setSelection((ISelection)new StructuredSelection((Object)this.fRootElement.getFirstChild()), true);
                TestElement child = this.fRootElement.getChildAt(j);
                this.fViewer.reveal((Object)child);
                List list = ((ListViewer)this.fViewer).getList();
                int topIndex = list.getTopIndex();
                this.fViewer.setSelection((ISelection)new StructuredSelection((Object)child), false);
                Assert.assertEquals((String)"topIndex should not change on setSelection", (long)topIndex, (long)list.getTopIndex());
                list.showSelection();
                Assert.assertEquals((String)"topIndex should not change on showSelection", (long)topIndex, (long)list.getTopIndex());
                ++j;
            }
            ++i;
        }
    }

    @Test
    public void testRefreshBug141435() throws Exception {
        this.fViewer = null;
        if (this.fShell != null) {
            this.fShell.dispose();
            this.fShell = null;
        }
        this.openBrowser();
        TestElement model = TestElement.createModel(1, 50);
        this.fViewer.setInput((Object)model);
        int lastIndex = model.getChildCount() - 1;
        this.fViewer.reveal((Object)model.getChildAt(lastIndex));
        List list = (List)this.fViewer.getControl();
        try {
            Device.DEBUG = true;
            int topIndex = list.getTopIndex();
            Assert.assertNotEquals((String)"Top item should not be the first item.", (long)0L, (long)topIndex);
            this.fViewer.refresh();
            DisplayHelper.waitAndAssertCondition((Display)this.fShell.getDisplay(), () -> Assert.assertEquals((String)"Top index was not preserved after refresh.", (long)topIndex, (long)list.getTopIndex()));
            model.deleteChildren();
            this.fViewer.refresh();
            DisplayHelper.waitAndAssertCondition((Display)this.fShell.getDisplay(), () -> Assert.assertEquals((long)0L, (long)list.getTopIndex()));
        }
        finally {
            Device.DEBUG = false;
        }
    }

    @Test
    public void testSelectionRevealBug177619() throws Exception {
        TestElement model = TestElement.createModel(1, 100);
        this.fViewer.setInput((Object)model);
        this.fViewer.setSelection((ISelection)new StructuredSelection(((ListViewer)this.fViewer).getElementAt(50)), true);
        List list = ((ListViewer)this.fViewer).getList();
        DisplayHelper.waitAndAssertCondition((Display)this.fShell.getDisplay(), () -> Assert.assertNotEquals((long)0L, (long)list.getTopIndex()));
    }

    @Test
    public void testSelectionNoRevealBug177619() throws Exception {
        TestElement model = TestElement.createModel(1, 100);
        this.fViewer.setInput((Object)model);
        this.fViewer.setSelection((ISelection)new StructuredSelection(((ListViewer)this.fViewer).getElementAt(50)), false);
        Assert.assertEquals((long)0L, (long)((ListViewer)this.fViewer).getList().getTopIndex());
    }
}

