/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jface.tests.viewers;

import java.util.Arrays;
import java.util.List;
import org.eclipse.jface.tests.viewers.TestElement;
import org.eclipse.jface.tests.viewers.TreeViewerTest;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ITreeSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreePath;
import org.eclipse.jface.viewers.TreeSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.swt.widgets.Widget;
import org.junit.Assert;
import org.junit.Test;

public class MultipleEqualElementsTreeViewerTest
extends TreeViewerTest {
    private TestElement element_2;
    private TestElement element_2_1;
    private TestElement element_2_1_2;
    private TestElement element_1;
    private TestElement element_1_3;
    private TreePath treePath_1_2_21_212;
    private TreePath treePath_1_21_212;
    private TreePath treePath_1_212;
    private TreePath treePath_2_21_212;
    private TreePath treePath_1;
    private TreePath treePath_1_21;
    private TreePath treePath_2_21;
    private TreePath treePath_1_2_21;
    private TreePath treePath_1_2;
    private TreePath treePath_2;

    public TreeViewer getTreeViewer() {
        return (TreeViewer)this.fViewer;
    }

    @Override
    protected void setUpModel() {
        this.fRootElement = TestElement.createModel(3, 10);
        this.element_2 = this.fRootElement.getChildAt(2);
        this.element_2_1 = this.element_2.getChildAt(1);
        this.element_2_1_2 = this.element_2_1.getChildAt(2);
        this.element_1 = this.fRootElement.getChildAt(1);
        this.element_1_3 = this.element_1.getChildAt(1);
        this.element_1.addChild(this.element_2, null);
        this.element_1.addChild(this.element_2_1, null);
        this.element_1.addChild(this.element_2_1_2, null);
        this.treePath_1_2_21_212 = new TreePath(new Object[]{this.element_1, this.element_2, this.element_2_1, this.element_2_1_2});
        this.treePath_1_2_21 = new TreePath(new Object[]{this.element_1, this.element_2, this.element_2_1});
        this.treePath_1 = new TreePath(new Object[]{this.element_1});
        this.treePath_2 = new TreePath(new Object[]{this.element_2});
        this.treePath_1_2 = new TreePath(new Object[]{this.element_1, this.element_2});
        this.treePath_1_21 = new TreePath(new Object[]{this.element_1, this.element_2_1});
        this.treePath_1_21_212 = new TreePath(new Object[]{this.element_1, this.element_2_1, this.element_2_1_2});
        this.treePath_1_212 = new TreePath(new Object[]{this.element_1, this.element_2_1_2});
        this.treePath_2_21_212 = new TreePath(new Object[]{this.element_2, this.element_2_1, this.element_2_1_2});
        this.treePath_2_21 = new TreePath(new Object[]{this.element_2, this.element_2_1});
        this.fModel = this.fRootElement.getModel();
    }

    @Test
    public void testElementMap() {
        this.getTreeViewer().expandToLevel((Object)this.element_1, -1);
        this.getTreeViewer().expandToLevel((Object)this.element_2, -1);
        Assert.assertEquals((long)1L, (long)this.getTreeViewer().testFindItems((Object)this.element_1).length);
        Assert.assertEquals((long)2L, (long)this.getTreeViewer().testFindItems((Object)this.element_2).length);
        Assert.assertEquals((long)3L, (long)this.getTreeViewer().testFindItems((Object)this.element_2_1).length);
        Assert.assertEquals((long)4L, (long)this.getTreeViewer().testFindItems((Object)this.element_2_1_2).length);
    }

    @Test
    public void testSelection() {
        this.getTreeViewer().expandToLevel((Object)this.element_1, -1);
        this.getTreeViewer().expandToLevel((Object)this.element_2, -1);
        this.getTreeViewer().setSelection((ISelection)new StructuredSelection((Object)this.element_1_3));
        ITreeSelection treeSelection = this.getTreeViewer().getStructuredSelection();
        Assert.assertEquals((Object)new TreeSelection(new TreePath(new Object[]{this.element_1, this.element_1_3}), null), (Object)treeSelection);
        Widget[] items = this.getTreeViewer().testFindItems((Object)this.element_2_1_2);
        TreeItem[] treeItems = new TreeItem[items.length];
        System.arraycopy(items, 0, treeItems, 0, items.length);
        Assert.assertEquals((long)4L, (long)treeItems.length);
        TreeItem[] treeItemArray = treeItems;
        int n = treeItems.length;
        int n2 = 0;
        while (n2 < n) {
            TreeItem treeItem = treeItemArray[n2];
            Assert.assertNotNull((Object)treeItem);
            ++n2;
        }
        this.getTreeViewer().getTree().setSelection(treeItems);
        treeSelection = this.getTreeViewer().getStructuredSelection();
        List<TreePath> paths = Arrays.asList(treeSelection.getPaths());
        Assert.assertEquals((long)4L, (long)paths.size());
        Assert.assertTrue((boolean)paths.contains(this.treePath_1_2_21_212));
        Assert.assertTrue((boolean)paths.contains(this.treePath_1_21_212));
        Assert.assertTrue((boolean)paths.contains(this.treePath_1_212));
        Assert.assertTrue((boolean)paths.contains(this.treePath_2_21_212));
        this.getTreeViewer().setSelection((ISelection)new TreeSelection(new TreePath[]{this.treePath_2_21_212}, null));
        Assert.assertEquals((long)1L, (long)this.getTreeViewer().getTree().getSelectionCount());
        MultipleEqualElementsTreeViewerTest.assertMatchingPath(this.treePath_2_21_212, this.getTreeViewer().getTree().getSelection()[0]);
    }

    @Test
    public void testExpansion() {
        this.getTreeViewer().expandToLevel((Object)this.treePath_1_21_212, 1);
        Assert.assertArrayEquals((String)"element expansion", (Object[])new Object[]{this.element_1, this.element_2_1}, (Object[])this.getTreeViewer().getExpandedElements());
        Assert.assertArrayEquals((String)"path expansion", (Object[])new Object[]{this.treePath_1, this.treePath_1_21}, (Object[])this.getTreeViewer().getExpandedTreePaths());
        this.getTreeViewer().setExpandedTreePaths(new TreePath[]{this.treePath_1, this.treePath_1_2, this.treePath_1_2_21, this.treePath_2, this.treePath_2_21});
        Assert.assertArrayEquals((String)"path expansion", (Object[])new Object[]{this.treePath_1, this.treePath_1_2, this.treePath_1_2_21, this.treePath_2, this.treePath_2_21}, (Object[])this.getTreeViewer().getExpandedTreePaths());
    }

    private static void assertMatchingPath(TreePath expectedPath, TreeItem item) {
        int i = expectedPath.getSegmentCount() - 1;
        while (i >= 0) {
            Assert.assertNotNull((Object)item);
            Assert.assertEquals((Object)expectedPath.getSegment(i), (Object)item.getData());
            item = item.getParentItem();
            --i;
        }
        Assert.assertNull((Object)item);
    }

    @Test
    public void testUpdate() {
        Widget item;
        Widget[] items;
        this.getTreeViewer().setExpandedTreePaths(new TreePath[]{this.treePath_1_2_21, this.treePath_2_21});
        Widget[] widgetArray = items = this.getTreeViewer().testFindItems((Object)this.element_2_1);
        int n = items.length;
        int n2 = 0;
        while (n2 < n) {
            item = widgetArray[n2];
            Assert.assertEquals((Object)"0-2-1 name-1", (Object)((TreeItem)item).getText());
            ++n2;
        }
        this.element_2_1.setLabel("billy");
        widgetArray = items;
        n = items.length;
        n2 = 0;
        while (n2 < n) {
            item = widgetArray[n2];
            Assert.assertEquals((Object)"0-2-1 billy", (Object)((TreeItem)item).getText());
            ++n2;
        }
    }

    @Test
    public void testAddWithoutMaterialize() {
        TestElement newElement = this.element_2.addChild(1);
        this.getTreeViewer().setExpandedTreePaths(new TreePath[]{this.treePath_1_2_21, this.treePath_2_21});
        Widget[] items = this.getTreeViewer().testFindItems((Object)newElement);
        Assert.assertEquals((long)2L, (long)items.length);
    }

    @Test
    public void testAddAfterMaterialize() {
        this.getTreeViewer().setExpandedTreePaths(new TreePath[]{this.treePath_1_2_21, this.treePath_2_21});
        TestElement newElement = this.element_2.addChild(1);
        this.getTreeViewer().setExpandedTreePaths(new TreePath[]{this.treePath_1_2_21, this.treePath_2_21});
        Widget[] items = this.getTreeViewer().testFindItems((Object)newElement);
        Assert.assertEquals((long)2L, (long)items.length);
    }

    @Test
    public void testRemoveWithParentAfterMaterialize() {
        this.getTreeViewer().expandToLevel((Object)this.element_1, -1);
        this.getTreeViewer().expandToLevel((Object)this.element_2, -1);
        this.element_2.basicDeleteChild(this.element_2_1);
        this.getTreeViewer().remove((Object)this.element_2, new Object[]{this.element_2_1});
        Assert.assertEquals((long)2L, (long)this.getTreeViewer().testFindItems((Object)this.element_2).length);
        Assert.assertEquals((long)1L, (long)this.getTreeViewer().testFindItems((Object)this.element_2_1).length);
        Assert.assertEquals((long)2L, (long)this.getTreeViewer().testFindItems((Object)this.element_2_1_2).length);
    }

    @Test
    public void testRemoveWithParentBeforeMaterialize() {
        this.element_2.basicDeleteChild(this.element_2_1);
        this.getTreeViewer().remove((Object)this.element_2, new Object[]{this.element_2_1});
        this.getTreeViewer().expandToLevel((Object)this.element_1, -1);
        this.getTreeViewer().expandToLevel((Object)this.element_2, -1);
        Assert.assertEquals((long)2L, (long)this.getTreeViewer().testFindItems((Object)this.element_2).length);
        Assert.assertEquals((long)1L, (long)this.getTreeViewer().testFindItems((Object)this.element_2_1).length);
        Assert.assertEquals((long)2L, (long)this.getTreeViewer().testFindItems((Object)this.element_2_1_2).length);
    }
}

