/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jface.tests.viewers;

import org.eclipse.core.runtime.Assert;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.FocusCellHighlighter;
import org.eclipse.jface.viewers.ViewerCell;
import org.eclipse.jface.viewers.ViewerRow;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;

class MyFocusBorderCellHighlighter
extends FocusCellHighlighter {
    public MyFocusBorderCellHighlighter(ColumnViewer viewer) {
        super(viewer);
        this.hookListener(viewer);
    }

    private static void markFocusedCell(Event event) {
        GC gc = event.gc;
        Rectangle rect = event.getBounds();
        gc.drawFocus(rect.x, rect.y, rect.width, rect.height);
        event.detail &= 0xFFFFFFFD;
    }

    private static void removeSelectionInformation(ViewerCell cell) {
        if (cell != null) {
            Rectangle rect = cell.getBounds();
            int x = cell.getColumnIndex() == 0 ? 0 : rect.x;
            int width = cell.getColumnIndex() == 0 ? rect.x + rect.width : rect.width;
            cell.getControl().redraw(x, rect.y, width, rect.height, true);
        }
    }

    private void hookListener(ColumnViewer viewer) {
        Listener listener = event -> {
            if ((event.detail & 2) > 0) {
                ViewerCell focusCell = this.getFocusCell();
                if (focusCell == null) {
                    return;
                }
                ViewerRow row = focusCell.getViewerRow();
                Assert.isNotNull((Object)row, (String)"Internal structure invalid. Item without associated row is not possible.");
                ViewerCell cell = row.getCell(event.index);
                if (!cell.equals((Object)focusCell)) {
                    MyFocusBorderCellHighlighter.removeSelectionInformation(cell);
                } else {
                    MyFocusBorderCellHighlighter.markFocusedCell(event);
                }
            }
        };
        viewer.getControl().addListener(40, listener);
    }

    protected Color getSelectedCellBackgroundColor(ViewerCell cell) {
        return null;
    }

    protected Color getSelectedCellForegroundColor(ViewerCell cell) {
        return null;
    }

    protected void focusCellChanged(ViewerCell newCell, ViewerCell oldCell) {
        int width;
        int x;
        Rectangle rect;
        if (newCell != null) {
            rect = newCell.getBounds();
            x = newCell.getColumnIndex() == 0 ? 0 : rect.x;
            width = newCell.getColumnIndex() == 0 ? rect.x + rect.width : rect.width;
            newCell.getControl().redraw(x, rect.y, width, rect.height, true);
        }
        if (oldCell != null) {
            rect = oldCell.getBounds();
            x = oldCell.getColumnIndex() == 0 ? 0 : rect.x;
            width = oldCell.getColumnIndex() == 0 ? rect.x + rect.width : rect.width;
            oldCell.getControl().redraw(x, rect.y, width, rect.height, true);
        }
    }
}

