/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jface.tests.viewers;

import org.eclipse.jface.tests.viewers.TestModelContentProvider;
import org.eclipse.jface.tests.viewers.ViewerTestCase;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.ColumnLabelProvider;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.ui.tests.harness.util.Mocks;
import org.junit.Assert;
import org.junit.Test;

public class SimpleTableViewerTest
extends ViewerTestCase {
    private TableViewer tableViewer;

    @Override
    protected StructuredViewer createViewer(Composite parent) {
        this.tableViewer = new TableViewer(parent);
        this.tableViewer.setContentProvider((IContentProvider)new TestModelContentProvider());
        return this.tableViewer;
    }

    @Test
    public void testNullLabel() {
        this.tableViewer.setLabelProvider((IBaseLabelProvider)new ITableLabelProvider(){

            public Image getColumnImage(Object element, int columnIndex) {
                return null;
            }

            public String getColumnText(Object element, int columnIndex) {
                return null;
            }

            public void addListener(ILabelProviderListener listener) {
            }

            public void dispose() {
            }

            public boolean isLabelProperty(Object element, String property) {
                return false;
            }

            public void removeListener(ILabelProviderListener listener) {
            }
        });
    }

    @Test
    public void testLabelProviderListeners() {
        Table table = this.tableViewer.getTable();
        new TableColumn(table, 0);
        new TableColumn(table, 0);
        ILabelProvider mockLabelProvider = (ILabelProvider)Mocks.createOrderedMock(ILabelProvider.class);
        mockLabelProvider.addListener(null);
        int count = table.getItemCount();
        int i = 0;
        while (i < count) {
            mockLabelProvider.getText(null);
            mockLabelProvider.getImage(null);
            mockLabelProvider.getText(null);
            mockLabelProvider.getImage(null);
            ++i;
        }
        Mocks.startChecking((Object)mockLabelProvider);
        this.tableViewer.setLabelProvider((IBaseLabelProvider)mockLabelProvider);
        Mocks.verify((Object)mockLabelProvider);
        mockLabelProvider.removeListener(null);
        mockLabelProvider.dispose();
        Mocks.startChecking((Object)mockLabelProvider);
        this.tableViewer.getTable().dispose();
        Mocks.verify((Object)mockLabelProvider);
    }

    @Test
    public void testLabelProviderListenersWithColumn() {
        Table table = this.tableViewer.getTable();
        new TableColumn(table, 0);
        new TableViewerColumn(this.tableViewer, 0);
        final int[] disposeCounter = new int[1];
        final int[] listenerCounter = new int[1];
        this.tableViewer.setLabelProvider((IBaseLabelProvider)new LabelProvider(){

            public void addListener(ILabelProviderListener listener) {
                listenerCounter[0] = listenerCounter[0] + 1;
                super.addListener(listener);
            }

            public void removeListener(ILabelProviderListener listener) {
                super.removeListener(listener);
                listenerCounter[0] = listenerCounter[0] - 1;
            }

            public void dispose() {
                disposeCounter[0] = disposeCounter[0] + 1;
            }
        });
        table.dispose();
        Assert.assertEquals((long)1L, (long)disposeCounter[0]);
        Assert.assertEquals((long)0L, (long)listenerCounter[0]);
    }

    @Test
    public void testColumnLabelProviderListeners() {
        Table table = this.tableViewer.getTable();
        new TableColumn(table, 0);
        TableViewerColumn tvc = new TableViewerColumn(this.tableViewer, 0);
        final int[] disposeCounter = new int[1];
        final int[] listenerCounter = new int[1];
        tvc.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public void addListener(ILabelProviderListener listener) {
                listenerCounter[0] = listenerCounter[0] + 1;
                super.addListener(listener);
            }

            public void removeListener(ILabelProviderListener listener) {
                super.removeListener(listener);
                listenerCounter[0] = listenerCounter[0] - 1;
            }

            public void dispose() {
                disposeCounter[0] = disposeCounter[0] + 1;
            }
        });
        table.dispose();
        Assert.assertEquals((long)0L, (long)listenerCounter[0]);
        Assert.assertEquals((long)1L, (long)disposeCounter[0]);
    }

    @Test
    public void testCellLabelProviderDispose() {
        final int[] disposeCounter = new int[1];
        this.tableViewer.setLabelProvider((IBaseLabelProvider)new ColumnLabelProvider(){

            public void dispose() {
                disposeCounter[0] = disposeCounter[0] + 1;
            }
        });
        this.tableViewer.getTable().dispose();
        Assert.assertEquals((long)1L, (long)disposeCounter[0]);
    }
}

