/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jface.tests.viewers;

import org.eclipse.jface.tests.viewers.TestModelContentProvider;
import org.eclipse.jface.tests.viewers.ViewerTestCase;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.TreeNode;
import org.eclipse.jface.viewers.TreeNodeContentProvider;
import org.eclipse.jface.viewers.TreePathViewerSorter;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;
import org.junit.Assert;
import org.junit.Test;

public class SimpleTreeViewerTest
extends ViewerTestCase {
    private TreeViewer treeViewer;

    @Override
    protected StructuredViewer createViewer(Composite parent) {
        this.treeViewer = new TreeViewer(parent);
        this.treeViewer.setContentProvider((IContentProvider)new TestModelContentProvider());
        return this.treeViewer;
    }

    @Test
    public void testSetTreePathViewerSorterOnNullInput() {
        this.treeViewer.setInput(null);
        this.treeViewer.setSorter((ViewerSorter)new TreePathViewerSorter());
    }

    @Test
    public void testNullLabel() {
        this.treeViewer.setLabelProvider((IBaseLabelProvider)new ITableLabelProvider(){

            public Image getColumnImage(Object element, int columnIndex) {
                return null;
            }

            public String getColumnText(Object element, int columnIndex) {
                return null;
            }

            public void addListener(ILabelProviderListener listener) {
            }

            public void dispose() {
            }

            public boolean isLabelProperty(Object element, String property) {
                return false;
            }

            public void removeListener(ILabelProviderListener listener) {
            }
        });
    }

    @Test
    public void testBug184441() {
        MyViewerSorter sorter = new MyViewerSorter();
        this.treeViewer.setComparator((ViewerComparator)sorter);
        ITreeContentProvider contentProvider = (ITreeContentProvider)this.treeViewer.getContentProvider();
        Object firstRoot = contentProvider.getElements(this.treeViewer.getInput())[0];
        Object childOfFirstRoot = contentProvider.getChildren(firstRoot)[0];
        this.treeViewer.setSelection((ISelection)new StructuredSelection(childOfFirstRoot), true);
        ISelectionChangedListener listener = event -> Assert.fail();
        this.treeViewer.addSelectionChangedListener(listener);
        sorter.inverted = true;
        this.treeViewer.refresh();
        this.treeViewer.removeSelectionChangedListener(listener);
    }

    @Test
    public void testBug184712() {
        class TableAndTreeLabelProvider
        extends LabelProvider
        implements ITableLabelProvider {
            TableAndTreeLabelProvider() {
            }

            public Image getColumnImage(Object element, int columnIndex) {
                return null;
            }

            public String getColumnText(Object element, int columnIndex) {
                return "wrong";
            }

            public String getText(Object element) {
                return "right";
            }
        }
        this.treeViewer.setLabelProvider((IBaseLabelProvider)new TableAndTreeLabelProvider());
        Assert.assertEquals((Object)"right", (Object)this.treeViewer.getTree().getItem(0).getText());
    }

    @Test
    public void test327004() {
        this.treeViewer.setInput(null);
        this.treeViewer.setContentProvider((IContentProvider)new TreeNodeContentProvider());
        final TreeNode[] children = new TreeNode[]{new TreeNode((Object)"0"), new TreeNode((Object)"1"), new TreeNode((Object)"1"), new TreeNode((Object)"1"), new TreeNode((Object)"1")};
        this.treeViewer.setInput((Object)children);
        ViewerFilter filter = new ViewerFilter(){

            public boolean select(Viewer viewer, Object parentElement, Object element) {
                return element != children[0] && element != children[1] && element != children[2] && element != children[4];
            }
        };
        this.treeViewer.setFilters(new ViewerFilter[]{filter});
        int i = this.treeViewer.getTree().getItemCount();
        Assert.assertEquals((long)4L, (long)i);
    }

    static class MyViewerSorter
    extends ViewerComparator {
        boolean inverted = false;

        MyViewerSorter() {
        }

        public int compare(Viewer viewer, Object e1, Object e2) {
            if (this.inverted) {
                return super.compare(viewer, e2, e1);
            }
            return super.compare(viewer, e1, e2);
        }
    }
}

