/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jface.tests.viewers;

import org.eclipse.jface.tests.viewers.ViewerTestCase;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILazyTreeContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.ui.tests.harness.util.DisplayHelper;
import org.junit.Assert;
import org.junit.Assume;
import org.junit.Before;
import org.junit.Test;

public class SimpleVirtualLazyTreeViewerTest
extends ViewerTestCase {
    private static final int NUM_ROOTS = 100;
    private static final int NUM_CHILDREN = 10;
    private final boolean callbacksEnabled = true;
    private final boolean printCallbacks = false;
    private int offset = 0;
    private int updateElementCallCount = 0;
    protected boolean setDataCalled = false;

    public TreeViewer getTreeViewer() {
        return (TreeViewer)this.fViewer;
    }

    @Override
    @Before
    public void setUp() {
        super.setUp();
        this.processEvents();
    }

    @Override
    protected void setInput() {
        String letterR = "R";
        this.getTreeViewer().setInput((Object)letterR);
    }

    @Override
    protected StructuredViewer createViewer(Composite parent) {
        Tree tree = new Tree((Composite)this.fShell, 0x10000002);
        TreeViewer treeViewer = new TreeViewer(tree);
        treeViewer.setContentProvider((IContentProvider)new LazyTreeContentProvider());
        tree.addListener(36, event -> {
            boolean bl = this.setDataCalled = true;
        });
        return treeViewer;
    }

    @Test
    public void testCreation() {
        Assume.assumeFalse((String)"disabled due to Bug 347491", (boolean)this.disableTestsBug347491);
        Assert.assertTrue((String)"SWT.SetData not received", (boolean)this.setDataCalled);
        this.processEvents();
        Assert.assertTrue((String)"tree should have items", (this.getTreeViewer().getTree().getItemCount() > 0 ? 1 : 0) != 0);
        Assert.assertTrue((String)"call to updateElement expected", (this.updateElementCallCount > 0 ? 1 : 0) != 0);
        Assert.assertTrue((String)"expected calls to updateElement for less than half of the items", (this.updateElementCallCount < 50 ? 1 : 0) != 0);
        Assert.assertEquals((Object)"R-0", (Object)this.getTreeViewer().getTree().getItem(0).getText());
    }

    @Test
    public void testExpand() {
        this.processEvents();
        Tree tree = this.getTreeViewer().getTree();
        this.getTreeViewer().expandToLevel((Object)"R-0", 1);
        this.processEvents();
        Assert.assertEquals((long)10L, (long)tree.getItem(0).getItemCount());
        TreeItem treeItem = tree.getItem(0).getItem(3);
        SimpleVirtualLazyTreeViewerTest.expandAndNotify(treeItem);
        tree.update();
        Assert.assertEquals((long)10L, (long)treeItem.getItemCount());
        Assert.assertEquals((long)10L, (long)treeItem.getItems().length);
    }

    private static void expandAndNotify(TreeItem treeItem) {
        Tree tree = treeItem.getParent();
        tree.setRedraw(false);
        treeItem.setExpanded(true);
        try {
            Event event = new Event();
            event.item = treeItem;
            event.type = 17;
            tree.notifyListeners(17, event);
        }
        finally {
            tree.setRedraw(true);
        }
    }

    @Test
    public void testSetSorterOnNullInput() {
        this.fViewer.setInput(null);
        this.fViewer.setSorter(new ViewerSorter());
    }

    @Test
    public void testSetComparatorOnNullInput() {
        this.fViewer.setInput(null);
        this.fViewer.setComparator(new ViewerComparator());
    }

    @Test
    public void testRemoveAt() {
        Assume.assumeFalse((String)"disabled due to Bug 347491", (boolean)this.disableTestsBug347491);
        Assert.assertTrue((String)("expected less than 50 but got " + this.updateElementCallCount), (this.updateElementCallCount < 50 ? 1 : 0) != 0);
        Assert.assertTrue((String)"SWT.SetData not received", (boolean)this.setDataCalled);
        TreeViewer treeViewer = (TreeViewer)this.fViewer;
        treeViewer.getTree().update();
        this.offset = 1;
        treeViewer.remove(treeViewer.getInput(), 3);
        Assert.assertEquals((long)99L, (long)treeViewer.getTree().getItemCount());
        treeViewer.setSelection((ISelection)new StructuredSelection(new Object[]{"R-0", "R-1"}));
        Assert.assertEquals((long)2L, (long)treeViewer.getStructuredSelection().size());
        this.processEventsUntilElementUpdated();
        this.offset = 2;
        treeViewer.remove(treeViewer.getInput(), 1);
        Assert.assertEquals((long)98L, (long)treeViewer.getTree().getItemCount());
        this.processEventsUntilElementUpdated();
        Assert.assertEquals((long)1L, (long)treeViewer.getStructuredSelection().size());
    }

    private void processEventsUntilElementUpdated() {
        this.updateElementCallCount = 0;
        DisplayHelper.waitAndAssertCondition((Display)this.fShell.getDisplay(), () -> {
            if (this.eventLoopAdjustmentBug531048) {
                if (this.updateElementCallCount > 2) {
                    Assert.assertEquals((long)2L, (long)this.updateElementCallCount);
                } else if (this.updateElementCallCount == 0) {
                    Assert.assertEquals((long)1L, (long)this.updateElementCallCount);
                }
            }
        });
    }

    private class LazyTreeContentProvider
    implements ILazyTreeContentProvider {
        private Object input;

        private LazyTreeContentProvider() {
        }

        public void updateElement(Object parent, int index) {
            ++SimpleVirtualLazyTreeViewerTest.this.updateElementCallCount;
            String parentString = (String)parent;
            String childElement = parentString + "-" + (index + SimpleVirtualLazyTreeViewerTest.this.offset);
            SimpleVirtualLazyTreeViewerTest.this.getTreeViewer().replace(parent, index, (Object)childElement);
            SimpleVirtualLazyTreeViewerTest.this.getTreeViewer().setChildCount((Object)childElement, 10);
        }

        public void dispose() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
            this.input = newInput;
        }

        public Object getParent(Object element) {
            return null;
        }

        public void updateChildCount(Object element, int currentChildCount) {
            SimpleVirtualLazyTreeViewerTest.this.getTreeViewer().setChildCount(element, element == this.input ? 100 : 10);
        }
    }
}

