/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jface.tests.viewers;

import java.util.ArrayList;
import java.util.Arrays;
import org.eclipse.jface.viewers.IElementComparer;
import org.eclipse.jface.viewers.StructuredSelection;
import org.junit.Assert;
import org.junit.Test;

public class StructuredSelectionTest {
    static final IElementComparer JAVA_LANG_OBJECT_COMPARER = new IElementComparer(){

        public int hashCode(Object element) {
            return element.hashCode() + 71;
        }

        public boolean equals(Object a, Object b) {
            return a.equals(b);
        }
    };
    static final IElementComparer IDENTITY_COMPARER = new IElementComparer(){

        public int hashCode(Object element) {
            return element.hashCode() + 97;
        }

        public boolean equals(Object a, Object b) {
            return a == b;
        }
    };

    @Test
    public void testEquals() {
        String element = "A selection";
        StructuredSelection sel1 = new StructuredSelection((Object)element);
        StructuredSelection sel2 = new StructuredSelection((Object)element);
        EqualsHashCodeContractTestHelper.testExpectedEqualsObjects(sel1, sel2);
    }

    @Test
    public void testEquals2() {
        String element1 = "A selection";
        String element2 = "A selection";
        String element3 = "Other";
        StructuredSelection sel1 = new StructuredSelection((Object)element1);
        StructuredSelection sel2 = new StructuredSelection((Object)element2);
        StructuredSelection sel3 = new StructuredSelection((Object)element3);
        EqualsHashCodeContractTestHelper.testExpectedEqualsObjects(sel1, sel2);
        EqualsHashCodeContractTestHelper.testExpectedNotEqualsObjects(sel1, sel3);
    }

    @Test
    public void testEquals3() {
        StructuredSelection empty1 = new StructuredSelection();
        StructuredSelection empty2 = new StructuredSelection();
        EqualsHashCodeContractTestHelper.testExpectedEqualsObjects(empty1, empty2);
    }

    @Test
    public void testEquals4() {
        StructuredSelection sel = new StructuredSelection((Object)"A selection");
        StructuredSelection empty = new StructuredSelection();
        EqualsHashCodeContractTestHelper.testExpectedNotEqualsObjects(sel, empty);
    }

    @Test
    public void testEquals5() {
        ArrayList<String> l1 = new ArrayList<String>();
        l1.add("element 1");
        l1.add("element 2");
        ArrayList<String> l2 = new ArrayList<String>();
        l2.add("element 2");
        l2.add("element 1");
        StructuredSelection sel1 = new StructuredSelection(l1);
        StructuredSelection sel2 = new StructuredSelection(l2);
        EqualsHashCodeContractTestHelper.testExpectedNotEqualsObjects(sel1, sel2);
    }

    @Test
    public void testEquals6() {
        ArrayList<String> l1 = new ArrayList<String>();
        l1.add("element 1");
        l1.add("element 2");
        ArrayList<String> l2 = new ArrayList<String>();
        l2.add("element 2");
        l2.add("element 3");
        l2.add("element 1");
        StructuredSelection sel1 = new StructuredSelection(l1);
        StructuredSelection sel2 = new StructuredSelection(l2);
        EqualsHashCodeContractTestHelper.testExpectedNotEqualsObjects(sel1, sel2);
    }

    @Test
    public void testEquals7() {
        StructuredSelection empty1 = new StructuredSelection();
        StructuredSelection empty2 = new StructuredSelection(new Object[0]);
        EqualsHashCodeContractTestHelper.testExpectedEqualsObjects(empty1, empty2);
    }

    @Test
    public void testEqualsFalseWithElementsContainingNull() {
        Object[] objectArray = new Object[2];
        objectArray[0] = "element 1";
        StructuredSelection s1 = new StructuredSelection(objectArray);
        StructuredSelection s2 = new StructuredSelection(new Object[]{"element 1", "element 2"});
        Assert.assertFalse((boolean)s1.equals((Object)s2));
    }

    @Test
    public void testEqualsTrueWithElementsContainingNull() {
        Object[] objectArray = new Object[2];
        objectArray[0] = "element 1";
        StructuredSelection s1 = new StructuredSelection(objectArray);
        Object[] objectArray2 = new Object[2];
        objectArray2[0] = "element 1";
        StructuredSelection s2 = new StructuredSelection(objectArray2);
        Assert.assertTrue((boolean)s1.equals((Object)s2));
    }

    @Test
    public void testEqualsWithComparer1() {
        StructuredSelectionTest.doTestEqualsWithComparer1(JAVA_LANG_OBJECT_COMPARER);
        StructuredSelectionTest.doTestEqualsWithComparer1(IDENTITY_COMPARER);
    }

    private static void doTestEqualsWithComparer1(IElementComparer comparer) {
        StructuredSelection sel1 = new StructuredSelection(Arrays.asList("A selection"), comparer);
        StructuredSelection sel2 = new StructuredSelection(Arrays.asList("A selection"), comparer);
        EqualsHashCodeContractTestHelper.testExpectedEqualsObjects(sel1, sel2);
    }

    @Test
    public void testEqualsWithComparer2() {
        StructuredSelectionTest.doTestEqualsWithComparer2(JAVA_LANG_OBJECT_COMPARER);
        StructuredSelectionTest.doTestEqualsWithComparer2(IDENTITY_COMPARER);
    }

    private static void doTestEqualsWithComparer2(IElementComparer comparer) {
        StructuredSelection sel1 = new StructuredSelection(Arrays.asList("element 1", "element 2"), comparer);
        StructuredSelection sel2 = new StructuredSelection(Arrays.asList("element 1", "element 2"), comparer);
        EqualsHashCodeContractTestHelper.testExpectedEqualsObjects(sel1, sel2);
    }

    @Test
    public void testEqualsWithComparer3() {
        StructuredSelectionTest.doTestEqualsWithComparer3(JAVA_LANG_OBJECT_COMPARER);
        StructuredSelectionTest.doTestEqualsWithComparer3(IDENTITY_COMPARER);
    }

    private static void doTestEqualsWithComparer3(IElementComparer comparer) {
        StructuredSelection sel1 = new StructuredSelection(Arrays.asList("element 1", "element 2"), comparer);
        StructuredSelection sel2 = new StructuredSelection(Arrays.asList("element 2", "element 1"), comparer);
        EqualsHashCodeContractTestHelper.testExpectedNotEqualsObjects(sel1, sel2);
    }

    @Test
    public void testEqualsWithComparer4() {
        StructuredSelectionTest.doTestEqualsWithComparer4(JAVA_LANG_OBJECT_COMPARER);
        StructuredSelectionTest.doTestEqualsWithComparer4(IDENTITY_COMPARER);
    }

    private static void doTestEqualsWithComparer4(IElementComparer comparer) {
        StructuredSelection sel1 = new StructuredSelection(new ArrayList(), comparer);
        StructuredSelection sel2 = new StructuredSelection(Arrays.asList("element 1"), comparer);
        EqualsHashCodeContractTestHelper.testExpectedNotEqualsObjects(sel1, sel2);
    }

    @Test
    public void testEqualsWithComparer5() {
        StructuredSelectionTest.doTestEqualsWithComparer5(JAVA_LANG_OBJECT_COMPARER);
        StructuredSelectionTest.doTestEqualsWithComparer5(IDENTITY_COMPARER);
    }

    private static void doTestEqualsWithComparer5(IElementComparer comparer) {
        StructuredSelection sel1 = new StructuredSelection(new ArrayList(), comparer);
        StructuredSelection sel2 = new StructuredSelection(new ArrayList(), comparer);
        EqualsHashCodeContractTestHelper.testExpectedEqualsObjects(sel1, sel2);
    }

    static class EqualsHashCodeContractTestHelper {
        private static final String HASHCODE_CONSISTENCY_MSG = "Whenever it is invoked on the same object more than once during an execution of a Java application, the hashCode method must consistently return the same integer, provided no information used in equals comparisons on the object is modified.";
        private static final String EQUALS_IMPLIES_SAME_HASHCODE_MSG = "If two objects are equal according to the equals(Object) method, then calling the hashCode method on each of the two objects must produce the same integer result.";
        private static final String REFLEXIVITY_MSG = "For any non-null reference value x, x.equals(x) should return true.";
        private static final String SYMMETRICITY_MSG = "For any non-null reference values x and y, x.equals(y) should return true if and only if y.equals(x) returns true.";
        private static final String EQUALS_CONSITENCY_MSG = "For any non-null reference values x and y, multiple invocations of x.equals(y) consistently return true or consistently return false, provided no information used in equals comparisons on the objects is modified.";
        private static final String NOT_EQUALS_NULL_MSG = "For any non-null reference value x, x.equals(null) should return false.";
        private static final int CONSISTENCY_THRESHOLD = 10;

        EqualsHashCodeContractTestHelper() {
        }

        public static void testExpectedEqualsObjects(Object o1, Object o2) {
            Assert.assertTrue((String)REFLEXIVITY_MSG, (boolean)o1.equals(o1));
            Assert.assertTrue((String)REFLEXIVITY_MSG, (boolean)o2.equals(o2));
            Assert.assertTrue((String)SYMMETRICITY_MSG, (boolean)o1.equals(o2));
            Assert.assertTrue((String)SYMMETRICITY_MSG, (boolean)o2.equals(o1));
            int i = 0;
            while (i < 10) {
                Assert.assertTrue((String)EQUALS_CONSITENCY_MSG, (boolean)o1.equals(o2));
                Assert.assertTrue((String)EQUALS_CONSITENCY_MSG, (boolean)o2.equals(o1));
                ++i;
            }
            Assert.assertFalse((String)NOT_EQUALS_NULL_MSG, (boolean)o1.equals(null));
            Assert.assertFalse((String)NOT_EQUALS_NULL_MSG, (boolean)o2.equals(null));
            Assert.assertEquals((String)EQUALS_IMPLIES_SAME_HASHCODE_MSG, (long)o1.hashCode(), (long)o2.hashCode());
            i = 0;
            while (i < 10) {
                Assert.assertEquals((String)HASHCODE_CONSISTENCY_MSG, (long)o1.hashCode(), (long)o1.hashCode());
                Assert.assertEquals((String)HASHCODE_CONSISTENCY_MSG, (long)o2.hashCode(), (long)o2.hashCode());
                ++i;
            }
        }

        public static void testExpectedNotEqualsObjects(Object o1, Object o2) {
            Assert.assertFalse((boolean)o1.equals(o2));
            Assert.assertFalse((boolean)o2.equals(o1));
        }
    }
}

