/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jface.tests.viewers;

import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.tests.viewers.TestElement;
import org.eclipse.jface.tests.viewers.TestModelChange;
import org.eclipse.jface.tests.viewers.ViewerTestCase;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.LabelProviderChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.tests.harness.util.DisplayHelper;
import org.junit.Assert;
import org.junit.Test;

public abstract class StructuredViewerTest
extends ViewerTestCase {
    protected void bulkChange(TestModelChange eventToFire) {
        TestElement first = this.fRootElement.getFirstChild();
        final TestElement newElement = first.getContainer().basicAddChild();
        this.fRootElement.basicDeleteChild(first);
        this.fModel.fireModelChanged(eventToFire);
        this.processEvents();
        new DisplayHelper(){

            protected boolean condition() {
                return StructuredViewerTest.this.fViewer.testFindItem((Object)newElement) != null;
            }
        }.waitForCondition(this.fViewer.getControl().getDisplay(), 3000L);
        Assert.assertNotNull((String)"new sibling is visible", (Object)this.fViewer.testFindItem((Object)newElement));
        Assert.assertNull((String)"first child is not visible", (Object)this.fViewer.testFindItem((Object)first));
    }

    protected abstract int getItemCount();

    protected abstract String getItemText(int var1);

    public static String providedString(String s) {
        return s + "<rendered>" + TestLabelProvider.fgSuffix;
    }

    public static String providedString(TestElement element) {
        return element.getID() + " " + element.getLabel() + "<rendered>" + TestLabelProvider.fgSuffix;
    }

    @Test
    public void testClearSelection() {
        TestElement first = this.fRootElement.getFirstChild();
        StructuredSelection selection = new StructuredSelection((Object)first);
        this.fViewer.setSelection((ISelection)selection);
        this.fViewer.setSelection((ISelection)new StructuredSelection());
        IStructuredSelection result = this.fViewer.getStructuredSelection();
        Assert.assertTrue((boolean)result.isEmpty());
    }

    @Test
    public void testDeleteChild() {
        TestElement first = this.fRootElement.getFirstChild();
        TestElement first2 = first.getFirstChild();
        first.deleteChild(first2);
        Assert.assertNull((String)"first child is not visible", (Object)this.fViewer.testFindItem((Object)first2));
    }

    @Test
    public void testDeleteInput() {
        TestElement first = this.fRootElement.getFirstChild();
        TestElement firstfirst = first.getFirstChild();
        this.fRootElement = first;
        this.setInput();
        this.fRootElement.deleteChild(first);
        Assert.assertNull((String)"first child is not visible", (Object)this.fViewer.testFindItem((Object)firstfirst));
    }

    @Test
    public void testDeleteSibling() {
        TestElement first = this.fRootElement.getFirstChild();
        Assert.assertNotNull((String)"first child is visible", (Object)this.fViewer.testFindItem((Object)first));
        this.fRootElement.deleteChild(first);
        Assert.assertNull((String)"first child is not visible", (Object)this.fViewer.testFindItem((Object)first));
    }

    @Test
    public void testDispose() {
        Assert.assertEquals((long)0L, (long)this.fViewer.getFilters().length);
        this.fViewer.addFilter(new ViewerFilter(){

            public boolean select(Viewer viewer, Object parentElement, Object element) {
                return false;
            }
        });
        Assert.assertEquals((long)1L, (long)this.fViewer.getFilters().length);
        this.fViewer.getControl().dispose();
        Assert.assertEquals((long)0L, (long)this.fViewer.getFilters().length);
    }

    @Test
    public void testFilter() {
        TestLabelFilter filter = new TestLabelFilter();
        this.fViewer.addFilter((ViewerFilter)filter);
        Assert.assertEquals((String)"filtered count", (long)5L, (long)this.getItemCount());
        this.fViewer.removeFilter((ViewerFilter)filter);
        Assert.assertEquals((String)"unfiltered count", (long)10L, (long)this.getItemCount());
    }

    @Test
    public void testSetFilters() {
        TestLabelFilter filter = new TestLabelFilter();
        this.fViewer.setFilters(new ViewerFilter[]{filter, new TestLabelFilter2()});
        Assert.assertEquals((String)"2 filters count", (long)1L, (long)this.getItemCount());
        this.fViewer.setFilters(new ViewerFilter[]{filter});
        Assert.assertEquals((String)"1 filtered count", (long)5L, (long)this.getItemCount());
        this.fViewer.setFilters(new ViewerFilter[0]);
        Assert.assertEquals((String)"unfiltered count", (long)10L, (long)this.getItemCount());
    }

    @Test
    public void testSetAndGetData() {
        Assert.assertNull((String)"get with no data", (Object)this.fViewer.getData("foo"));
        this.fViewer.setData("foo", null);
        Assert.assertNull((String)"get with no data after remove", (Object)this.fViewer.getData("foo"));
        this.fViewer.setData("foo", (Object)"bar");
        this.fViewer.setData("baz", null);
        Assert.assertNull((String)"get key which does not exist", (Object)this.fViewer.getData("baz"));
        Assert.assertNull((String)"get value instead of key", (Object)this.fViewer.getData("bar"));
        Assert.assertEquals((String)"get single value", (Object)"bar", (Object)this.fViewer.getData("foo"));
        this.fViewer.setData("foo", (Object)"baz");
        Assert.assertEquals((String)"get overridden value", (Object)"baz", (Object)this.fViewer.getData("foo"));
        this.fViewer.setData("alpha", (Object)"1");
        this.fViewer.setData("beta", (Object)"2");
        this.fViewer.setData("delta", (Object)"3");
        Assert.assertEquals((String)"get multiple values", (Object)"baz", (Object)this.fViewer.getData("foo"));
        Assert.assertEquals((String)"get multiple values", (Object)"1", (Object)this.fViewer.getData("alpha"));
        Assert.assertEquals((String)"get multiple values", (Object)"2", (Object)this.fViewer.getData("beta"));
        Assert.assertEquals((String)"get multiple values", (Object)"3", (Object)this.fViewer.getData("delta"));
        this.fViewer.setData("alpha", (Object)"10");
        Assert.assertEquals((String)"get overridden value", (Object)"10", (Object)this.fViewer.getData("alpha"));
        this.fViewer.setData("gamma", (Object)"4");
        this.fViewer.setData("epsilon", (Object)"5");
        this.fViewer.setData("foo", null);
        Assert.assertEquals((String)"get after remove", null, (Object)this.fViewer.getData("foo"));
        Assert.assertEquals((String)"get after remove", (Object)"10", (Object)this.fViewer.getData("alpha"));
        Assert.assertEquals((String)"get after remove", (Object)"2", (Object)this.fViewer.getData("beta"));
        Assert.assertEquals((String)"get after remove", (Object)"3", (Object)this.fViewer.getData("delta"));
        Assert.assertEquals((String)"get after remove", (Object)"4", (Object)this.fViewer.getData("gamma"));
        Assert.assertEquals((String)"get after remove", (Object)"5", (Object)this.fViewer.getData("epsilon"));
        this.fViewer.setData("delta", null);
        Assert.assertEquals((String)"get after remove", null, (Object)this.fViewer.getData("foo"));
        Assert.assertEquals((String)"get after remove", (Object)"10", (Object)this.fViewer.getData("alpha"));
        Assert.assertEquals((String)"get after remove", (Object)"2", (Object)this.fViewer.getData("beta"));
        Assert.assertEquals((String)"get after remove", null, (Object)this.fViewer.getData("delta"));
        Assert.assertEquals((String)"get after remove", (Object)"4", (Object)this.fViewer.getData("gamma"));
        Assert.assertEquals((String)"get after remove", (Object)"5", (Object)this.fViewer.getData("epsilon"));
        this.fViewer.setData("epsilon", null);
        Assert.assertEquals((String)"get after remove", null, (Object)this.fViewer.getData("foo"));
        Assert.assertEquals((String)"get after remove", (Object)"10", (Object)this.fViewer.getData("alpha"));
        Assert.assertEquals((String)"get after remove", (Object)"2", (Object)this.fViewer.getData("beta"));
        Assert.assertEquals((String)"get after remove", null, (Object)this.fViewer.getData("delta"));
        Assert.assertEquals((String)"get after remove", (Object)"4", (Object)this.fViewer.getData("gamma"));
        Assert.assertEquals((String)"get after remove", null, (Object)this.fViewer.getData("epsilon"));
        this.fViewer.setData("alpha", null);
        this.fViewer.setData("beta", null);
        this.fViewer.setData("gamma", null);
        Assert.assertEquals((String)"get after remove", null, (Object)this.fViewer.getData("foo"));
        Assert.assertEquals((String)"get after remove", null, (Object)this.fViewer.getData("alpha"));
        Assert.assertEquals((String)"get after remove", null, (Object)this.fViewer.getData("beta"));
        Assert.assertEquals((String)"get after remove", null, (Object)this.fViewer.getData("delta"));
        Assert.assertEquals((String)"get after remove", null, (Object)this.fViewer.getData("gamma"));
        Assert.assertEquals((String)"get after remove", null, (Object)this.fViewer.getData("epsilon"));
    }

    @Test
    public void testInsertChild() {
        TestElement first = this.fRootElement.getFirstChild();
        TestElement newElement = first.addChild(1);
        Assert.assertNull((String)"new sibling is not visible", (Object)this.fViewer.testFindItem((Object)newElement));
    }

    @Test
    public void testInsertSibling() {
        final TestElement newElement = this.fRootElement.addChild(1);
        this.processEvents();
        new DisplayHelper(){

            protected boolean condition() {
                return StructuredViewerTest.this.fViewer.testFindItem((Object)newElement) != null;
            }
        }.waitForCondition(this.fViewer.getControl().getDisplay(), 3000L);
        Assert.assertNotNull((String)"new sibling is visible", (Object)this.fViewer.testFindItem((Object)newElement));
    }

    @Test
    public void testInsertSiblingReveal() {
        TestElement newElement = this.fRootElement.addChild(17);
        Assert.assertNotNull((String)"new sibling is visible", (Object)this.fViewer.testFindItem((Object)newElement));
    }

    @Test
    public void testInsertSiblings() {
        final TestElement[] newElements = this.fRootElement.addChildren(1);
        this.processEvents();
        new DisplayHelper(){

            protected boolean condition() {
                return StructuredViewerTest.this.fViewer.testFindItem((Object)newElements[newElements.length - 1]) != null;
            }
        }.waitForCondition(this.fViewer.getControl().getDisplay(), 3000L);
        TestElement[] testElementArray = newElements;
        int n = newElements.length;
        int n2 = 0;
        while (n2 < n) {
            TestElement newElement = testElementArray[n2];
            Assert.assertNotNull((String)"new siblings are visible", (Object)this.fViewer.testFindItem((Object)newElement));
            ++n2;
        }
    }

    @Test
    public void testInsertSiblingSelectExpanded() {
        final TestElement newElement = this.fRootElement.addChild(49);
        this.processEvents();
        new DisplayHelper(){

            protected boolean condition() {
                return StructuredViewerTest.this.fViewer.testFindItem((Object)newElement) != null;
            }
        }.waitForCondition(this.fViewer.getControl().getDisplay(), 3000L);
        Assert.assertNotNull((String)"new sibling is visible", (Object)this.fViewer.testFindItem((Object)newElement));
        this.assertSelectionEquals("new element is selected", newElement);
    }

    @Test
    public void testInsertSiblingWithFilterFiltered() {
        this.fViewer.addFilter((ViewerFilter)new TestLabelFilter());
        TestElement newElement = new TestElement(this.fModel, this.fRootElement);
        newElement.setLabel("name-111");
        this.fRootElement.addChild(newElement, new TestModelChange(49, this.fRootElement, newElement));
        Assert.assertNull((String)"new sibling is not visible", (Object)this.fViewer.testFindItem((Object)newElement));
        Assert.assertEquals((long)5L, (long)this.getItemCount());
    }

    @Test
    public void testInsertSiblingWithFilterNotFiltered() {
        this.fViewer.addFilter((ViewerFilter)new TestLabelFilter());
        TestElement newElement = new TestElement(this.fModel, this.fRootElement);
        newElement.setLabel("name-222");
        this.fRootElement.addChild(newElement, new TestModelChange(49, this.fRootElement, newElement));
        Assert.assertNotNull((String)"new sibling is visible", (Object)this.fViewer.testFindItem((Object)newElement));
        Assert.assertEquals((long)6L, (long)this.getItemCount());
    }

    @Test
    public void testInsertSiblingWithSorter() {
        this.fViewer.setComparator((ViewerComparator)new TestLabelComparator());
        TestElement newElement = new TestElement(this.fModel, this.fRootElement);
        newElement.setLabel("name-9999");
        this.fRootElement.addChild(newElement, new TestModelChange(49, this.fRootElement, newElement));
        String newLabel = newElement.toString();
        Assert.assertEquals((String)"sorted first", (Object)newLabel, (Object)this.getItemText(0));
        this.assertSelectionEquals("new element is selected", newElement);
    }

    @Test
    public void testLabelProvider() {
        this.fViewer.setLabelProvider(this.getTestLabelProvider());
        TestElement first = this.fRootElement.getFirstChild();
        String newLabel = StructuredViewerTest.providedString(first);
        Assert.assertEquals((String)"rendered label", (Object)newLabel, (Object)this.getItemText(0));
    }

    public IBaseLabelProvider getTestLabelProvider() {
        return new TestLabelProvider();
    }

    @Test
    public void testLabelProviderStateChange() {
        TestLabelProvider provider = new TestLabelProvider();
        this.fViewer.setLabelProvider((IBaseLabelProvider)provider);
        provider.setSuffix("added suffix");
        TestElement first = this.fRootElement.getFirstChild();
        String newLabel = StructuredViewerTest.providedString(first);
        Assert.assertEquals((String)"rendered label", (Object)newLabel, (Object)this.getItemText(0));
    }

    @Test
    public void testRename() {
        TestElement first = this.fRootElement.getFirstChild();
        String newLabel = first.getLabel() + " changed";
        first.setLabel(newLabel);
        Assert.assertEquals((String)"changed label", (Object)(first.getID() + " " + newLabel), (Object)this.getItemText(0));
    }

    @Test
    public void testRenameWithFilter() {
        this.fViewer.addFilter((ViewerFilter)new TestLabelFilter());
        TestElement first = this.fRootElement.getFirstChild();
        first.setLabel("name-1111");
        Assert.assertNull((String)"changed sibling is not visible", (Object)this.fViewer.testFindItem((Object)first));
        first.setLabel("name-2222");
        this.fViewer.refresh();
        Assert.assertNotNull((String)"changed sibling is not visible", (Object)this.fViewer.testFindItem((Object)first));
    }

    @Test
    public void testRenameWithLabelProvider() {
        if (this.fViewer instanceof TableViewer) {
            return;
        }
        this.fViewer.setLabelProvider((IBaseLabelProvider)new TestLabelProvider());
        TestElement first = this.fRootElement.getFirstChild();
        first.setLabel("changed name");
        String newLabel = StructuredViewerTest.providedString(first);
        Assert.assertEquals((String)"rendered label", (Object)newLabel, (Object)this.getItemText(0));
    }

    @Test
    public void testRenameWithSorter() {
        this.fViewer.setComparator((ViewerComparator)new TestLabelComparator());
        TestElement first = this.fRootElement.getFirstChild();
        first.setLabel("name-9999");
        String newElementLabel = first.toString();
        Assert.assertEquals((String)"sorted first", (Object)newElementLabel, (Object)this.getItemText(0));
    }

    @Test
    public void testSetInput() {
        TestElement first = this.fRootElement.getFirstChild();
        final TestElement firstfirst = first.getFirstChild();
        this.fRootElement = first;
        this.setInput();
        this.processEvents();
        new DisplayHelper(){

            protected boolean condition() {
                return StructuredViewerTest.this.fViewer.testFindItem((Object)firstfirst) != null;
            }
        }.waitForCondition(this.fViewer.getControl().getDisplay(), 3000L);
        Assert.assertNotNull((String)"first child is visible", (Object)this.fViewer.testFindItem((Object)firstfirst));
    }

    @Test
    public void testSetSelection() {
        TestElement first = this.fRootElement.getFirstChild();
        StructuredSelection selection = new StructuredSelection((Object)first);
        this.fViewer.setSelection((ISelection)selection);
        IStructuredSelection result = this.fViewer.getStructuredSelection();
        Assert.assertEquals((long)1L, (long)result.size());
        Assert.assertEquals((Object)first, (Object)result.getFirstElement());
    }

    @Test
    public void testSomeChildrenChanged() {
        this.bulkChange(new TestModelChange(3, this.fRootElement));
    }

    @Test
    public void testSorter() {
        TestElement first = this.fRootElement.getFirstChild();
        TestElement last = this.fRootElement.getLastChild();
        int size = this.fRootElement.getChildCount();
        String firstLabel = first.toString();
        String lastLabel = last.toString();
        Assert.assertEquals((String)"unsorted", (Object)firstLabel, (Object)this.getItemText(0));
        Assert.assertEquals((String)"unsorted", (Object)lastLabel, (Object)this.getItemText(size - 1));
        this.fViewer.setComparator((ViewerComparator)new TestLabelComparator());
        Assert.assertEquals((String)"reverse sorted", (Object)firstLabel, (Object)this.getItemText(size - 1));
        Assert.assertEquals((String)"reverse sorted", (Object)lastLabel, (Object)this.getItemText(0));
        this.fViewer.setComparator(null);
        Assert.assertEquals((String)"unsorted", (Object)firstLabel, (Object)this.getItemText(0));
        Assert.assertEquals((String)"unsorted", (Object)lastLabel, (Object)this.getItemText(size - 1));
    }

    @Test
    public void testWorldChanged() {
        this.bulkChange(new TestModelChange(3, null));
    }

    public static class TestLabelComparator
    extends ViewerComparator {
        public int compare(Viewer v, Object e1, Object e2) {
            String name1 = ((TestElement)e1).getLabel();
            String name2 = ((TestElement)e2).getLabel();
            return name2.compareTo(name1);
        }

        public boolean isSorterProperty(Object element, String property) {
            return property.equals("org.eclipse.jface.text");
        }
    }

    public static class TestLabelFilter
    extends ViewerFilter {
        public boolean select(Viewer viewer, Object parent, Object element) {
            String label = ((TestElement)element).getLabel();
            int count = label.indexOf(45);
            if (count < 0) {
                return false;
            }
            String number = label.substring(count + 1);
            return Integer.parseInt(number) % 2 == 0;
        }

        public boolean isFilterProperty(Object element, String property) {
            return property.equals("org.eclipse.jface.text");
        }
    }

    public static class TestLabelFilter2
    extends ViewerFilter {
        public boolean select(Viewer viewer, Object parent, Object element) {
            String label = ((TestElement)element).getLabel();
            int count = label.indexOf(45);
            if (count < 0) {
                return false;
            }
            String number = label.substring(count + 1);
            return Integer.parseInt(number) == 0;
        }

        public boolean isFilterProperty(Object element, String property) {
            return property.equals("org.eclipse.jface.text");
        }
    }

    public static class TestLabelProvider
    extends LabelProvider {
        public static String fgSuffix = "";
        static Image fgImage = ImageDescriptor.createFromFile(TestLabelProvider.class, (String)"images/java.gif").createImage();

        public String getText(Object element) {
            return StructuredViewerTest.providedString((TestElement)element);
        }

        public Image getImage(Object element) {
            return fgImage;
        }

        public void setSuffix(String suffix) {
            fgSuffix = suffix;
            this.fireLabelProviderChanged(new LabelProviderChangedEvent((IBaseLabelProvider)this));
        }
    }
}

