/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jface.tests.viewers;

import org.eclipse.jface.viewers.StyledString;
import org.eclipse.swt.custom.StyleRange;
import org.eclipse.swt.graphics.TextStyle;
import org.junit.Assert;
import org.junit.Test;

public class StyledStringBuilderTest {
    public static final TestStyler STYLER1 = new TestStyler(4);
    public static final TestStyler STYLER2 = new TestStyler(2);

    @Test
    public void testEmpty() {
        StyledString styledString = new StyledString();
        String str = "";
        Assert.assertEquals((long)str.length(), (long)styledString.length());
        Assert.assertEquals((Object)str, (Object)styledString.getString());
        Assert.assertEquals((long)styledString.getStyleRanges().length, (long)0L);
    }

    @Test
    public void testAppendString1() {
        StyledString styledString = new StyledString();
        String str = "Hello";
        styledString.append(str, (StyledString.Styler)STYLER1);
        Assert.assertEquals((long)str.length(), (long)styledString.length());
        Assert.assertEquals((Object)str, (Object)styledString.getString());
        StyleRange[] styleRanges = styledString.getStyleRanges();
        Assert.assertEquals((long)1L, (long)styleRanges.length);
        StyledStringBuilderTest.assertRangeEquals(styleRanges[0], STYLER1, 0, str.length());
    }

    @Test
    public void testAppendString2() {
        StyledString styledString = new StyledString();
        String str1 = "Hello";
        String str2 = "You";
        styledString.append(str1);
        styledString.append(str2, (StyledString.Styler)STYLER1);
        String res = str1 + str2;
        Assert.assertEquals((long)res.length(), (long)styledString.length());
        Assert.assertEquals((Object)res, (Object)styledString.getString());
        StyleRange[] styleRanges = styledString.getStyleRanges();
        Assert.assertEquals((long)1L, (long)styleRanges.length);
        StyledStringBuilderTest.assertRangeEquals(styleRanges[0], STYLER1, str1.length(), str2.length());
    }

    @Test
    public void testAppendString3() {
        StyledString styledString = new StyledString();
        String str1 = "Hello";
        String str2 = "You";
        styledString.append(str1, (StyledString.Styler)STYLER1);
        styledString.append(str2);
        String res = str1 + str2;
        Assert.assertEquals((long)res.length(), (long)styledString.length());
        Assert.assertEquals((Object)res, (Object)styledString.getString());
        StyleRange[] styleRanges = styledString.getStyleRanges();
        Assert.assertEquals((long)1L, (long)styleRanges.length);
        StyledStringBuilderTest.assertRangeEquals(styleRanges[0], STYLER1, 0, str1.length());
    }

    @Test
    public void testAppendString4() {
        StyledString styledString = new StyledString();
        String str1 = "Hello";
        String str2 = "You";
        styledString.append(str1);
        styledString.append(str2, (StyledString.Styler)STYLER1);
        styledString.append(str2, (StyledString.Styler)STYLER1);
        String res = str1 + str2 + str2;
        Assert.assertEquals((long)res.length(), (long)styledString.length());
        Assert.assertEquals((Object)res, (Object)styledString.getString());
        StyleRange[] styleRanges = styledString.getStyleRanges();
        Assert.assertEquals((long)1L, (long)styleRanges.length);
        StyledStringBuilderTest.assertRangeEquals(styleRanges[0], STYLER1, str1.length(), str2.length() * 2);
    }

    @Test
    public void testAppendString5() {
        StyledString styledString = new StyledString();
        String str1 = "Hello";
        String str2 = "You";
        String str3 = "Me";
        styledString.append(str1);
        styledString.append(str2, (StyledString.Styler)STYLER1);
        styledString.append(str3, (StyledString.Styler)STYLER2);
        String res = str1 + str2 + str3;
        Assert.assertEquals((long)res.length(), (long)styledString.length());
        Assert.assertEquals((Object)res, (Object)styledString.getString());
        StyleRange[] styleRanges = styledString.getStyleRanges();
        Assert.assertEquals((long)2L, (long)styleRanges.length);
        StyledStringBuilderTest.assertRangeEquals(styleRanges[0], STYLER1, str1.length(), str2.length());
        StyledStringBuilderTest.assertRangeEquals(styleRanges[1], STYLER2, str1.length() + str2.length(), str3.length());
    }

    @Test
    public void testAppendString6() {
        StyledString styledString = new StyledString();
        String str1 = "Hello";
        String str2 = "You";
        String str3 = "Me";
        styledString.append(str1, (StyledString.Styler)STYLER1);
        styledString.append(str2);
        styledString.append(str3, (StyledString.Styler)STYLER2);
        String res = str1 + str2 + str3;
        Assert.assertEquals((long)res.length(), (long)styledString.length());
        Assert.assertEquals((Object)res, (Object)styledString.getString());
        StyleRange[] styleRanges = styledString.getStyleRanges();
        Assert.assertEquals((long)2L, (long)styleRanges.length);
        StyledStringBuilderTest.assertRangeEquals(styleRanges[0], STYLER1, 0, str1.length());
        StyledStringBuilderTest.assertRangeEquals(styleRanges[1], STYLER2, str1.length() + str2.length(), str3.length());
    }

    @Test
    public void testAppendString7() {
        StyledString styledString = new StyledString();
        String str1 = "Hello";
        String str2 = "";
        String str3 = "Me";
        styledString.append(str1, (StyledString.Styler)STYLER1);
        styledString.append(str2, (StyledString.Styler)STYLER2);
        styledString.append(str3, (StyledString.Styler)STYLER1);
        String res = str1 + str2 + str3;
        Assert.assertEquals((long)res.length(), (long)styledString.length());
        Assert.assertEquals((Object)res, (Object)styledString.getString());
        StyleRange[] styleRanges = styledString.getStyleRanges();
        Assert.assertEquals((long)1L, (long)styleRanges.length);
        StyledStringBuilderTest.assertRangeEquals(styleRanges[0], STYLER1, 0, res.length());
    }

    @Test
    public void testAppendChar1() {
        StyledString styledString = new StyledString();
        styledString.append('H', (StyledString.Styler)STYLER1);
        styledString.append('2', (StyledString.Styler)STYLER2);
        styledString.append('O', (StyledString.Styler)STYLER1);
        String res = "H2O";
        Assert.assertEquals((long)res.length(), (long)styledString.length());
        Assert.assertEquals((Object)res, (Object)styledString.getString());
        StyleRange[] styleRanges = styledString.getStyleRanges();
        Assert.assertEquals((long)3L, (long)styleRanges.length);
        StyledStringBuilderTest.assertRangeEquals(styleRanges[0], STYLER1, 0, 1);
        StyledStringBuilderTest.assertRangeEquals(styleRanges[1], STYLER2, 1, 1);
        StyledStringBuilderTest.assertRangeEquals(styleRanges[2], STYLER1, 2, 1);
    }

    @Test
    public void testAppendChar2() {
        StyledString styledString = new StyledString();
        styledString.append('H', (StyledString.Styler)STYLER1);
        styledString.append('2');
        styledString.append('O', (StyledString.Styler)STYLER2);
        String res = "H2O";
        Assert.assertEquals((long)res.length(), (long)styledString.length());
        Assert.assertEquals((Object)res, (Object)styledString.getString());
        StyleRange[] styleRanges = styledString.getStyleRanges();
        Assert.assertEquals((long)2L, (long)styleRanges.length);
        StyledStringBuilderTest.assertRangeEquals(styleRanges[0], STYLER1, 0, 1);
        StyledStringBuilderTest.assertRangeEquals(styleRanges[1], STYLER2, 2, 1);
    }

    @Test
    public void testAppendStyledString1() {
        StyledString other = new StyledString();
        String str2 = "You";
        String str3 = "Me";
        other.append(str2, (StyledString.Styler)STYLER1);
        other.append(str3, (StyledString.Styler)STYLER2);
        String str1 = "We";
        StyledString styledString = new StyledString(str1);
        styledString.append(other);
        String res = str1 + str2 + str3;
        Assert.assertEquals((long)res.length(), (long)styledString.length());
        Assert.assertEquals((Object)res, (Object)styledString.getString());
        StyleRange[] styleRanges = styledString.getStyleRanges();
        Assert.assertEquals((long)2L, (long)styleRanges.length);
        StyledStringBuilderTest.assertRangeEquals(styleRanges[0], STYLER1, str1.length(), str2.length());
        StyledStringBuilderTest.assertRangeEquals(styleRanges[1], STYLER2, str1.length() + str2.length(), str3.length());
    }

    @Test
    public void testAppendStyledString2() {
        StyledString other = new StyledString();
        String str2 = "You";
        String str3 = "Me";
        other.append(str2, (StyledString.Styler)STYLER1);
        other.append(str3, (StyledString.Styler)STYLER2);
        String str1 = "We";
        StyledString styledString = new StyledString(str1, (StyledString.Styler)STYLER1);
        styledString.append(other);
        String res = str1 + str2 + str3;
        Assert.assertEquals((long)res.length(), (long)styledString.length());
        Assert.assertEquals((Object)res, (Object)styledString.getString());
        StyleRange[] styleRanges = styledString.getStyleRanges();
        Assert.assertEquals((long)2L, (long)styleRanges.length);
        StyledStringBuilderTest.assertRangeEquals(styleRanges[0], STYLER1, 0, str1.length() + str2.length());
        StyledStringBuilderTest.assertRangeEquals(styleRanges[1], STYLER2, str1.length() + str2.length(), str3.length());
    }

    @Test
    public void testAppendStyledString3() {
        StyledString other = new StyledString();
        String str2 = "You";
        String str3 = "Me";
        other.append(str2);
        other.append(str3, (StyledString.Styler)STYLER2);
        String str1 = "We";
        StyledString styledString = new StyledString(str1, (StyledString.Styler)STYLER1);
        styledString.append(other);
        String res = str1 + str2 + str3;
        Assert.assertEquals((long)res.length(), (long)styledString.length());
        Assert.assertEquals((Object)res, (Object)styledString.getString());
        StyleRange[] styleRanges = styledString.getStyleRanges();
        Assert.assertEquals((long)2L, (long)styleRanges.length);
        StyledStringBuilderTest.assertRangeEquals(styleRanges[0], STYLER1, 0, str1.length());
        StyledStringBuilderTest.assertRangeEquals(styleRanges[1], STYLER2, str1.length() + str2.length(), str3.length());
    }

    @Test
    public void testAppendStyledString4() {
        StyledString other = new StyledString();
        String str2 = "You";
        String str3 = "Me";
        other.append(str2, (StyledString.Styler)STYLER2);
        other.append(str3);
        String str1 = "We";
        StyledString styledString = new StyledString(str1, (StyledString.Styler)STYLER1);
        styledString.append(other);
        String res = str1 + str2 + str3;
        Assert.assertEquals((long)res.length(), (long)styledString.length());
        Assert.assertEquals((Object)res, (Object)styledString.getString());
        StyleRange[] styleRanges = styledString.getStyleRanges();
        Assert.assertEquals((long)2L, (long)styleRanges.length);
        StyledStringBuilderTest.assertRangeEquals(styleRanges[0], STYLER1, 0, str1.length());
        StyledStringBuilderTest.assertRangeEquals(styleRanges[1], STYLER2, str1.length(), str2.length());
    }

    @Test
    public void testAppendStyledString5() {
        StyledString other = new StyledString();
        String str2 = "You";
        String str3 = "Me";
        other.append(str2);
        other.append(str3, (StyledString.Styler)STYLER1);
        String str1 = "We";
        StyledString styledString = new StyledString(str1);
        styledString.append(other);
        String res = str1 + str2 + str3;
        Assert.assertEquals((long)res.length(), (long)styledString.length());
        Assert.assertEquals((Object)res, (Object)styledString.getString());
        StyleRange[] styleRanges = styledString.getStyleRanges();
        Assert.assertEquals((long)1L, (long)styleRanges.length);
        StyledStringBuilderTest.assertRangeEquals(styleRanges[0], STYLER1, str1.length() + str2.length(), str3.length());
    }

    @Test
    public void testSetStyle1() {
        String str1 = "One";
        String str2 = "Two";
        String str3 = "Three";
        String res = str1 + str2 + str3;
        StyledString styledString = new StyledString();
        styledString.append(res);
        styledString.setStyle(0, str1.length(), (StyledString.Styler)STYLER1);
        Assert.assertEquals((long)res.length(), (long)styledString.length());
        Assert.assertEquals((Object)res, (Object)styledString.getString());
        StyleRange[] styleRanges = styledString.getStyleRanges();
        Assert.assertEquals((long)1L, (long)styleRanges.length);
        StyledStringBuilderTest.assertRangeEquals(styleRanges[0], STYLER1, 0, str1.length());
    }

    @Test
    public void testSetStyle2() {
        String str1 = "One";
        String str2 = "Two";
        String str3 = "Three";
        String res = str1 + str2 + str3;
        StyledString styledString = new StyledString();
        styledString.append(res);
        styledString.setStyle(str1.length(), str2.length(), (StyledString.Styler)STYLER1);
        Assert.assertEquals((long)res.length(), (long)styledString.length());
        Assert.assertEquals((Object)res, (Object)styledString.getString());
        StyleRange[] styleRanges = styledString.getStyleRanges();
        Assert.assertEquals((long)1L, (long)styleRanges.length);
        StyledStringBuilderTest.assertRangeEquals(styleRanges[0], STYLER1, str1.length(), str2.length());
    }

    @Test
    public void testSetStyle3() {
        String str1 = "One";
        String str2 = "Two";
        String str3 = "Three";
        String res = str1 + str2 + str3;
        StyledString styledString = new StyledString();
        styledString.append(res);
        styledString.setStyle(str1.length(), res.length() - str1.length(), (StyledString.Styler)STYLER1);
        Assert.assertEquals((long)res.length(), (long)styledString.length());
        Assert.assertEquals((Object)res, (Object)styledString.getString());
        StyleRange[] styleRanges = styledString.getStyleRanges();
        Assert.assertEquals((long)1L, (long)styleRanges.length);
        StyledStringBuilderTest.assertRangeEquals(styleRanges[0], STYLER1, str1.length(), res.length() - str1.length());
    }

    @Test
    public void testSetStyle4() {
        String str1 = "One";
        String str2 = "Two";
        String str3 = "Three";
        String res = str1 + str2 + str3;
        StyledString styledString = new StyledString();
        styledString.append(res);
        styledString.setStyle(0, res.length(), (StyledString.Styler)STYLER1);
        Assert.assertEquals((long)res.length(), (long)styledString.length());
        Assert.assertEquals((Object)res, (Object)styledString.getString());
        StyleRange[] styleRanges = styledString.getStyleRanges();
        Assert.assertEquals((long)1L, (long)styleRanges.length);
        StyledStringBuilderTest.assertRangeEquals(styleRanges[0], STYLER1, 0, res.length());
    }

    @Test
    public void testSetStyle5() {
        String str1 = "One";
        String str2 = "Two";
        String str3 = "Three";
        String res = str1 + str2 + str3;
        StyledString styledString = new StyledString();
        styledString.append(res);
        styledString.setStyle(0, res.length(), null);
        Assert.assertEquals((long)res.length(), (long)styledString.length());
        Assert.assertEquals((Object)res, (Object)styledString.getString());
        StyleRange[] styleRanges = styledString.getStyleRanges();
        Assert.assertEquals((long)0L, (long)styleRanges.length);
    }

    @Test
    public void testSetStyle6() {
        String str1 = "One";
        String str2 = "Two";
        String res = str1 + str2;
        StyledString styledString = new StyledString(str1, (StyledString.Styler)STYLER1);
        styledString.append(str2);
        styledString.setStyle(str1.length(), str2.length(), (StyledString.Styler)STYLER2);
        Assert.assertEquals((long)res.length(), (long)styledString.length());
        Assert.assertEquals((Object)res, (Object)styledString.getString());
        StyleRange[] styleRanges = styledString.getStyleRanges();
        Assert.assertEquals((long)2L, (long)styleRanges.length);
        StyledStringBuilderTest.assertRangeEquals(styleRanges[0], STYLER1, 0, str1.length());
        StyledStringBuilderTest.assertRangeEquals(styleRanges[1], STYLER2, str1.length(), str2.length());
    }

    @Test
    public void testSetStyleInsert() {
        String str1 = "One";
        String str2 = "Two";
        String str3 = "Three";
        String res = str1 + str2 + str3;
        StyledString styledString = new StyledString(str1);
        styledString.append(str2 + str3, (StyledString.Styler)STYLER1);
        styledString.setStyle(str1.length() + 1, str2.length(), (StyledString.Styler)STYLER2);
        Assert.assertEquals((long)res.length(), (long)styledString.length());
        Assert.assertEquals((Object)res, (Object)styledString.getString());
        StyleRange[] styleRanges = styledString.getStyleRanges();
        Assert.assertEquals((long)3L, (long)styleRanges.length);
        StyledStringBuilderTest.assertRangeEquals(styleRanges[0], STYLER1, str1.length(), 1);
        StyledStringBuilderTest.assertRangeEquals(styleRanges[1], STYLER2, str1.length() + 1, str2.length());
        StyledStringBuilderTest.assertRangeEquals(styleRanges[2], STYLER1, str1.length() + str2.length() + 1, str3.length() - 1);
    }

    @Test
    public void testSetStyleInsert2() {
        String str1 = "one";
        String str2 = "two";
        String res = str1 + str2;
        StyledString styledString = new StyledString(res);
        styledString.setStyle(0, str1.length(), (StyledString.Styler)STYLER1);
        styledString.setStyle(str1.length(), 1, (StyledString.Styler)STYLER1);
        Assert.assertEquals((long)res.length(), (long)styledString.length());
        Assert.assertEquals((Object)res, (Object)styledString.getString());
        StyleRange[] styleRanges = styledString.getStyleRanges();
        Assert.assertEquals((long)1L, (long)styleRanges.length);
        StyledStringBuilderTest.assertRangeEquals(styleRanges[0], STYLER1, 0, str1.length() + 1);
    }

    @Test
    public void testSetStyle7() {
        String str1 = "One";
        String str2 = "Two";
        String res = str1 + str2;
        StyledString styledString = new StyledString(str1);
        styledString.append(str2, (StyledString.Styler)STYLER1);
        styledString.setStyle(0, str1.length(), (StyledString.Styler)STYLER2);
        Assert.assertEquals((long)res.length(), (long)styledString.length());
        Assert.assertEquals((Object)res, (Object)styledString.getString());
        StyleRange[] styleRanges = styledString.getStyleRanges();
        Assert.assertEquals((long)2L, (long)styleRanges.length);
        StyledStringBuilderTest.assertRangeEquals(styleRanges[0], STYLER2, 0, str1.length());
        StyledStringBuilderTest.assertRangeEquals(styleRanges[1], STYLER1, str1.length(), str2.length());
    }

    @Test
    public void testSetStyle8() {
        String str1 = "One";
        String str2 = "Two";
        String res = str1 + str2;
        StyledString styledString = new StyledString();
        styledString.append(str1, (StyledString.Styler)STYLER1);
        styledString.append(str2, (StyledString.Styler)STYLER2);
        styledString.setStyle(0, str1.length(), (StyledString.Styler)STYLER2);
        Assert.assertEquals((long)res.length(), (long)styledString.length());
        Assert.assertEquals((Object)res, (Object)styledString.getString());
        StyleRange[] styleRanges = styledString.getStyleRanges();
        Assert.assertEquals((long)1L, (long)styleRanges.length);
        StyledStringBuilderTest.assertRangeEquals(styleRanges[0], STYLER2, 0, res.length());
    }

    @Test
    public void testSetStyle9() {
        String str1 = "One";
        String str2 = "Two";
        String res = str1 + str2;
        StyledString styledString = new StyledString();
        styledString.append(str1, (StyledString.Styler)STYLER1);
        styledString.append(str2, (StyledString.Styler)STYLER2);
        styledString.setStyle(0, res.length(), null);
        Assert.assertEquals((long)res.length(), (long)styledString.length());
        Assert.assertEquals((Object)res, (Object)styledString.getString());
        StyleRange[] styleRanges = styledString.getStyleRanges();
        Assert.assertEquals((long)0L, (long)styleRanges.length);
    }

    @Test
    public void testSetStyle10() {
        String str1 = "One";
        String str2 = "Two";
        String res = str1 + str2;
        StyledString styledString = new StyledString();
        styledString.append(str1, (StyledString.Styler)STYLER1);
        styledString.append(str2, (StyledString.Styler)STYLER2);
        styledString.setStyle(1, res.length() - 2, null);
        Assert.assertEquals((long)res.length(), (long)styledString.length());
        Assert.assertEquals((Object)res, (Object)styledString.getString());
        StyleRange[] styleRanges = styledString.getStyleRanges();
        Assert.assertEquals((long)2L, (long)styleRanges.length);
        StyledStringBuilderTest.assertRangeEquals(styleRanges[0], STYLER1, 0, 1);
        StyledStringBuilderTest.assertRangeEquals(styleRanges[1], STYLER2, res.length() - 1, 1);
    }

    @Test
    public void testSetStyle11() {
        String str1 = "One";
        String str2 = "Two";
        String res = str1 + str2;
        StyledString styledString = new StyledString();
        styledString.append(str1, (StyledString.Styler)STYLER1);
        styledString.append(str2, (StyledString.Styler)STYLER2);
        styledString.setStyle(1, res.length() - 1, (StyledString.Styler)STYLER1);
        Assert.assertEquals((long)res.length(), (long)styledString.length());
        Assert.assertEquals((Object)res, (Object)styledString.getString());
        StyleRange[] styleRanges = styledString.getStyleRanges();
        Assert.assertEquals((long)1L, (long)styleRanges.length);
        StyledStringBuilderTest.assertRangeEquals(styleRanges[0], STYLER1, 0, res.length());
    }

    @Test
    public void testSetStyle12() {
        String str1 = "One";
        String str2 = "Two";
        String res = str1 + str2;
        StyledString styledString = new StyledString();
        styledString.append(str1, (StyledString.Styler)STYLER1);
        styledString.append(str2, (StyledString.Styler)STYLER2);
        styledString.setStyle(0, res.length() - 1, (StyledString.Styler)STYLER2);
        Assert.assertEquals((long)res.length(), (long)styledString.length());
        Assert.assertEquals((Object)res, (Object)styledString.getString());
        StyleRange[] styleRanges = styledString.getStyleRanges();
        Assert.assertEquals((long)1L, (long)styleRanges.length);
        StyledStringBuilderTest.assertRangeEquals(styleRanges[0], STYLER2, 0, res.length());
    }

    @Test
    public void testSetStyle13() {
        String str1 = "One";
        String str2 = "Two";
        String res = str1 + str2;
        StyledString styledString = new StyledString();
        styledString.append(str1, (StyledString.Styler)STYLER1);
        styledString.append(str2, (StyledString.Styler)STYLER2);
        styledString.setStyle(1, res.length() - 2, (StyledString.Styler)STYLER1);
        Assert.assertEquals((long)res.length(), (long)styledString.length());
        Assert.assertEquals((Object)res, (Object)styledString.getString());
        StyleRange[] styleRanges = styledString.getStyleRanges();
        Assert.assertEquals((long)2L, (long)styleRanges.length);
        StyledStringBuilderTest.assertRangeEquals(styleRanges[0], STYLER1, 0, res.length() - 1);
        StyledStringBuilderTest.assertRangeEquals(styleRanges[1], STYLER2, res.length() - 1, 1);
    }

    @Test
    public void testSetStyle14() {
        String str1 = "One";
        String str2 = "Two";
        String res = str1 + str2;
        StyledString styledString = new StyledString();
        styledString.append(str1, (StyledString.Styler)STYLER1);
        styledString.append(str2, (StyledString.Styler)STYLER2);
        styledString.setStyle(1, res.length() - 2, (StyledString.Styler)STYLER2);
        Assert.assertEquals((long)res.length(), (long)styledString.length());
        Assert.assertEquals((Object)res, (Object)styledString.getString());
        StyleRange[] styleRanges = styledString.getStyleRanges();
        Assert.assertEquals((long)2L, (long)styleRanges.length);
        StyledStringBuilderTest.assertRangeEquals(styleRanges[0], STYLER1, 0, 1);
        StyledStringBuilderTest.assertRangeEquals(styleRanges[1], STYLER2, 1, res.length() - 1);
    }

    @Test
    public void testSetStyle15() {
        String str1 = "One";
        String str2 = "Two";
        String res = str1 + str2;
        StyledString styledString = new StyledString();
        styledString.append(str1, null);
        styledString.append(str2, (StyledString.Styler)STYLER2);
        styledString.setStyle(0, 1, (StyledString.Styler)STYLER1);
        Assert.assertEquals((long)res.length(), (long)styledString.length());
        Assert.assertEquals((Object)res, (Object)styledString.getString());
        StyleRange[] styleRanges = styledString.getStyleRanges();
        Assert.assertEquals((long)2L, (long)styleRanges.length);
        StyledStringBuilderTest.assertRangeEquals(styleRanges[0], STYLER1, 0, 1);
        StyledStringBuilderTest.assertRangeEquals(styleRanges[1], STYLER2, str1.length(), str2.length());
    }

    @Test
    public void testSetStyle16() {
        String res = "H2O";
        StyledString styledString = new StyledString();
        styledString.append('H', null);
        styledString.append('2', (StyledString.Styler)STYLER1);
        styledString.append('O', (StyledString.Styler)STYLER2);
        styledString.setStyle(0, res.length(), (StyledString.Styler)STYLER1);
        Assert.assertEquals((long)res.length(), (long)styledString.length());
        Assert.assertEquals((Object)res, (Object)styledString.getString());
        StyleRange[] styleRanges = styledString.getStyleRanges();
        Assert.assertEquals((long)1L, (long)styleRanges.length);
        StyledStringBuilderTest.assertRangeEquals(styleRanges[0], STYLER1, 0, res.length());
    }

    @Test
    public void testSetStyle17() {
        String res = "H2O";
        StyledString styledString = new StyledString();
        styledString.append('H', null);
        styledString.append('2', (StyledString.Styler)STYLER1);
        styledString.append('O', (StyledString.Styler)STYLER2);
        styledString.setStyle(0, res.length(), null);
        Assert.assertEquals((long)res.length(), (long)styledString.length());
        Assert.assertEquals((Object)res, (Object)styledString.getString());
        StyleRange[] styleRanges = styledString.getStyleRanges();
        Assert.assertEquals((long)0L, (long)styleRanges.length);
    }

    @Test
    public void testSetStyle18() {
        String res = "H2OH2O";
        StyledString styledString = new StyledString();
        styledString.append('H', null);
        styledString.append('2', (StyledString.Styler)STYLER1);
        styledString.append('O', (StyledString.Styler)STYLER2);
        styledString.append('H', null);
        styledString.append('2', (StyledString.Styler)STYLER2);
        styledString.append('O', (StyledString.Styler)STYLER1);
        styledString.setStyle(1, res.length() - 2, (StyledString.Styler)STYLER1);
        Assert.assertEquals((long)res.length(), (long)styledString.length());
        Assert.assertEquals((Object)res, (Object)styledString.getString());
        StyleRange[] styleRanges = styledString.getStyleRanges();
        Assert.assertEquals((long)1L, (long)styleRanges.length);
        StyledStringBuilderTest.assertRangeEquals(styleRanges[0], STYLER1, 1, res.length() - 1);
    }

    @Test
    public void testSetStyle19() {
        String res = "O2O2O2O2O2O2";
        StyledString styledString = new StyledString();
        styledString.append("O2", null);
        styledString.append("O2", (StyledString.Styler)STYLER1);
        styledString.append("O2", (StyledString.Styler)STYLER2);
        styledString.append("O2", (StyledString.Styler)STYLER1);
        styledString.append("O2", (StyledString.Styler)STYLER2);
        styledString.append("O2", null);
        styledString.setStyle(1, res.length() - 2, (StyledString.Styler)STYLER1);
        Assert.assertEquals((long)res.length(), (long)styledString.length());
        Assert.assertEquals((Object)res, (Object)styledString.getString());
        StyleRange[] styleRanges = styledString.getStyleRanges();
        Assert.assertEquals((long)1L, (long)styleRanges.length);
        StyledStringBuilderTest.assertRangeEquals(styleRanges[0], STYLER1, 1, res.length() - 2);
    }

    @Test
    public void testSetStyle20() {
        String res = "O2O2O2O2O2O2";
        StyledString styledString = new StyledString();
        styledString.append("O2", null);
        styledString.append("O2", (StyledString.Styler)STYLER1);
        styledString.append("O2", (StyledString.Styler)STYLER2);
        styledString.append("O2", (StyledString.Styler)STYLER1);
        styledString.append("O2", (StyledString.Styler)STYLER2);
        styledString.append("O2", null);
        styledString.setStyle(3, 6, null);
        Assert.assertEquals((long)res.length(), (long)styledString.length());
        Assert.assertEquals((Object)res, (Object)styledString.getString());
        StyleRange[] styleRanges = styledString.getStyleRanges();
        Assert.assertEquals((long)2L, (long)styleRanges.length);
        StyledStringBuilderTest.assertRangeEquals(styleRanges[0], STYLER1, 2, 1);
        StyledStringBuilderTest.assertRangeEquals(styleRanges[1], STYLER2, 9, 1);
    }

    @Test
    public void testSetStyle21() {
        String res = "O2O2O2O2O2O2";
        StyledString styledString = new StyledString();
        styledString.append("O2", null);
        styledString.append("O2", (StyledString.Styler)STYLER1);
        styledString.append("O2", (StyledString.Styler)STYLER2);
        styledString.append("O2", (StyledString.Styler)STYLER1);
        styledString.append("O2", (StyledString.Styler)STYLER2);
        styledString.append("O2", null);
        styledString.setStyle(3, 6, (StyledString.Styler)STYLER1);
        styledString.setStyle(3, 6, null);
        Assert.assertEquals((long)res.length(), (long)styledString.length());
        Assert.assertEquals((Object)res, (Object)styledString.getString());
        StyleRange[] styleRanges = styledString.getStyleRanges();
        Assert.assertEquals((long)2L, (long)styleRanges.length);
        StyledStringBuilderTest.assertRangeEquals(styleRanges[0], STYLER1, 2, 1);
        StyledStringBuilderTest.assertRangeEquals(styleRanges[1], STYLER2, 9, 1);
    }

    @Test
    public void testCombination1() {
        String str1 = "One";
        String str2 = "Two";
        String res = str1 + str2 + str1;
        StyledString styledString = new StyledString();
        styledString.append(str1, null);
        styledString.append(str2, (StyledString.Styler)STYLER2);
        styledString.setStyle(str1.length(), str2.length(), (StyledString.Styler)STYLER1);
        styledString.append(str1, (StyledString.Styler)STYLER1);
        Assert.assertEquals((long)res.length(), (long)styledString.length());
        Assert.assertEquals((Object)res, (Object)styledString.getString());
        StyleRange[] styleRanges = styledString.getStyleRanges();
        Assert.assertEquals((long)1L, (long)styleRanges.length);
        StyledStringBuilderTest.assertRangeEquals(styleRanges[0], STYLER1, str1.length(), str2.length() + str1.length());
    }

    private static void assertRangeEquals(StyleRange range, TestStyler style, int offset, int length) {
        Assert.assertEquals((long)offset, (long)range.start);
        Assert.assertEquals((long)length, (long)range.length);
        Assert.assertEquals((long)style.borderStyle, (long)range.borderStyle);
    }

    public static class TestStyler
    extends StyledString.Styler {
        public final int borderStyle;

        public TestStyler(int borderStyle) {
            this.borderStyle = borderStyle;
        }

        public void applyStyles(TextStyle textStyle) {
            textStyle.borderStyle = this.borderStyle;
        }
    }
}

