/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jface.tests.viewers;

import org.eclipse.jface.tests.viewers.StructuredViewerTest;
import org.eclipse.jface.tests.viewers.TableViewerTest;
import org.eclipse.jface.tests.viewers.TestElement;
import org.eclipse.jface.tests.viewers.TestModelContentProvider;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IColorProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ITableColorProvider;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.TableLayout;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class TableColorProviderTest
extends StructuredViewerTest {
    Color red = null;
    Color green = null;

    @Test
    public void testColorProviderForeground() {
        TableViewer viewer = (TableViewer)this.fViewer;
        ColorViewLabelProvider provider = new ColorViewLabelProvider();
        viewer.setLabelProvider((IBaseLabelProvider)provider);
        this.fViewer.refresh();
        Assert.assertEquals((String)"foreground 1 green", (Object)viewer.getTable().getItem(0).getForeground(0), (Object)this.green);
        Assert.assertEquals((String)"foreground 2 green", (Object)viewer.getTable().getItem(0).getForeground(1), (Object)this.green);
        provider.fExtended = false;
    }

    @Test
    public void testColorProviderBackground() {
        TableViewer viewer = (TableViewer)this.fViewer;
        ColorViewLabelProvider provider = new ColorViewLabelProvider();
        viewer.setLabelProvider((IBaseLabelProvider)provider);
        this.fViewer.refresh();
        Assert.assertEquals((String)"background 1 red", (Object)viewer.getTable().getItem(0).getBackground(0), (Object)this.red);
        Assert.assertEquals((String)"background 2 red", (Object)viewer.getTable().getItem(1).getBackground(1), (Object)this.red);
        provider.fExtended = false;
    }

    @Test
    public void testTableItemsColorProviderForeground() {
        TableViewer viewer = (TableViewer)this.fViewer;
        TableColorViewLabelProvider provider = new TableColorViewLabelProvider();
        viewer.setLabelProvider((IBaseLabelProvider)provider);
        Table table = viewer.getTable();
        this.fViewer.refresh();
        Assert.assertEquals((String)"table item 1 green", (Object)table.getItem(0).getForeground(0), (Object)this.green);
        Assert.assertEquals((String)"table item 2 red", (Object)table.getItem(0).getForeground(1), (Object)this.red);
        provider.fExtended = false;
    }

    @Test
    public void testTableItemsColorProviderBackground() {
        TableViewer viewer = (TableViewer)this.fViewer;
        TableColorViewLabelProvider provider = new TableColorViewLabelProvider();
        viewer.setLabelProvider((IBaseLabelProvider)provider);
        Table table = viewer.getTable();
        this.fViewer.refresh();
        Assert.assertEquals((String)"table item 1 background red", (Object)table.getItem(0).getBackground(0), (Object)this.red);
        Assert.assertEquals((String)"table item 2 background green", (Object)table.getItem(0).getBackground(1), (Object)this.green);
        provider.fExtended = false;
    }

    @Override
    @Before
    public void setUp() {
        super.setUp();
        this.red = new Color((Device)Display.getCurrent(), 255, 0, 0);
        this.green = new Color((Device)Display.getCurrent(), 0, 255, 0);
    }

    @Override
    protected StructuredViewer createViewer(Composite parent) {
        TableViewer viewer = new TableViewer(parent);
        viewer.setContentProvider((IContentProvider)new TestModelContentProvider());
        viewer.getTable().setLinesVisible(true);
        TableLayout layout = new TableLayout();
        viewer.getTable().setLayout((Layout)layout);
        viewer.getTable().setHeaderVisible(true);
        String[] headers = new String[]{"column 1 header", "column 2 header"};
        ColumnLayoutData[] layouts = new ColumnLayoutData[]{new ColumnWeightData(100), new ColumnWeightData(100)};
        TableColumn[] columns = new TableColumn[headers.length];
        int i = 0;
        while (i < headers.length) {
            layout.addColumnData(layouts[i]);
            TableColumn tc = new TableColumn(viewer.getTable(), 0, i);
            tc.setResizable(layouts[i].resizable);
            tc.setText(headers[i]);
            columns[i] = tc;
            ++i;
        }
        return viewer;
    }

    @Override
    protected int getItemCount() {
        TestElement first = this.fRootElement.getFirstChild();
        TableItem ti = (TableItem)this.fViewer.testFindItem((Object)first);
        Table table = ti.getParent();
        return table.getItemCount();
    }

    @Override
    protected String getItemText(int at) {
        Table table = (Table)this.fViewer.getControl();
        return table.getItem(at).getText();
    }

    class ColorViewLabelProvider
    extends TableViewerTest.TableTestLabelProvider
    implements IColorProvider {
        ColorViewLabelProvider() {
        }

        public Color getBackground(Object element) {
            return TableColorProviderTest.this.red;
        }

        public Color getForeground(Object element) {
            return TableColorProviderTest.this.green;
        }
    }

    class TableColorViewLabelProvider
    extends TableViewerTest.TableTestLabelProvider
    implements ITableColorProvider {
        TableColorViewLabelProvider() {
        }

        @Override
        public Image getColumnImage(Object obj, int index) {
            return null;
        }

        public Color getForeground(Object element, int columnIndex) {
            switch (columnIndex) {
                case 0: {
                    return TableColorProviderTest.this.green;
                }
            }
            return TableColorProviderTest.this.red;
        }

        public Color getBackground(Object element, int columnIndex) {
            switch (columnIndex) {
                case 0: {
                    return TableColorProviderTest.this.red;
                }
            }
            return TableColorProviderTest.this.green;
        }
    }
}

