/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jface.tests.viewers;

import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.tests.viewers.StructuredViewerTest;
import org.eclipse.jface.tests.viewers.TableViewerTest;
import org.eclipse.jface.tests.viewers.TestElement;
import org.eclipse.jface.tests.viewers.TestModelContentProvider;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IFontProvider;
import org.eclipse.jface.viewers.ITableFontProvider;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.TableLayout;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class TableFontProviderTest
extends StructuredViewerTest {
    Font font1;
    Font font2;

    @Test
    public void testFontProvider() {
        TableViewer viewer = (TableViewer)this.fViewer;
        FontViewLabelProvider provider = new FontViewLabelProvider();
        viewer.setLabelProvider((IBaseLabelProvider)provider);
        this.fViewer.refresh();
        TableFontProviderTest.compareFontDatas(viewer.getTable().getItem(0).getFont(0), this.font1);
        TableFontProviderTest.compareFontDatas(viewer.getTable().getItem(0).getFont(1), this.font1);
        provider.fExtended = false;
    }

    @Test
    public void testTableItemsFontProvider() {
        TableViewer viewer = (TableViewer)this.fViewer;
        TableFontViewLabelProvider provider = new TableFontViewLabelProvider();
        viewer.setLabelProvider((IBaseLabelProvider)provider);
        Table table = viewer.getTable();
        this.fViewer.refresh();
        TableFontProviderTest.compareFontDatas(this.font1, table.getItem(0).getFont(0));
        TableFontProviderTest.compareFontDatas(this.font2, table.getItem(0).getFont(1));
        provider.fExtended = false;
    }

    @Override
    @Before
    public void setUp() {
        super.setUp();
        this.font1 = JFaceResources.getFont((String)"org.eclipse.jface.bannerfont");
        this.font2 = JFaceResources.getFont((String)"org.eclipse.jface.headerfont");
    }

    @Override
    protected StructuredViewer createViewer(Composite parent) {
        TableViewer viewer = new TableViewer(parent);
        viewer.setContentProvider((IContentProvider)new TestModelContentProvider());
        viewer.getTable().setLinesVisible(true);
        TableLayout layout = new TableLayout();
        viewer.getTable().setLayout((Layout)layout);
        viewer.getTable().setHeaderVisible(true);
        String[] headers = new String[]{"column 1 header", "column 2 header"};
        ColumnLayoutData[] layouts = new ColumnLayoutData[]{new ColumnWeightData(100), new ColumnWeightData(100)};
        TableColumn[] columns = new TableColumn[headers.length];
        int i = 0;
        while (i < headers.length) {
            layout.addColumnData(layouts[i]);
            TableColumn tc = new TableColumn(viewer.getTable(), 0, i);
            tc.setResizable(layouts[i].resizable);
            tc.setText(headers[i]);
            columns[i] = tc;
            ++i;
        }
        return viewer;
    }

    @Override
    protected int getItemCount() {
        TestElement first = this.fRootElement.getFirstChild();
        TableItem ti = (TableItem)this.fViewer.testFindItem((Object)first);
        Table table = ti.getParent();
        return table.getItemCount();
    }

    @Override
    protected String getItemText(int at) {
        Table table = (Table)this.fViewer.getControl();
        return table.getItem(at).getText();
    }

    private static void compareFontDatas(Font font1, Font font2) {
        FontData[] font1Data = font1.getFontData();
        FontData[] font2Data = font2.getFontData();
        Assert.assertEquals((String)"Mismatched sizes", (long)font1Data.length, (long)font2Data.length);
        int a = 0;
        while (a < font2Data.length) {
            Assert.assertEquals((String)"Mismatched fontData", (Object)font1Data[a], (Object)font2Data[a]);
            ++a;
        }
    }

    class FontViewLabelProvider
    extends TableViewerTest.TableTestLabelProvider
    implements IFontProvider {
        FontViewLabelProvider() {
        }

        public Font getFont(Object element) {
            return TableFontProviderTest.this.font1;
        }
    }

    class TableFontViewLabelProvider
    extends TableViewerTest.TableTestLabelProvider
    implements ITableFontProvider {
        TableFontViewLabelProvider() {
        }

        @Override
        public Image getColumnImage(Object obj, int index) {
            return null;
        }

        public Font getFont(Object element, int columnIndex) {
            switch (columnIndex) {
                case 0: {
                    return TableFontProviderTest.this.font1;
                }
            }
            return TableFontProviderTest.this.font2;
        }
    }
}

