/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jface.tests.viewers;

import org.eclipse.jface.tests.viewers.ViewerComparatorTest;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.TableLayout;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.junit.Assert;
import org.junit.Test;

public class TableViewerComparatorTest
extends ViewerComparatorTest {
    @Override
    protected StructuredViewer createViewer(Composite parent) {
        TableViewer viewer = new TableViewer(parent);
        viewer.setContentProvider((IContentProvider)new ViewerComparatorTest.TeamModelContentProvider(this));
        viewer.setLabelProvider((IBaseLabelProvider)new ViewerComparatorTest.TeamModelLabelProvider());
        viewer.getTable().setLinesVisible(true);
        TableLayout layout = new TableLayout();
        viewer.getTable().setLayout((Layout)layout);
        viewer.getTable().setHeaderVisible(true);
        String[] headers = new String[]{"column 1 header", "column 2 header"};
        ColumnLayoutData[] layouts = new ColumnLayoutData[]{new ColumnWeightData(100), new ColumnWeightData(100)};
        TableColumn[] columns = new TableColumn[headers.length];
        int i = 0;
        while (i < headers.length) {
            layout.addColumnData(layouts[i]);
            TableColumn tc = new TableColumn(viewer.getTable(), 0, i);
            tc.setResizable(layouts[i].resizable);
            tc.setText(headers[i]);
            columns[i] = tc;
            ++i;
        }
        return viewer;
    }

    @Test
    public void testViewerSorter() {
        this.fViewer.setSorter(new ViewerSorter());
        this.assertSortedResult(this.TEAM1_SORTED);
    }

    @Test
    public void testViewerSorterInsertElement() {
        this.fViewer.setSorter(new ViewerSorter());
        this.team1.addMember("Duong");
        this.assertSortedResult(this.TEAM1_SORTED_WITH_INSERT);
    }

    @Test
    public void testViewerComparator() {
        this.fViewer.setComparator(new ViewerComparator());
        this.assertSortedResult(this.TEAM1_SORTED);
    }

    @Test
    public void testViewerComparatorInsertElement() {
        this.fViewer.setComparator(new ViewerComparator());
        this.team1.addMember("Duong");
        this.assertSortedResult(this.TEAM1_SORTED_WITH_INSERT);
    }

    private void assertSortedResult(String[] expected) {
        TableItem[] items = this.getTableViewer().getTable().getItems();
        int i = 0;
        while (i < items.length) {
            TableItem item = items[i];
            Assert.assertEquals((String)("Item not expected.  actual=" + item.getText() + " expected="), (Object)expected[i], (Object)item.getText());
            ++i;
        }
    }

    @Override
    protected void setInput() {
        this.fViewer.setInput((Object)this.team1);
    }

    protected TableViewer getTableViewer() {
        return (TableViewer)this.fViewer;
    }
}

