/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jface.tests.viewers;

import java.lang.reflect.Method;
import org.eclipse.jface.tests.viewers.StructuredItemViewerTest;
import org.eclipse.jface.tests.viewers.StructuredViewerTest;
import org.eclipse.jface.tests.viewers.TestElement;
import org.eclipse.jface.tests.viewers.TestModelContentProvider;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.TableLayout;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.ViewerColumn;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.junit.Assert;
import org.junit.Test;

public class TableViewerTest
extends StructuredItemViewerTest {
    @Override
    protected StructuredViewer createViewer(Composite parent) {
        TableViewer viewer = this.createTableViewer(parent);
        viewer.setContentProvider((IContentProvider)this.getContentProvider());
        viewer.setLabelProvider((IBaseLabelProvider)new TableTestLabelProvider());
        viewer.getTable().setLinesVisible(true);
        TableLayout layout = new TableLayout();
        viewer.getTable().setLayout((Layout)layout);
        viewer.getTable().setHeaderVisible(true);
        String[] headers = new String[]{"column 1 header", "column 2 header"};
        ColumnLayoutData[] layouts = new ColumnLayoutData[]{new ColumnWeightData(100), new ColumnWeightData(100)};
        TableColumn[] columns = new TableColumn[headers.length];
        int i = 0;
        while (i < headers.length) {
            layout.addColumnData(layouts[i]);
            TableColumn tc = new TableColumn(viewer.getTable(), 0, i);
            tc.setResizable(layouts[i].resizable);
            tc.setText(headers[i]);
            columns[i] = tc;
            ++i;
        }
        return viewer;
    }

    ViewerColumn getViewerColumn(ColumnViewer viewer, int index) {
        try {
            Method method = ColumnViewer.class.getDeclaredMethod("getViewerColumn", Integer.TYPE);
            method.setAccessible(true);
            return (ViewerColumn)method.invoke((Object)viewer, index);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Test
    public void testViewerColumn() {
        Assert.assertNull((Object)this.getViewerColumn((ColumnViewer)((TableViewer)this.fViewer), -1));
        Assert.assertNotNull((Object)this.getViewerColumn((ColumnViewer)((TableViewer)this.fViewer), 0));
        Assert.assertNotNull((Object)this.getViewerColumn((ColumnViewer)((TableViewer)this.fViewer), 1));
        Assert.assertNull((Object)this.getViewerColumn((ColumnViewer)((TableViewer)this.fViewer), 2));
    }

    protected TestModelContentProvider getContentProvider() {
        return new TestModelContentProvider();
    }

    protected TableViewer createTableViewer(Composite parent) {
        return new TableViewer(parent);
    }

    @Override
    protected int getItemCount() {
        TestElement first = this.fRootElement.getFirstChild();
        TableItem ti = (TableItem)this.fViewer.testFindItem((Object)first);
        Table table = ti.getParent();
        return table.getItemCount();
    }

    @Override
    protected String getItemText(int at) {
        Table table = (Table)this.fViewer.getControl();
        return table.getItem(at).getText();
    }

    @Override
    @Test
    public void testLabelProvider() {
        TableViewer viewer = (TableViewer)this.fViewer;
        TableTestLabelProvider provider = (TableTestLabelProvider)viewer.getLabelProvider();
        provider.fExtended = true;
        this.fViewer.refresh();
        TestElement first = this.fRootElement.getFirstChild();
        String newLabel = TableViewerTest.providedString(first);
        Assert.assertEquals((String)"rendered label", (Object)newLabel, (Object)this.getItemText(0));
        provider.fExtended = false;
    }

    @Override
    @Test
    public void testLabelProviderStateChange() {
        TableViewer tableviewer = (TableViewer)this.fViewer;
        TableTestLabelProvider provider = (TableTestLabelProvider)tableviewer.getLabelProvider();
        provider.fExtended = true;
        provider.setSuffix("added suffix");
        tableviewer.refresh();
        TestElement first = this.fRootElement.getFirstChild();
        String newLabel = TableViewerTest.providedString(first);
        Assert.assertEquals((String)"rendered label", (Object)newLabel, (Object)this.getItemText(0));
        provider.fExtended = false;
        this.fViewer.refresh();
    }

    @Test
    public void testRemove() {
        TableViewer tableviewer = (TableViewer)this.fViewer;
        TestElement first = this.fRootElement.getFirstChild();
        ((TestElement)this.fViewer.getInput()).deleteChild(first);
        tableviewer.remove((Object)first);
        Assert.assertNull((String)"Removed item still exists", (Object)this.fViewer.testFindItem((Object)first));
    }

    @Test
    public void testContains() {
        TableViewer tViewer = (TableViewer)this.fViewer;
        Assert.assertFalse((String)"element must not be available on the viewer", (boolean)tViewer.contains((Object)""));
        Assert.assertTrue((String)"element must be available on the viewer", (boolean)tViewer.contains((Object)this.fRootElement.getFirstChild()));
        Assert.assertTrue((String)"element must be available on the viewer", (boolean)tViewer.contains((Object)this.fRootElement.getLastChild()));
    }

    public static class TableTestLabelProvider
    extends StructuredViewerTest.TestLabelProvider
    implements ITableLabelProvider {
        public boolean fExtended = false;

        @Override
        public String getText(Object element) {
            if (this.fExtended) {
                return TableViewerTest.providedString((String)element);
            }
            return element.toString();
        }

        public String getColumnText(Object element, int index) {
            if (this.fExtended) {
                return TableViewerTest.providedString((TestElement)element);
            }
            return element.toString();
        }

        public Image getColumnImage(Object element, int columnIndex) {
            return null;
        }
    }
}

