/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jface.tests.viewers;

import java.util.ArrayList;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.tests.viewers.BaseLimitBasedViewerTest;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.jface.viewers.internal.ExpandableNode;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableItem;
import org.junit.Assert;
import org.junit.Test;

public class TableViewerWithLimitTest
extends BaseLimitBasedViewerTest {
    TestTableViewer tableViewer;

    @Test
    public void testLimitedItemsCreatedWithExpansionNode() {
        Table table = this.tableViewer.getTable();
        TableItem[] items = table.getItems();
        this.assertLimitedItems(items);
    }

    @Test
    public void testAddElement() {
        BaseLimitBasedViewerTest.DataModel element;
        this.processEvents();
        Table table = this.tableViewer.getTable();
        this.assertLimitedItems(table.getItems());
        BaseLimitBasedViewerTest.DataModel data = (BaseLimitBasedViewerTest.DataModel)table.getItems()[2].getData();
        Assert.assertEquals((String)"wrong item is found at given location", (Object)4, (Object)data.id);
        BaseLimitBasedViewerTest.DataModel newEle = new BaseLimitBasedViewerTest.DataModel(3);
        this.rootModel.add(newEle);
        this.tableViewer.add(newEle);
        this.processEvents();
        this.assertLimitedItems(table.getItems());
        data = (BaseLimitBasedViewerTest.DataModel)table.getItems()[2].getData();
        Assert.assertEquals((String)"wrong item is found at given location", (Object)3, (Object)data.id);
        BaseLimitBasedViewerTest.DataModel newEle1 = new BaseLimitBasedViewerTest.DataModel(9);
        this.rootModel.add(newEle1);
        this.tableViewer.add(newEle1);
        this.processEvents();
        this.assertLimitedItems(table.getItems());
        data = (BaseLimitBasedViewerTest.DataModel)table.getItems()[2].getData();
        Assert.assertEquals((String)"wrong item is found at given location", (Object)3, (Object)data.id);
        this.rootModel = TableViewerWithLimitTest.createModel(1);
        this.fViewer.setInput((Object)this.rootModel);
        this.processEvents();
        while (this.rootModel.size() < 4) {
            element = new BaseLimitBasedViewerTest.DataModel(this.rootModel.size() + 1);
            this.rootModel.add(element);
            this.tableViewer.add(element);
            this.processEvents();
            TableItem[] items = table.getItems();
            Object last = items[items.length - 1].getData();
            Assert.assertFalse((String)("Last item shouln't be expandable: " + String.valueOf(last)), (boolean)this.tableViewer.isExpandableNode(last));
        }
        element = new BaseLimitBasedViewerTest.DataModel(this.rootModel.size() + 1);
        this.rootModel.add(element);
        this.tableViewer.add(element);
        this.processEvents();
        this.assertLimitedItems(table.getItems());
    }

    @Test
    public void testRemoveElement() {
        this.processEvents();
        Table table = this.tableViewer.getTable();
        this.assertLimitedItems(table.getItems());
        BaseLimitBasedViewerTest.DataModel data = (BaseLimitBasedViewerTest.DataModel)table.getItems()[2].getData();
        Assert.assertEquals((String)"wrong item is found at given location", (Object)4, (Object)data.id);
        BaseLimitBasedViewerTest.DataModel removed = (BaseLimitBasedViewerTest.DataModel)this.rootModel.remove(2);
        this.tableViewer.remove(removed);
        this.processEvents();
        this.assertLimitedItems(table.getItems());
        data = (BaseLimitBasedViewerTest.DataModel)table.getItems()[2].getData();
        Assert.assertEquals((String)"wrong item is found at given location", (Object)6, (Object)data.id);
        removed = (BaseLimitBasedViewerTest.DataModel)this.rootModel.remove(7);
        this.tableViewer.remove(removed);
        this.processEvents();
        this.assertLimitedItems(table.getItems());
        data = (BaseLimitBasedViewerTest.DataModel)table.getItems()[2].getData();
        Assert.assertEquals((String)"wrong item is found at given location", (Object)6, (Object)data.id);
        while (this.rootModel.size() > 5) {
            removed = (BaseLimitBasedViewerTest.DataModel)this.rootModel.remove(this.rootModel.size() - 1);
            this.tableViewer.remove(removed);
            this.processEvents();
            TableItem[] items = table.getItems();
            if (this.rootModel.size() > 5) {
                this.assertLimitedItems(items);
                continue;
            }
            Object last = items[items.length - 1].getData();
            Assert.assertFalse((String)("Last item shouln't be expandable: " + String.valueOf(last)), (boolean)this.tableViewer.isExpandableNode(last));
        }
    }

    @Test
    public void testClickExpandableNode() {
        Table table = this.tableViewer.getTable();
        this.assertLimitedItems(table.getItems());
        TableItem lastItem = table.getItems()[table.getItems().length - 1];
        TableViewerWithLimitTest.clickTableItem((Control)table, lastItem);
        this.processEvents();
        TableItem[] itemsBefore = table.getItems();
        Assert.assertEquals((String)"There are more/less items rendered than viewer limit", (long)9L, (long)itemsBefore.length);
        TableItem item = itemsBefore[itemsBefore.length - 1];
        Object data = item.getData();
        Assert.assertTrue((String)"Last node must be an Expandable Node", (boolean)this.tableViewer.isExpandableNode(data));
        String expected = this.calculateExpandableLabel(data);
        Assert.assertEquals((String)"Expandable node has an incorrect text", (Object)expected, (Object)item.getText());
        this.clickUntilAllExpandableNodes(table);
        TableItem[] itemsAfterExp = table.getItems();
        Assert.assertEquals((String)"There are more/less items rendered than viewer limit", (long)this.rootModel.size(), (long)itemsAfterExp.length);
        Assert.assertEquals((String)"Last node must be an DataModel after all the elements expanded", itemsAfterExp[itemsAfterExp.length - 1].getData().getClass(), BaseLimitBasedViewerTest.DataModel.class);
    }

    @Test
    public void testApplyFilter() {
        Table table = this.tableViewer.getTable();
        this.clickUntilAllExpandableNodes(table);
        Assert.assertEquals((String)"There are more/less items rendered than viewer limit", (long)this.rootModel.size(), (long)table.getItems().length);
        BaseLimitBasedViewerTest.DataModel data = (BaseLimitBasedViewerTest.DataModel)table.getItems()[2].getData();
        Assert.assertEquals((String)"wrong item is found at given location", (Object)4, (Object)data.id);
        this.tableViewer.setFilters(new ViewerFilter[]{new BaseLimitBasedViewerTest.TestViewerFilter()});
        this.processEvents();
        this.clickUntilAllExpandableNodes(table);
        Assert.assertEquals((String)"There are more/less items rendered than viewer limit", (long)14L, (long)table.getItems().length);
        data = (BaseLimitBasedViewerTest.DataModel)table.getItems()[2].getData();
        Assert.assertEquals((String)"wrong item is found at given location", (Object)16, (Object)data.id);
    }

    private void clickUntilAllExpandableNodes(Table table) {
        TableItem lastItem = table.getItems()[table.getItems().length - 1];
        this.processEvents();
        while (this.tableViewer.isExpandableNode(lastItem.getData())) {
            TableViewerWithLimitTest.clickTableItem((Control)table, lastItem);
            this.processEvents();
            lastItem = table.getItems()[table.getItems().length - 1];
        }
        this.processEvents();
    }

    @Test
    public void testResetComparator() {
        Table table = this.tableViewer.getTable();
        BaseLimitBasedViewerTest.DataModel newEle1 = new BaseLimitBasedViewerTest.DataModel(3);
        this.rootModel.add(newEle1);
        this.tableViewer.add(newEle1);
        this.processEvents();
        BaseLimitBasedViewerTest.DataModel data = (BaseLimitBasedViewerTest.DataModel)table.getItems()[2].getData();
        Assert.assertEquals((String)"wrong item is found at given location", (Object)3, (Object)data.id);
        this.tableViewer.setComparator(null);
        this.processEvents();
        data = (BaseLimitBasedViewerTest.DataModel)table.getItems()[2].getData();
        Assert.assertEquals((String)"wrong item is found at given location", (Object)4, (Object)data.id);
    }

    @Test
    public void testSelection() {
        BaseLimitBasedViewerTest.DataModel toSelect = (BaseLimitBasedViewerTest.DataModel)this.rootModel.get(this.rootModel.size() - 4);
        this.tableViewer.setSelection((ISelection)new StructuredSelection((Object)toSelect));
        this.processEvents();
        ISelection selection = this.tableViewer.getSelection();
        Assert.assertTrue((String)"Selection must not be empty", (boolean)(selection instanceof IStructuredSelection));
        Object selEle = ((IStructuredSelection)selection).getFirstElement();
        Assert.assertTrue((String)"Selection must be ExpandableNode", (boolean)this.tableViewer.isExpandableNode(selEle));
        toSelect = (BaseLimitBasedViewerTest.DataModel)this.rootModel.get(2);
        this.tableViewer.setSelection((ISelection)new StructuredSelection((Object)toSelect));
        this.processEvents();
        selection = this.tableViewer.getSelection();
        Assert.assertTrue((String)"Selection must not be empty", (boolean)(selection instanceof IStructuredSelection));
        selEle = ((IStructuredSelection)selection).getFirstElement();
        Assert.assertEquals((String)"selection must be desired element which is visible", (Object)toSelect, (Object)selEle);
        this.tableViewer.setSelection((ISelection)new StructuredSelection((Object)"dummy"));
        this.processEvents();
        selection = this.tableViewer.getSelection();
        Assert.assertTrue((String)"Selection must not be empty", (boolean)selection.isEmpty());
    }

    @Test
    public void testRefresh() {
        Table table = this.tableViewer.getTable();
        this.assertLimitedItems(table.getItems());
        Assert.assertEquals((String)"third element must be third element of the input", this.rootModel.get(2), (Object)table.getItem(2).getData());
        BaseLimitBasedViewerTest.DataModel ele1 = new BaseLimitBasedViewerTest.DataModel(100);
        this.rootModel.add(ele1);
        this.tableViewer.add(ele1);
        this.processEvents();
        this.assertLimitedItems(table.getItems());
        Assert.assertEquals((String)"third element must be third element of the input", this.rootModel.get(2), (Object)table.getItem(2).getData());
        BaseLimitBasedViewerTest.DataModel newEle = new BaseLimitBasedViewerTest.DataModel(3);
        this.rootModel.add(newEle);
        this.tableViewer.add(newEle);
        this.processEvents();
        this.assertLimitedItems(table.getItems());
        Assert.assertEquals((String)"third element must be newly added element", (Object)newEle, (Object)table.getItem(2).getData());
    }

    private void assertLimitedItems(TableItem[] itemsBefore) {
        Assert.assertEquals((String)"There are more/less items rendered than viewer limit", (long)5L, (long)itemsBefore.length);
        TableItem tableItem = itemsBefore[itemsBefore.length - 1];
        Object data = tableItem.getData();
        Assert.assertTrue((String)"Last node must be an Expandable Node", (boolean)this.tableViewer.isExpandableNode(data));
        String expectedLabel = this.calculateExpandableLabel(data);
        Assert.assertEquals((String)"Expandable node has an incorrect text", (Object)expectedLabel, (Object)tableItem.getText());
    }

    private String calculateExpandableLabel(Object data) {
        String expectedLabel;
        ExpandableNode node = (ExpandableNode)data;
        int all = this.rootModel.size();
        int remaining = all - node.getOffset();
        if (remaining > node.getLimit()) {
            if (remaining == node.getLimit() + 1) {
                String suffix = remaining == 1 ? "" : "s";
                return JFaceResources.format((String)"ExpandableNode.showRemaining", (Object[])new Object[]{remaining, suffix});
            }
            expectedLabel = JFaceResources.format((String)"ExpandableNode.defaultLabel", (Object[])new Object[]{node.getLimit(), remaining});
        } else {
            String suffix = remaining == 1 ? "" : "s";
            expectedLabel = JFaceResources.format((String)"ExpandableNode.showRemaining", (Object[])new Object[]{remaining, suffix});
        }
        return expectedLabel;
    }

    @Test
    public void testSetInput() {
        ArrayList<BaseLimitBasedViewerTest.DataModel> rootModel = new ArrayList<BaseLimitBasedViewerTest.DataModel>();
        BaseLimitBasedViewerTest.DataModel rootLevel = new BaseLimitBasedViewerTest.DataModel(100);
        rootModel.add(rootLevel);
        this.tableViewer.setInput(rootModel);
        this.processEvents();
        Assert.assertEquals((String)"there must be only one item", (long)1L, (long)this.tableViewer.getTable().getItems().length);
        this.tableViewer.setInput(TableViewerWithLimitTest.createModel(40));
        this.processEvents();
        this.assertLimitedItems(this.tableViewer.getTable().getItems());
    }

    @Test
    public void testBoundaryConditions() {
        ArrayList<BaseLimitBasedViewerTest.DataModel> dummy = new ArrayList<BaseLimitBasedViewerTest.DataModel>();
        dummy.add(new BaseLimitBasedViewerTest.DataModel(100));
        this.tableViewer.setInput(dummy);
        int numOfEle = 7;
        int limit = 2;
        this.tableViewer.setDisplayIncrementally(limit);
        this.processEvents();
        ArrayList<BaseLimitBasedViewerTest.DataModel> newInput = new ArrayList<BaseLimitBasedViewerTest.DataModel>();
        int i = 0;
        while (i < numOfEle) {
            BaseLimitBasedViewerTest.DataModel rootLevel = new BaseLimitBasedViewerTest.DataModel(i);
            newInput.add(rootLevel);
            ++i;
        }
        this.tableViewer.setInput(newInput);
        this.processEvents();
        Assert.assertEquals((String)("visible items length should be " + (limit + 1)), (long)(limit + 1), (long)this.tableViewer.getTable().getItems().length);
        limit = 4;
        this.tableViewer.setDisplayIncrementally(4);
        this.tableViewer.refresh();
        this.processEvents();
        Assert.assertEquals((String)("visible items length should be " + (limit + 1)), (long)(limit + 1), (long)this.tableViewer.getTable().getItems().length);
        limit = 6;
        this.tableViewer.setDisplayIncrementally(6);
        this.tableViewer.refresh();
        this.processEvents();
        Assert.assertEquals((String)("visible items length should be " + (limit + 1)), (long)(limit + 1), (long)this.tableViewer.getTable().getItems().length);
        limit = 8;
        this.tableViewer.setDisplayIncrementally(8);
        this.tableViewer.refresh();
        this.processEvents();
        Assert.assertEquals((String)("visible items length should be " + newInput.size()), (long)newInput.size(), (long)this.tableViewer.getTable().getItems().length);
    }

    @Test
    public void testContains() {
        Assert.assertFalse((String)"element must not be available on the viewer", (boolean)this.tableViewer.contains(""));
        Assert.assertTrue((String)"element must be available on the viewer", (boolean)this.tableViewer.contains(this.rootModel.get(0)));
        Assert.assertTrue((String)"element must be available on the viewer", (boolean)this.tableViewer.contains(this.rootModel.get(this.rootModel.size() - 1)));
    }

    @Override
    protected StructuredViewer createViewer(Composite parent) {
        this.tableViewer = new TestTableViewer(parent);
        this.tableViewer.setDisplayIncrementally(4);
        this.tableViewer.setLabelProvider((IBaseLabelProvider)new LabelProvider());
        this.tableViewer.setContentProvider((IContentProvider)new TestContentProvider());
        this.tableViewer.setComparator(new BaseLimitBasedViewerTest.TestComparator());
        return this.tableViewer;
    }

    @Override
    protected void setInput() {
        this.rootModel = TableViewerWithLimitTest.createModel(40);
        this.fViewer.setInput((Object)this.rootModel);
    }

    private static void clickTableItem(Control viewerControl, TableItem item) {
        Rectangle bounds = item.getBounds();
        Event event = new Event();
        event.x = bounds.x + 5;
        event.y = bounds.y + 5;
        viewerControl.notifyListeners(3, event);
    }

    private static class TestContentProvider
    implements IStructuredContentProvider {
        private TestContentProvider() {
        }

        public Object[] getElements(Object inputElement) {
            return ((ArrayList)inputElement).toArray();
        }
    }

    class TestTableViewer
    extends TableViewer {
        public TestTableViewer(Composite parent) {
            super(parent);
        }
    }
}

