/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jface.tests.viewers;

import java.util.Arrays;
import java.util.Vector;
import org.eclipse.jface.tests.viewers.TestModel;
import org.eclipse.jface.tests.viewers.TestModelChange;

public class TestElement
implements Cloneable {
    TestModel fModel;
    TestElement fContainer;
    String fSomeName;
    String fId;
    Vector<TestElement> fChildren = new Vector();
    boolean fIsDeleted = false;
    public static final String P_SOMENAME = "org.eclipse.jface.viewertest.name";
    public static final String P_COLUMN_1 = "org.eclipse.jface.viewertest.column1";

    public TestElement(TestModel model, TestElement container) {
        this.fModel = model;
        this.fContainer = container;
        int p = 0;
        TestElement lastSibling = container.getLastChild();
        if (lastSibling != null) {
            p = lastSibling.childId() + 1;
        }
        this.fId = container.getID() + "-" + p;
    }

    public TestElement(TestModel model, TestElement container, int level, int position) {
        this.fModel = model;
        this.fContainer = container;
        this.fId = container != null ? container.getID() + "-" + position : Integer.toString(position);
        this.fSomeName = "name-" + position;
        if (level < model.getNumLevels()) {
            int i = 0;
            while (i < model.getNumChildren()) {
                this.fChildren.add(new TestElement(model, this, level + 1, i));
                ++i;
            }
        }
    }

    public TestElement addChild(int event) {
        TestElement element = new TestElement(this.fModel, this);
        element.fSomeName = "added";
        this.addChild(element, new TestModelChange(event, this, element));
        return element;
    }

    public TestElement addChild(TestElement element, TestModelChange change) {
        this.fChildren.add(element);
        this.fModel.fireModelChanged(change);
        return element;
    }

    public void addChildren(TestElement[] elements, TestModelChange change) {
        this.fChildren.addAll(Arrays.asList(elements));
        this.fModel.fireModelChanged(change);
    }

    public TestElement[] addChildren(int event) {
        TestElement[] elements = new TestElement[]{new TestElement(this.fModel, this), new TestElement(this.fModel, this)};
        elements[0].fSomeName = "added1";
        elements[1].fSomeName = "added2";
        elements[1].fId = String.valueOf(elements[1].fId) + "madeUnique";
        this.addChildren(elements, new TestModelChange(event, this, elements));
        return elements;
    }

    public TestElement basicAddChild() {
        TestElement element = new TestElement(this.fModel, this);
        element.fSomeName = "added";
        this.fChildren.add(element);
        return element;
    }

    public void basicDeleteChild(TestElement element) {
        this.fChildren.remove(element);
        element.fIsDeleted = true;
    }

    private int childId() {
        String id = this.fId.substring(this.fId.lastIndexOf(45) + 1);
        return Integer.parseInt(id);
    }

    public Object clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new Error();
        }
    }

    public static TestElement createModel(int numLevels, int numChildren) {
        return new TestElement(new TestModel(numLevels, numChildren), null, 0, 0);
    }

    public void deleteChild(TestElement element) {
        this.deleteChild(element, new TestModelChange(2, this, element));
    }

    public void deleteChild(TestElement element, TestModelChange change) {
        this.basicDeleteChild(element);
        this.fModel.fireModelChanged(change);
    }

    public void deleteChildren() {
        int i = this.fChildren.size() - 1;
        while (i >= 0) {
            TestElement te = this.fChildren.elementAt(i);
            this.fChildren.remove(te);
            te.fIsDeleted = true;
            --i;
        }
        this.fModel.fireModelChanged(new TestModelChange(3, this));
    }

    public void deleteSomeChildren() {
        int i = this.fChildren.size() - 1;
        while (i >= 0) {
            TestElement te = this.fChildren.elementAt(i);
            this.fChildren.remove(te);
            te.fIsDeleted = true;
            i -= 2;
        }
        this.fModel.fireModelChanged(new TestModelChange(3, this));
    }

    public boolean equals(Object arg) {
        if (arg instanceof TestElement) {
            TestElement element = (TestElement)arg;
            return element.fId.equals(this.fId);
        }
        return false;
    }

    public TestElement getChildAt(int i) {
        return this.fChildren.elementAt(i);
    }

    public int getChildCount() {
        return this.fChildren.size();
    }

    public TestElement[] getChildren() {
        TestElement[] result = new TestElement[this.fChildren.size()];
        this.fChildren.toArray(result);
        return result;
    }

    public TestElement getContainer() {
        return this.fContainer;
    }

    public TestElement getFirstChild() {
        if (!this.fChildren.isEmpty()) {
            return this.fChildren.elementAt(0);
        }
        return null;
    }

    public String getID() {
        return this.fId;
    }

    public String getLabel() {
        return this.fSomeName;
    }

    public TestElement getLastChild() {
        int size = this.fChildren.size();
        if (size > 0) {
            return this.fChildren.elementAt(size - 1);
        }
        return null;
    }

    public TestModel getModel() {
        return this.fModel;
    }

    public int hashCode() {
        return this.fId.hashCode();
    }

    public boolean isDeleted() {
        return this.fIsDeleted;
    }

    public void setLabel(String label) {
        this.fSomeName = label;
        this.fModel.fireModelChanged(new TestModelChange(4, this));
    }

    public boolean testDeleted() {
        if (this.fIsDeleted) {
            return true;
        }
        if (this.fContainer != null) {
            return this.fContainer.testDeleted();
        }
        return false;
    }

    public String toString() {
        return this.getID() + " " + this.getLabel();
    }
}

