/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jface.tests.viewers;

import java.util.Vector;
import org.eclipse.jface.tests.viewers.ITestModelListener;
import org.eclipse.jface.tests.viewers.TestModelChange;

public class TestModel {
    Vector<ITestModelListener> fListeners = new Vector();
    int fNumLevels;
    int fNumChildren;

    public TestModel(int numLevels, int numChildren) {
        this.fNumLevels = numLevels;
        this.fNumChildren = numChildren;
    }

    public void addListener(ITestModelListener listener) {
        this.fListeners.addElement(listener);
    }

    public void fireModelChanged(TestModelChange change) {
        int i = 0;
        while (i < this.fListeners.size()) {
            ITestModelListener listener = this.fListeners.get(i);
            listener.testModelChanged(change);
            ++i;
        }
    }

    public int getNumChildren() {
        return this.fNumChildren;
    }

    public int getNumLevels() {
        return this.fNumLevels;
    }

    public void removeListener(ITestModelListener listener) {
        this.fListeners.removeElement(listener);
    }
}

