/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jface.tests.viewers;

import org.eclipse.jface.tests.viewers.TestElement;

public class TestModelChange {
    private final int fKind;
    private final TestElement fParent;
    private final TestElement[] fChildren;
    public static final int KIND_MASK = 15;
    public static final int INSERT = 1;
    public static final int REMOVE = 2;
    public static final int STRUCTURE_CHANGE = 3;
    public static final int NON_STRUCTURE_CHANGE = 4;
    public static final int REVEAL = 16;
    public static final int SELECT = 32;

    public TestModelChange(int kind, TestElement parent) {
        this(kind, parent, new TestElement[0]);
    }

    public TestModelChange(int kind, TestElement parent, TestElement[] children) {
        this.fKind = kind;
        this.fParent = parent;
        this.fChildren = children;
    }

    public TestModelChange(int kind, TestElement parent, TestElement child) {
        this(kind, parent, new TestElement[]{child});
    }

    public TestElement[] getChildren() {
        return this.fChildren;
    }

    public int getKind() {
        return this.fKind & 0xF;
    }

    public int getModifiers() {
        return this.fKind & 0xFFFFFFF0;
    }

    public TestElement getParent() {
        return this.fParent;
    }
}

