/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jface.tests.viewers;

import org.eclipse.core.runtime.Assert;
import org.eclipse.jface.tests.viewers.ITestModelListener;
import org.eclipse.jface.tests.viewers.TestElement;
import org.eclipse.jface.tests.viewers.TestModelChange;
import org.eclipse.jface.viewers.AbstractTreeViewer;
import org.eclipse.jface.viewers.ComboViewer;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.ListViewer;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;

public class TestModelContentProvider
implements ITestModelListener,
ITreeContentProvider {
    Viewer fViewer;

    public void dispose() {
    }

    protected void doInsert(TestModelChange change) {
        Viewer viewer = this.fViewer;
        if (viewer instanceof ListViewer) {
            ListViewer viewer2 = (ListViewer)viewer;
            if (change.getParent() != null && change.getParent().equals(this.fViewer.getInput())) {
                viewer2.add((Object[])change.getChildren());
            }
        } else {
            Viewer viewer3 = this.fViewer;
            if (viewer3 instanceof TableViewer) {
                TableViewer viewer4 = (TableViewer)viewer3;
                if (change.getParent() != null && change.getParent().equals(this.fViewer.getInput())) {
                    viewer4.add((Object[])change.getChildren());
                }
            } else {
                Viewer viewer5 = this.fViewer;
                if (viewer5 instanceof AbstractTreeViewer) {
                    AbstractTreeViewer viewer6 = (AbstractTreeViewer)viewer5;
                    viewer6.add((Object)change.getParent(), (Object[])change.getChildren());
                } else {
                    Viewer viewer7 = this.fViewer;
                    if (viewer7 instanceof ComboViewer) {
                        ComboViewer viewer8 = (ComboViewer)viewer7;
                        viewer8.add((Object[])change.getChildren());
                    } else {
                        Assert.isTrue((boolean)false, (String)"Unknown kind of viewer");
                    }
                }
            }
        }
    }

    protected void doNonStructureChange(TestModelChange change) {
        Viewer viewer = this.fViewer;
        if (viewer instanceof StructuredViewer) {
            StructuredViewer viewer2 = (StructuredViewer)viewer;
            viewer2.update((Object)change.getParent(), new String[]{"org.eclipse.jface.text"});
        } else {
            Assert.isTrue((boolean)false, (String)"Unknown kind of viewer");
        }
    }

    protected void doRemove(TestModelChange change) {
        Viewer viewer = this.fViewer;
        if (viewer instanceof ListViewer) {
            ListViewer viewer2 = (ListViewer)viewer;
            viewer2.remove((Object[])change.getChildren());
        } else {
            Viewer viewer3 = this.fViewer;
            if (viewer3 instanceof TableViewer) {
                TableViewer viewer4 = (TableViewer)viewer3;
                viewer4.remove((Object[])change.getChildren());
            } else {
                Viewer viewer5 = this.fViewer;
                if (viewer5 instanceof AbstractTreeViewer) {
                    AbstractTreeViewer viewer6 = (AbstractTreeViewer)viewer5;
                    viewer6.remove((Object[])change.getChildren());
                } else {
                    Viewer viewer7 = this.fViewer;
                    if (viewer7 instanceof ComboViewer) {
                        ComboViewer viewer8 = (ComboViewer)viewer7;
                        viewer8.remove((Object[])change.getChildren());
                    } else {
                        Assert.isTrue((boolean)false, (String)"Unknown kind of viewer");
                    }
                }
            }
        }
    }

    protected void doStructureChange(TestModelChange change) {
        Viewer viewer = this.fViewer;
        if (viewer instanceof StructuredViewer) {
            StructuredViewer viewer2 = (StructuredViewer)viewer;
            viewer2.refresh((Object)change.getParent());
        } else {
            Assert.isTrue((boolean)false, (String)"Unknown kind of viewer");
        }
    }

    public Object[] getChildren(Object element) {
        TestElement testElement = (TestElement)element;
        int count = testElement.getChildCount();
        Object[] children = new TestElement[count];
        int i = 0;
        while (i < count) {
            children[i] = testElement.getChildAt(i);
            ++i;
        }
        return children;
    }

    public Object[] getElements(Object element) {
        return this.getChildren(element);
    }

    public Object getParent(Object element) {
        return ((TestElement)element).getContainer();
    }

    public boolean hasChildren(Object element) {
        return ((TestElement)element).getChildCount() > 0;
    }

    public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        TestElement newElement;
        this.fViewer = viewer;
        TestElement oldElement = (TestElement)oldInput;
        if (oldElement != null) {
            oldElement.getModel().removeListener(this);
        }
        if ((newElement = (TestElement)newInput) != null) {
            newElement.getModel().addListener(this);
        }
    }

    public boolean isDeleted(Object element) {
        return ((TestElement)element).isDeleted();
    }

    @Override
    public void testModelChanged(TestModelChange change) {
        Object element;
        switch (change.getKind()) {
            case 1: {
                this.doInsert(change);
                break;
            }
            case 2: {
                this.doRemove(change);
                break;
            }
            case 3: {
                this.doStructureChange(change);
                break;
            }
            case 4: {
                this.doNonStructureChange(change);
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown kind of change");
            }
        }
        StructuredSelection selection = new StructuredSelection((Object[])change.getChildren());
        if ((change.getModifiers() & 0x20) != 0) {
            this.fViewer.setSelection((ISelection)selection);
        }
        if ((change.getModifiers() & 0x10) != 0 && (element = selection.getFirstElement()) != null) {
            ((StructuredViewer)this.fViewer).reveal(element);
        }
    }
}

