/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jface.tests.viewers;

import org.eclipse.jface.tests.viewers.TestElement;
import org.eclipse.jface.tests.viewers.TestModelContentProvider;
import org.eclipse.jface.viewers.ILazyTreeContentProvider;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.junit.Assert;

public class TestModelLazyTreeContentProvider
extends TestModelContentProvider
implements ILazyTreeContentProvider {
    private final TreeViewer treeViewer;

    public TestModelLazyTreeContentProvider(TreeViewer treeViewer) {
        this.treeViewer = treeViewer;
    }

    public void updateElement(Object parent, int index) {
        TestElement parentElement = (TestElement)parent;
        if (parentElement.getChildCount() > index) {
            TestElement childElement = parentElement.getChildAt(index);
            this.treeViewer.replace(parent, index, (Object)childElement);
            this.treeViewer.setChildCount((Object)childElement, childElement.getChildCount());
        }
    }

    @Override
    public Object[] getChildren(Object element) {
        Assert.fail((String)"should not be called on a LazyTreeContentProvider");
        return null;
    }

    @Override
    public Object[] getElements(Object element) {
        Assert.fail((String)"should not be called on a LazyTreeContentProvider");
        return null;
    }

    @Override
    public boolean hasChildren(Object element) {
        Assert.fail((String)"should not be called on a LazyTreeContentProvider");
        return false;
    }

    @Override
    public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        super.inputChanged(viewer, oldInput, newInput);
    }

    public void updateChildCount(Object element, int currentChildCount) {
        this.treeViewer.setChildCount(element, ((TestElement)element).getChildCount());
    }
}

