/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jface.tests.viewers;

import java.util.ArrayList;
import java.util.Arrays;
import org.eclipse.jface.tests.viewers.StructuredSelectionTest;
import org.eclipse.jface.viewers.IElementComparer;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreePath;
import org.eclipse.jface.viewers.TreeSelection;
import org.junit.Assert;
import org.junit.Test;

public class TreeSelectionTest {
    @Test
    public void testNewWithEmptyTreePath() {
        Assert.assertNotNull((Object)new TreeSelection(new TreePath(new Object[0])));
    }

    @Test
    public void testBug1384558() {
        Object one = new Object();
        Object two = new Object();
        Object three = new Object();
        TreePath[] treePaths1 = new TreePath[]{new TreePath(new Object[]{one, two}), new TreePath(new Object[]{one, three}), new TreePath(new Object[]{two, two})};
        TreeSelection treeSelection1 = new TreeSelection(treePaths1);
        TreePath[] treePaths2 = new TreePath[]{new TreePath(new Object[]{one, two}), new TreePath(new Object[]{one, three})};
        TreeSelection treeSelection2 = new TreeSelection(treePaths2);
        Assert.assertFalse((boolean)treeSelection1.equals((Object)treeSelection2));
        StructuredSelectionTest.EqualsHashCodeContractTestHelper.testExpectedNotEqualsObjects(treeSelection1, treeSelection2);
    }

    @Test
    public void testEquals1() {
        StructuredSelectionTest.EqualsHashCodeContractTestHelper.testExpectedEqualsObjects(new TreeSelection(), new TreeSelection());
    }

    @Test
    public void testEquals2() {
        StructuredSelectionTest.EqualsHashCodeContractTestHelper.testExpectedEqualsObjects(new TreeSelection(null), new TreeSelection(null));
    }

    @Test
    public void testEquals3() {
        StructuredSelectionTest.EqualsHashCodeContractTestHelper.testExpectedEqualsObjects(new TreeSelection(null), new TreeSelection(null));
    }

    @Test
    public void testEquals4() {
        StructuredSelectionTest.EqualsHashCodeContractTestHelper.testExpectedEqualsObjects(new TreeSelection(new TreePath[0]), new TreeSelection(new TreePath[0]));
    }

    @Test
    public void testEquals5() {
        Object one = new Object();
        StructuredSelectionTest.EqualsHashCodeContractTestHelper.testExpectedEqualsObjects(new TreeSelection(TreeSelectionTest.newTreePath(one)), new TreeSelection(TreeSelectionTest.newTreePath(one)));
    }

    @Test
    public void testEquals6() {
        Object one = new Object();
        Object two = new Object();
        StructuredSelectionTest.EqualsHashCodeContractTestHelper.testExpectedNotEqualsObjects(new TreeSelection(TreeSelectionTest.newTreePath(one)), new TreeSelection(TreeSelectionTest.newTreePath(two)));
    }

    @Test
    public void testEquals7() {
        Object one = new Object();
        Object two = new Object();
        Object three = new Object();
        StructuredSelectionTest.EqualsHashCodeContractTestHelper.testExpectedEqualsObjects(new TreeSelection(TreeSelectionTest.newTreePath(one, two, three)), new TreeSelection(TreeSelectionTest.newTreePath(one, two, three)));
    }

    @Test
    public void testEquals8() {
        Object one = new Object();
        Object two = new Object();
        StructuredSelectionTest.EqualsHashCodeContractTestHelper.testExpectedNotEqualsObjects(new TreeSelection(TreeSelectionTest.newTreePath(one, two)), new TreeSelection(TreeSelectionTest.newTreePath(two, one)));
    }

    @Test
    public void testEquals9() {
        Object one = new Object();
        Object two = new Object();
        Object three = new Object();
        Object four = new Object();
        StructuredSelectionTest.EqualsHashCodeContractTestHelper.testExpectedEqualsObjects(new TreeSelection(TreeSelectionTest.newTreePaths(TreeSelectionTest.newTreePath(one, two), TreeSelectionTest.newTreePath(three, four))), new TreeSelection(TreeSelectionTest.newTreePaths(TreeSelectionTest.newTreePath(one, two), TreeSelectionTest.newTreePath(three, four))));
    }

    @Test
    public void testEquals10() {
        Object one = new Object();
        Object two = new Object();
        Object three = new Object();
        Object four = new Object();
        StructuredSelectionTest.EqualsHashCodeContractTestHelper.testExpectedNotEqualsObjects(new TreeSelection(TreeSelectionTest.newTreePaths(TreeSelectionTest.newTreePath(one, two), TreeSelectionTest.newTreePath(three, four))), new TreeSelection(TreeSelectionTest.newTreePaths(TreeSelectionTest.newTreePath(three, four), TreeSelectionTest.newTreePath(one, two))));
    }

    @Test
    public void testEquals11() {
        StructuredSelectionTest.EqualsHashCodeContractTestHelper.testExpectedEqualsObjects(new TreeSelection(), new StructuredSelection());
    }

    @Test
    public void testEquals12() {
        StructuredSelectionTest.EqualsHashCodeContractTestHelper.testExpectedEqualsObjects(new TreeSelection(null), new StructuredSelection());
    }

    @Test
    public void testEquals13() {
        StructuredSelectionTest.EqualsHashCodeContractTestHelper.testExpectedEqualsObjects(new TreeSelection(TreeSelectionTest.newTreePath("element")), new StructuredSelection((Object)"element"));
    }

    @Test
    public void testEquals14() {
        StructuredSelectionTest.EqualsHashCodeContractTestHelper.testExpectedNotEqualsObjects(new TreeSelection(TreeSelectionTest.newTreePath("element 1")), new StructuredSelection((Object)"element 2"));
    }

    @Test
    public void testEquals15() {
        StructuredSelectionTest.EqualsHashCodeContractTestHelper.testExpectedEqualsObjects(new TreeSelection(TreeSelectionTest.newTreePath("element 1", "element 2")), new StructuredSelection(Arrays.asList("element 2")));
        StructuredSelectionTest.EqualsHashCodeContractTestHelper.testExpectedEqualsObjects(new TreeSelection(TreeSelectionTest.newTreePath("element 1", "element 2")), new StructuredSelection(new Object[]{"element 2"}));
    }

    @Test
    public void testEquals16() {
        StructuredSelectionTest.EqualsHashCodeContractTestHelper.testExpectedEqualsObjects(new TreeSelection(TreeSelectionTest.newTreePaths(TreeSelectionTest.newTreePath("element 1", "element 2"), TreeSelectionTest.newTreePath("element 3", "element 4"))), new StructuredSelection(Arrays.asList("element 2", "element 4")));
    }

    @Test
    public void testEquals17() {
        StructuredSelectionTest.EqualsHashCodeContractTestHelper.testExpectedNotEqualsObjects(new TreeSelection(TreeSelectionTest.newTreePaths(TreeSelectionTest.newTreePath("element 1", "element 2"), TreeSelectionTest.newTreePath("element 3", "element 4"))), new StructuredSelection(Arrays.asList("element 4", "element 2")));
    }

    @Test
    public void testEquals18() {
        TreeSelectionTest.doTestEquals18(StructuredSelectionTest.JAVA_LANG_OBJECT_COMPARER);
        TreeSelectionTest.doTestEquals18(StructuredSelectionTest.IDENTITY_COMPARER);
    }

    private static void doTestEquals18(IElementComparer comparer) {
        StructuredSelectionTest.EqualsHashCodeContractTestHelper.testExpectedEqualsObjects(new TreeSelection(null, comparer), new StructuredSelection(new ArrayList(), comparer));
    }

    @Test
    public void testEquals19() {
        TreeSelectionTest.doTestEquals19(StructuredSelectionTest.JAVA_LANG_OBJECT_COMPARER);
        TreeSelectionTest.doTestEquals19(StructuredSelectionTest.IDENTITY_COMPARER);
    }

    private static void doTestEquals19(IElementComparer comparer) {
        StructuredSelectionTest.EqualsHashCodeContractTestHelper.testExpectedEqualsObjects(new TreeSelection(TreeSelectionTest.newTreePath("element 1", "element 2"), comparer), new StructuredSelection(Arrays.asList("element 2"), comparer));
    }

    @Test
    public void testEquals20() {
        TreeSelectionTest.doTestEquals20(StructuredSelectionTest.JAVA_LANG_OBJECT_COMPARER);
        TreeSelectionTest.doTestEquals20(StructuredSelectionTest.IDENTITY_COMPARER);
    }

    private static void doTestEquals20(IElementComparer comparer) {
        StructuredSelectionTest.EqualsHashCodeContractTestHelper.testExpectedEqualsObjects(new TreeSelection(TreeSelectionTest.newTreePaths(TreeSelectionTest.newTreePath("element 1", "element 2"), TreeSelectionTest.newTreePath("element 3", "element 4")), comparer), new StructuredSelection(Arrays.asList("element 2", "element 4"), comparer));
    }

    @Test
    public void testEquals21() {
        TreeSelectionTest.doTestEquals21(StructuredSelectionTest.JAVA_LANG_OBJECT_COMPARER);
        TreeSelectionTest.doTestEquals21(StructuredSelectionTest.IDENTITY_COMPARER);
    }

    private static void doTestEquals21(IElementComparer comparer) {
        StructuredSelectionTest.EqualsHashCodeContractTestHelper.testExpectedNotEqualsObjects(new TreeSelection(TreeSelectionTest.newTreePath("element 1"), comparer), new StructuredSelection(Arrays.asList("element 2"), comparer));
    }

    @Test
    public void testEquals22() {
        TreeSelectionTest.doTestEquals22(StructuredSelectionTest.JAVA_LANG_OBJECT_COMPARER);
        TreeSelectionTest.doTestEquals22(StructuredSelectionTest.IDENTITY_COMPARER);
    }

    private static void doTestEquals22(IElementComparer comparer) {
        StructuredSelectionTest.EqualsHashCodeContractTestHelper.testExpectedNotEqualsObjects(new TreeSelection(TreeSelectionTest.newTreePath("element 1"), comparer), new StructuredSelection(new ArrayList(), comparer));
    }

    @Test
    public void testEquals23() {
        TreeSelectionTest.doTestEquals23(StructuredSelectionTest.JAVA_LANG_OBJECT_COMPARER);
        TreeSelectionTest.doTestEquals23(StructuredSelectionTest.IDENTITY_COMPARER);
    }

    private static void doTestEquals23(IElementComparer comparer) {
        StructuredSelectionTest.EqualsHashCodeContractTestHelper.testExpectedNotEqualsObjects(new TreeSelection(null, comparer), new StructuredSelection(Arrays.asList("element"), comparer));
    }

    private static TreePath newTreePath(Object ... args) {
        return new TreePath(args);
    }

    private static TreePath[] newTreePaths(TreePath ... args) {
        return args;
    }
}

