/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jface.tests.viewers;

import java.lang.reflect.Method;
import org.eclipse.jface.tests.viewers.AbstractTreeViewerTest;
import org.eclipse.jface.tests.viewers.StructuredViewerTest;
import org.eclipse.jface.tests.viewers.TestElement;
import org.eclipse.jface.tests.viewers.TestModelContentProvider;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.ViewerColumn;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeColumn;
import org.eclipse.swt.widgets.TreeItem;
import org.junit.Assert;
import org.junit.Test;

public class TreeViewerColumnTest
extends AbstractTreeViewerTest {
    @Override
    protected StructuredViewer createViewer(Composite parent) {
        TreeViewer viewer = new TreeViewer(parent);
        viewer.setContentProvider((IContentProvider)new TestModelContentProvider());
        viewer.setLabelProvider((IBaseLabelProvider)new TableTreeTestLabelProvider());
        viewer.getTree().setLinesVisible(true);
        viewer.getTree().setHeaderVisible(true);
        String[] headers = new String[]{"column 1 header", "column 2 header"};
        TreeColumn[] columns = new TreeColumn[headers.length];
        int i = 0;
        while (i < headers.length) {
            TreeColumn tc = new TreeColumn(viewer.getTree(), 0, i);
            tc.setResizable(true);
            tc.setText(headers[i]);
            tc.setWidth(25);
            columns[i] = tc;
            ++i;
        }
        this.fTreeViewer = viewer;
        return viewer;
    }

    @Override
    protected int getItemCount() {
        TestElement first = this.fRootElement.getFirstChild();
        TreeItem ti = (TreeItem)this.fViewer.testFindItem((Object)first);
        return ti.getParent().getItemCount();
    }

    @Override
    protected int getItemCount(TestElement element) {
        TreeItem ti = (TreeItem)this.fViewer.testFindItem((Object)element);
        return ti.getItemCount();
    }

    @Override
    protected String getItemText(int at) {
        return ((Tree)this.fViewer.getControl()).getItems()[at].getText();
    }

    private static ViewerColumn getViewerColumn(ColumnViewer viewer, int index) {
        try {
            Method method = ColumnViewer.class.getDeclaredMethod("getViewerColumn", Integer.TYPE);
            method.setAccessible(true);
            return (ViewerColumn)method.invoke((Object)viewer, index);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Test
    public void testViewerColumn() {
        Assert.assertNull((Object)TreeViewerColumnTest.getViewerColumn((ColumnViewer)((TreeViewer)this.fViewer), -1));
        Assert.assertNotNull((Object)TreeViewerColumnTest.getViewerColumn((ColumnViewer)((TreeViewer)this.fViewer), 0));
        Assert.assertNotNull((Object)TreeViewerColumnTest.getViewerColumn((ColumnViewer)((TreeViewer)this.fViewer), 1));
        Assert.assertNull((Object)TreeViewerColumnTest.getViewerColumn((ColumnViewer)((TreeViewer)this.fViewer), 2));
    }

    @Override
    @Test
    public void testLabelProvider() {
        TreeViewer viewer = (TreeViewer)this.fViewer;
        TableTreeTestLabelProvider provider = (TableTreeTestLabelProvider)viewer.getLabelProvider();
        provider.fExtended = true;
        this.fViewer.refresh();
        TestElement first = this.fRootElement.getFirstChild();
        String newLabel = TreeViewerColumnTest.providedString(first);
        Assert.assertEquals((String)"rendered label", (Object)newLabel, (Object)this.getItemText(0));
        provider.fExtended = false;
        this.fViewer.refresh();
    }

    @Override
    @Test
    public void testLabelProviderStateChange() {
        TreeViewer viewer = (TreeViewer)this.fViewer;
        TableTreeTestLabelProvider provider = (TableTreeTestLabelProvider)viewer.getLabelProvider();
        provider.fExtended = true;
        provider.setSuffix("added suffix");
        this.fViewer.refresh();
        TestElement first = this.fRootElement.getFirstChild();
        String newLabel = TreeViewerColumnTest.providedString(first);
        Assert.assertEquals((String)"rendered label", (Object)newLabel, (Object)this.getItemText(0));
        provider.fExtended = false;
        this.fViewer.refresh();
    }

    public static class TableTreeTestLabelProvider
    extends StructuredViewerTest.TestLabelProvider
    implements ITableLabelProvider {
        public boolean fExtended = false;

        @Override
        public String getText(Object element) {
            if (this.fExtended) {
                return TreeViewerColumnTest.providedString((String)element);
            }
            return element.toString();
        }

        public String getColumnText(Object element, int index) {
            if (this.fExtended) {
                return TreeViewerColumnTest.providedString((TestElement)element);
            }
            return element.toString();
        }

        public Image getColumnImage(Object element, int columnIndex) {
            return null;
        }
    }
}

