/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jface.tests.viewers;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.jface.tests.viewers.ViewerComparatorTest;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeItem;
import org.junit.Assert;
import org.junit.Test;

public class TreeViewerComparatorTest
extends ViewerComparatorTest {
    @Test
    public void testViewerSorter() {
        this.fViewer.setSorter(new ViewerSorter());
        this.getTreeViewer().expandAll();
        String[][] expected = new String[][]{this.TEAM3_SORTED, this.TEAM2_SORTED, this.TEAM1_SORTED};
        this.assertSortedResult(expected);
    }

    @Test
    public void testViewerSorterInsertElement() {
        this.fViewer.setSorter(new ViewerSorter());
        this.getTreeViewer().expandAll();
        this.team1.addMember("Duong");
        String[][] expected = new String[][]{this.TEAM3_SORTED, this.TEAM2_SORTED, this.TEAM1_SORTED_WITH_INSERT};
        this.assertSortedResult(expected);
    }

    @Test
    public void testViewerComparator() {
        this.fViewer.setComparator(new ViewerComparator());
        this.getTreeViewer().expandAll();
        String[][] expected = new String[][]{this.TEAM3_SORTED, this.TEAM2_SORTED, this.TEAM1_SORTED};
        this.assertSortedResult(expected);
    }

    @Test
    public void testViewerComparatorInsertElement() {
        this.fViewer.setComparator(new ViewerComparator());
        this.getTreeViewer().expandAll();
        this.team1.addMember("Duong");
        String[][] expected = new String[][]{this.TEAM3_SORTED, this.TEAM2_SORTED, this.TEAM1_SORTED_WITH_INSERT};
        this.assertSortedResult(expected);
    }

    private void assertSortedResult(String[][] resultArrays) {
        String result;
        TreeItem child;
        TreeItem[] rootItems = this.getTreeViewer().getTree().getItems();
        Assert.assertEquals((String)("Number of root items in tree not correct (actual=" + rootItems.length + ")"), (long)3L, (long)rootItems.length);
        TreeItem item = rootItems[0];
        Assert.assertEquals((String)("Item not expected.  actual=" + item.getText() + " expected=" + this.CORE), (Object)this.CORE, (Object)item.getText());
        item = rootItems[1];
        Assert.assertEquals((String)("Item not expected.  actual=" + item.getText() + " expected=" + this.RUNTIME), (Object)this.RUNTIME, (Object)item.getText());
        item = rootItems[2];
        Assert.assertEquals((String)("Item not expected.  actual=" + item.getText() + " expected=" + this.UI), (Object)this.UI, (Object)item.getText());
        TreeItem[] childItems = rootItems[0].getItems();
        int i = 0;
        while (i < childItems.length) {
            child = childItems[i];
            result = child.getText();
            Assert.assertEquals((String)"", (Object)resultArrays[0][i], (Object)result);
            ++i;
        }
        childItems = rootItems[1].getItems();
        i = 0;
        while (i < childItems.length) {
            child = childItems[i];
            result = child.getText();
            Assert.assertEquals((String)"", (Object)resultArrays[1][i], (Object)result);
            ++i;
        }
        childItems = rootItems[2].getItems();
        i = 0;
        while (i < childItems.length) {
            child = childItems[i];
            result = child.getText();
            Assert.assertEquals((String)"", (Object)resultArrays[2][i], (Object)result);
            ++i;
        }
    }

    protected TreeViewer getTreeViewer() {
        return (TreeViewer)this.fViewer;
    }

    @Override
    protected StructuredViewer createViewer(Composite parent) {
        Tree tree = new Tree((Composite)this.fShell, 2820);
        TreeViewer viewer = new TreeViewer(tree);
        viewer.setContentProvider((IContentProvider)new TeamModelTreeContentProvider());
        viewer.setLabelProvider((IBaseLabelProvider)new ViewerComparatorTest.TeamModelLabelProvider());
        return viewer;
    }

    @Override
    protected void setInput() {
        ArrayList<ViewerComparatorTest.Team> input = new ArrayList<ViewerComparatorTest.Team>(3);
        input.add(this.team1);
        input.add(this.team2);
        input.add(this.team3);
        this.fViewer.setInput(input);
    }

    protected class TeamModelTreeContentProvider
    extends ViewerComparatorTest.TeamModelContentProvider
    implements ITreeContentProvider {
        protected TeamModelTreeContentProvider() {
            super(TreeViewerComparatorTest.this);
        }

        @Override
        public Object[] getElements(Object inputElement) {
            return this.getChildren(inputElement);
        }

        public Object[] getChildren(Object parentElement) {
            if (parentElement instanceof List) {
                List list = (List)parentElement;
                ArrayList<ViewerComparatorTest.Team> children = new ArrayList<ViewerComparatorTest.Team>();
                for (Object next : list) {
                    if (!(next instanceof ViewerComparatorTest.Team)) continue;
                    ViewerComparatorTest.Team team = (ViewerComparatorTest.Team)next;
                    children.add(team);
                }
                return children.toArray(new ViewerComparatorTest.Team[children.size()]);
            }
            if (parentElement instanceof ViewerComparatorTest.Team) {
                ViewerComparatorTest.Team team = (ViewerComparatorTest.Team)parentElement;
                return team.members;
            }
            return null;
        }

        public Object getParent(Object element) {
            if (element instanceof ViewerComparatorTest.TeamMember) {
                ViewerComparatorTest.TeamMember member = (ViewerComparatorTest.TeamMember)element;
                return member.team;
            }
            return null;
        }

        public boolean hasChildren(Object element) {
            return element instanceof ViewerComparatorTest.Team && this.getChildren(element).length > 0;
        }

        @Override
        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
            List newElement;
            List oldElement = (List)oldInput;
            if (oldElement != null) {
                for (ViewerComparatorTest.Team element : oldElement) {
                    element.removeListener(this);
                }
            }
            if ((newElement = (List)newInput) != null) {
                for (ViewerComparatorTest.Team element : newElement) {
                    element.addListener(this);
                }
            }
        }
    }
}

