/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jface.tests.viewers;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.concurrent.ConcurrentLinkedQueue;
import org.eclipse.jface.tests.viewers.AbstractTreeViewerTest;
import org.eclipse.jface.tests.viewers.TestElement;
import org.eclipse.jface.tests.viewers.TestModelContentProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.swt.widgets.Widget;
import org.junit.Assert;
import org.junit.Test;

public class TreeViewerTest
extends AbstractTreeViewerTest {
    @Override
    protected StructuredViewer createViewer(Composite parent) {
        this.fTreeViewer = new TreeViewer(parent);
        this.fTreeViewer.setContentProvider((IContentProvider)new TestModelContentProvider());
        return this.fTreeViewer;
    }

    @Override
    protected int getItemCount() {
        TestElement first = this.fRootElement.getFirstChild();
        TreeItem ti = (TreeItem)this.fViewer.testFindItem((Object)first);
        Tree tree = ti.getParent();
        return tree.getItemCount();
    }

    @Override
    protected int getItemCount(TestElement element) {
        return element.getChildCount();
    }

    @Override
    protected String getItemText(int at) {
        Tree tree = (Tree)this.fTreeViewer.getControl();
        return tree.getItems()[at].getText();
    }

    @Test
    public void testAutoExpandOnSingleChildThroughEvent() {
        TestElement modelRoot = TestElement.createModel(5, 1);
        TestElement trivialPathRoot = modelRoot.getFirstChild();
        this.fViewer.setInput((Object)modelRoot);
        this.fTreeViewer.setAutoExpandOnSingleChildLevels(2);
        Tree tree = (Tree)this.fTreeViewer.getControl();
        TreeItem itemToExpand = ((Tree)this.fViewer.getControl()).getItem(0);
        Event event = new Event();
        event.item = itemToExpand;
        tree.notifyListeners(17, event);
        Assert.assertTrue((String)"The expanded widget child is not expanded", (boolean)this.fTreeViewer.getExpandedState((Object)trivialPathRoot));
        Assert.assertTrue((String)"The first child of the trivial path was not auto-expanded", (boolean)this.fTreeViewer.getExpandedState((Object)trivialPathRoot.getFirstChild()));
        Assert.assertFalse((String)"Trivial path is expanded further than specified depth ", (boolean)this.fTreeViewer.getExpandedState((Object)trivialPathRoot.getFirstChild().getFirstChild()));
    }

    @Test
    public void testInternalExpandToLevelRecursive() {
        final ArrayList recursiveExpandedElements = new ArrayList();
        TreeViewer viewer = new TreeViewer((Composite)this.fShell){

            protected void internalExpandToLevel(Widget widget, int level) {
                if (widget != this.getTree()) {
                    recursiveExpandedElements.add(widget.getData());
                }
                super.internalExpandToLevel(widget, level);
            }
        };
        TestElement rootElement = TestElement.createModel(2, 5);
        viewer.setContentProvider((IContentProvider)new TestModelContentProvider());
        viewer.setInput((Object)rootElement);
        viewer.expandToLevel(-1);
        ConcurrentLinkedQueue<TestElement> elements = new ConcurrentLinkedQueue<TestElement>(Arrays.asList(rootElement.getChildren()));
        while (!elements.isEmpty()) {
            TestElement currentElement = (TestElement)elements.poll();
            Assert.assertTrue((String)("expansion for child was not processed: " + String.valueOf(currentElement)), (boolean)recursiveExpandedElements.contains(currentElement));
            elements.addAll(Arrays.asList(currentElement.getChildren()));
        }
    }
}

