/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jface.tests.viewers;

import java.util.ArrayList;
import org.eclipse.jface.tests.viewers.BaseLimitBasedViewerTest;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.ITreeSelection;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.jface.viewers.internal.ExpandableNode;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.TreeItem;
import org.junit.Assert;
import org.junit.Test;

public class TreeViewerWithLimitTest
extends BaseLimitBasedViewerTest {
    private TestTreeViewer treeViewer;

    @Test
    public void testSetSelection() {
        BaseLimitBasedViewerTest.DataModel firstEle = (BaseLimitBasedViewerTest.DataModel)this.rootModel.get(0);
        this.assertSetSelection(firstEle);
        BaseLimitBasedViewerTest.DataModel invisible = (BaseLimitBasedViewerTest.DataModel)this.rootModel.get(this.rootModel.size() - 4);
        this.assertSetSelectionExpNode(invisible);
    }

    private void assertSetSelectionExpNode(BaseLimitBasedViewerTest.DataModel invisible) {
        this.treeViewer.setSelection((ISelection)new StructuredSelection((Object)invisible), true);
        this.processEvents();
        ITreeSelection selection = this.treeViewer.getStructuredSelection();
        Assert.assertFalse((String)"Selection must not be empty", (boolean)selection.isEmpty());
        Object firstElement = selection.getFirstElement();
        Assert.assertTrue((String)("Selection must be expandable node: " + String.valueOf(firstElement)), (boolean)this.treeViewer.isExpandableNode(firstElement));
    }

    private void assertSetSelection(BaseLimitBasedViewerTest.DataModel firstEle) {
        this.treeViewer.setSelection((ISelection)new StructuredSelection((Object)firstEle));
        this.processEvents();
        ITreeSelection selection = this.treeViewer.getStructuredSelection();
        Assert.assertFalse((String)"Selection must not be empty", (boolean)selection.isEmpty());
        Assert.assertEquals((String)"incorrect element is selected", (Object)firstEle, (Object)selection.getFirstElement());
    }

    @Test
    public void testReveal() throws Exception {
        BaseLimitBasedViewerTest.DataModel firstEle = (BaseLimitBasedViewerTest.DataModel)this.rootModel.get(0);
        BaseLimitBasedViewerTest.DataModel toReveal = firstEle.children.get((int)2).children.get(2);
        this.treeViewer.reveal(toReveal);
        this.assertSetSelection(toReveal);
        BaseLimitBasedViewerTest.DataModel inVisible = firstEle.children.get((int)2).children.get(6);
        this.assertSetSelectionExpNode(inVisible);
        ExpandableNode selected = (ExpandableNode)this.treeViewer.getStructuredSelection().getFirstElement();
        Object[] remaining = selected.getRemainingElements();
        boolean found = false;
        Object[] objectArray = remaining;
        int n = remaining.length;
        int n2 = 0;
        while (n2 < n) {
            Object object = objectArray[n2];
            if (object == inVisible) {
                found = true;
                break;
            }
            ++n2;
        }
        Assert.assertTrue((String)"item to select must be inside expandable node", (boolean)found);
    }

    @Test
    public void testCollapseAll() {
        this.treeViewer.expandAll();
        this.processEvents();
        BaseLimitBasedViewerTest.DataModel l2ThirdEle = ((BaseLimitBasedViewerTest.DataModel)this.rootModel.get((int)0)).children.get((int)2).children.get(2);
        this.assertSetSelection(l2ThirdEle);
        this.treeViewer.collapseAll();
        this.processEvents();
        TreeItem[] items = this.assertLimitedItems();
        int i = 0;
        while (i < 4) {
            TreeItem treeItem = items[i];
            Assert.assertFalse((String)"expansion must be false", (boolean)treeItem.getExpanded());
            ++i;
        }
    }

    @Test
    public void testCollapseToLevel() {
    }

    @Test
    public void testExpandAll() {
        this.treeViewer.expandAll();
        this.processEvents();
        TreeItem[] rootLevelItems = this.assertLimitedItems();
        int i = 0;
        while (i < 4) {
            TreeItem[] items = this.assertLimitedItems(rootLevelItems[i]);
            int j = 0;
            while (j < 4) {
                TreeItem treeItem2 = items[j];
                this.assertLimitedItems(treeItem2);
                ++j;
            }
            ++i;
        }
    }

    private TreeItem[] assertLimitedItems(TreeItem treeItem) {
        TreeItem[] items = treeItem.getItems();
        Assert.assertEquals((String)"There should be only limited items", (long)5L, (long)items.length);
        Object data = items[4].getData();
        Assert.assertTrue((String)"last item must be expandable node", (boolean)this.treeViewer.isExpandableNode(data));
        return items;
    }

    private TreeItem[] assertLimitedItems() {
        TreeItem[] rootLevelItems = this.treeViewer.getTree().getItems();
        Assert.assertEquals((String)"There should be only limited items", (long)5L, (long)rootLevelItems.length);
        Object data = rootLevelItems[4].getData();
        Assert.assertTrue((String)"last item must be expandable node", (boolean)this.treeViewer.isExpandableNode(data));
        return rootLevelItems;
    }

    @Test
    public void testExpandToLevelInt() {
        this.treeViewer.expandToLevel(2, true);
        this.processEvents();
        TreeItem[] rootLevelItems = this.assertLimitedItems();
        int i = 0;
        while (i < 4) {
            TreeItem[] items = this.assertLimitedItems(rootLevelItems[i]);
            int j = 0;
            while (j < 4) {
                TreeViewerWithLimitTest.assertDummyItem(items[j]);
                ++j;
            }
            ++i;
        }
    }

    private static void assertDummyItem(TreeItem treeItem) {
        TreeItem[] items = treeItem.getItems();
        Assert.assertEquals((String)"Item must not be expanded", (long)1L, (long)items.length);
        Assert.assertNull((String)"Dummy tree item data must be null", (Object)items[0].getData());
    }

    @Test
    public void testExpandToLevelObjectInt() {
        BaseLimitBasedViewerTest.DataModel firstEle = (BaseLimitBasedViewerTest.DataModel)this.rootModel.get(0);
        this.treeViewer.expandToLevel(firstEle, 3, true);
        this.processEvents();
        TreeItem[] topLevelItems = this.assertLimitedItems();
        TreeItem firstItem = topLevelItems[0];
        TreeItem[] children = this.assertLimitedItems(firstItem);
        int i = 1;
        while (i < 4) {
            this.assertLimitedItems(children[i]);
            ++i;
        }
        i = 1;
        while (i < 4) {
            TreeViewerWithLimitTest.assertDummyItem(topLevelItems[i]);
            ++i;
        }
    }

    @Test
    public void testRemoveItemsAtParent() {
        this.treeViewer.expandAll();
        this.processEvents();
        BaseLimitBasedViewerTest.DataModel firstEle = (BaseLimitBasedViewerTest.DataModel)this.rootModel.get(0);
        BaseLimitBasedViewerTest.DataModel thirdOfFirst = firstEle.children.get((int)2).children.remove(2);
        TreeItem visItem = this.treeViewer.getTree().getItem(0).getItem(2).getItem(2);
        Assert.assertEquals((String)"element contains unexpected data", (Object)thirdOfFirst, (Object)visItem.getData());
        this.treeViewer.remove(firstEle, new Object[]{thirdOfFirst});
        this.processEvents();
        thirdOfFirst = firstEle.children.get((int)2).children.get(2);
        visItem = this.treeViewer.getTree().getItem(0).getItem(2).getItem(2);
        Assert.assertEquals((String)"element contains unexpected data", (Object)thirdOfFirst, (Object)visItem.getData());
    }

    @Test
    public void testRemoveItem() {
        this.processEvents();
        this.treeViewer.expandAll();
        this.processEvents();
        BaseLimitBasedViewerTest.DataModel firstEle = (BaseLimitBasedViewerTest.DataModel)this.rootModel.remove(0);
        TreeItem firstItem = this.treeViewer.getTree().getItem(0);
        Assert.assertEquals((String)"element contains unexpected data", (Object)firstEle, (Object)firstItem.getData());
        this.treeViewer.remove(firstEle);
        this.processEvents();
        firstEle = (BaseLimitBasedViewerTest.DataModel)this.rootModel.get(0);
        firstItem = this.treeViewer.getTree().getItem(0);
        Assert.assertEquals((String)"element contains unexpected data", (Object)firstEle, (Object)firstItem.getData());
    }

    @Test
    public void testSetAutoExpandLevel() {
        this.treeViewer.setInput(new BaseLimitBasedViewerTest.DataModel(100));
        this.treeViewer.setAutoExpandLevel(2);
        this.treeViewer.setInput(this.rootModel);
        this.processEvents();
        TreeItem[] rootLevelItems = this.assertLimitedItems();
        int i = 0;
        while (i < 4) {
            TreeItem[] items = this.assertLimitedItems(rootLevelItems[i]);
            int j = 0;
            while (j < 4) {
                TreeViewerWithLimitTest.assertDummyItem(items[j]);
                ++j;
            }
            ++i;
        }
    }

    @Test
    public void testInsert() {
        TreeItem thirdItem = this.treeViewer.getTree().getItem(2);
        Assert.assertEquals((String)"unexpected element found at position 2", this.rootModel.get(2), (Object)thirdItem.getData());
        BaseLimitBasedViewerTest.DataModel newElement = new BaseLimitBasedViewerTest.DataModel(3);
        this.rootModel.add(newElement);
        this.treeViewer.insert(this.rootModel, newElement, 2);
        this.processEvents();
        thirdItem = this.treeViewer.getTree().getItem(2);
        Assert.assertEquals((String)"unexpected element found at position 2", (Object)newElement, (Object)thirdItem.getData());
    }

    @Test
    public void testRefresh() {
        BaseLimitBasedViewerTest.DataModel firstEle = (BaseLimitBasedViewerTest.DataModel)this.rootModel.remove(0);
        TreeItem firstItem = this.treeViewer.getTree().getItem(0);
        Assert.assertEquals((String)"element contains unexpected data", (Object)firstEle, (Object)firstItem.getData());
        this.treeViewer.refresh();
        this.processEvents();
        firstEle = (BaseLimitBasedViewerTest.DataModel)this.rootModel.get(0);
        firstItem = this.treeViewer.getTree().getItem(0);
        Assert.assertEquals((String)"element contains unexpected data", (Object)firstEle, (Object)firstItem.getData());
    }

    @Test
    public void testSetFilters() {
        BaseLimitBasedViewerTest.DataModel firstEle = (BaseLimitBasedViewerTest.DataModel)this.rootModel.get(0);
        TreeItem firstItem = this.treeViewer.getTree().getItem(0);
        Assert.assertEquals((String)"element contains unexpected data", (Object)firstEle, (Object)firstItem.getData());
        this.treeViewer.setFilters(new ViewerFilter[]{new BaseLimitBasedViewerTest.TestViewerFilter()});
        this.processEvents();
        firstEle = (BaseLimitBasedViewerTest.DataModel)this.rootModel.get(6);
        firstItem = this.treeViewer.getTree().getItem(0);
        Assert.assertEquals((String)"element contains unexpected data", (Object)firstEle, (Object)firstItem.getData());
    }

    @Test
    public void testSetInput() {
        ArrayList<BaseLimitBasedViewerTest.DataModel> rootModel = new ArrayList<BaseLimitBasedViewerTest.DataModel>();
        BaseLimitBasedViewerTest.DataModel rootLevel = new BaseLimitBasedViewerTest.DataModel(100);
        rootModel.add(rootLevel);
        this.treeViewer.setInput(rootModel);
        this.processEvents();
        Assert.assertEquals((String)"there must be only one item", (long)1L, (long)this.treeViewer.getTree().getItems().length);
        this.treeViewer.setInput(TreeViewerWithLimitTest.createModel(40));
        this.processEvents();
        this.assertLimitedItems();
    }

    @Test
    public void testContains() {
        Assert.assertFalse((String)"element must not be available on the viewer", (boolean)this.treeViewer.contains(this.fRootElement, ""));
        Assert.assertTrue((String)"element must be available on the viewer", (boolean)this.treeViewer.contains(this.rootModel, this.rootModel.get(0)));
        Assert.assertTrue((String)"element must be available on the viewer", (boolean)this.treeViewer.contains(this.rootModel, this.rootModel.get(this.rootModel.size() - 1)));
        Assert.assertFalse((String)"element must not be available on the viewer", (boolean)this.treeViewer.contains(this.rootModel, ((BaseLimitBasedViewerTest.DataModel)this.rootModel.get((int)0)).children.get(0)));
        this.treeViewer.expandAll();
        Assert.assertTrue((String)"element must be available on the viewer", (boolean)this.treeViewer.contains(this.rootModel, ((BaseLimitBasedViewerTest.DataModel)this.rootModel.get((int)0)).children.get(0)));
    }

    @Override
    protected StructuredViewer createViewer(Composite parent) {
        this.treeViewer = new TestTreeViewer(parent);
        this.treeViewer.setDisplayIncrementally(4);
        this.treeViewer.setContentProvider((IContentProvider)new TestTreeContentProvider());
        this.treeViewer.setLabelProvider((IBaseLabelProvider)new LabelProvider());
        this.treeViewer.setComparator(new BaseLimitBasedViewerTest.TestComparator());
        return this.treeViewer;
    }

    @Override
    protected void setInput() {
        this.rootModel = TreeViewerWithLimitTest.createModel(40);
        this.treeViewer.setInput(this.rootModel);
    }

    private static class TestTreeContentProvider
    implements ITreeContentProvider {
        private TestTreeContentProvider() {
        }

        public Object[] getElements(Object inputElement) {
            if (inputElement instanceof ArrayList) {
                return ((ArrayList)inputElement).toArray();
            }
            return ((BaseLimitBasedViewerTest.DataModel)inputElement).children.toArray();
        }

        public Object[] getChildren(Object parentElement) {
            if (!(parentElement instanceof BaseLimitBasedViewerTest.DataModel)) {
                return null;
            }
            return this.getElements(parentElement);
        }

        public Object getParent(Object element) {
            if (!(element instanceof BaseLimitBasedViewerTest.DataModel)) {
                return null;
            }
            return ((BaseLimitBasedViewerTest.DataModel)element).parent;
        }

        public boolean hasChildren(Object element) {
            if (element instanceof ArrayList) {
                return !((ArrayList)element).isEmpty();
            }
            BaseLimitBasedViewerTest.DataModel myModel = (BaseLimitBasedViewerTest.DataModel)element;
            return myModel.children.size() > 0;
        }
    }

    class TestTreeViewer
    extends TreeViewer {
        public TestTreeViewer(Composite parent) {
            super(parent);
        }
    }
}

