/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jface.tests.viewers;

import java.util.Vector;
import org.eclipse.core.runtime.Assert;
import org.eclipse.jface.tests.viewers.ComparatorModelChange;
import org.eclipse.jface.tests.viewers.IComparatorModelListener;
import org.eclipse.jface.tests.viewers.ViewerTestCase;
import org.eclipse.jface.viewers.AbstractTreeViewer;
import org.eclipse.jface.viewers.ComboViewer;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.ListViewer;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;

public abstract class ViewerComparatorTest
extends ViewerTestCase {
    protected String UI = "UI";
    protected String[] TEAM1 = new String[]{"Karice", "Tod", "Eric", "Paul", "Mike", "Michael", "Andrea", "Kim", "Boris", "Susan"};
    protected String[] TEAM1_SORTED = new String[]{"Andrea", "Boris", "Eric", "Karice", "Kim", "Michael", "Mike", "Paul", "Susan", "Tod"};
    protected String[] TEAM1_SORTED_WITH_INSERT = new String[]{"Andrea", "Boris", "Duong", "Eric", "Karice", "Kim", "Michael", "Mike", "Paul", "Susan", "Tod"};
    protected String RUNTIME = "Runtime";
    protected String[] TEAM2 = new String[]{"Pascal", "DJ", "Jeff", "Andrew", "Oleg"};
    protected String[] TEAM2_SORTED = new String[]{"Andrew", "DJ", "Jeff", "Oleg", "Pascal"};
    protected String CORE = "Core";
    protected String[] TEAM3 = new String[]{"John", "Michael", "Bogdan"};
    protected String[] TEAM3_SORTED = new String[]{"Bogdan", "John", "Michael"};
    protected Team team1 = new Team(this.UI, this.TEAM1);
    protected Team team2 = new Team(this.RUNTIME, this.TEAM2);
    protected Team team3 = new Team(this.CORE, this.TEAM3);

    protected static class Team {
        Vector<IComparatorModelListener> fListeners = new Vector();
        TeamMember[] members;
        String name;

        public Team(String name, String[] members) {
            this.name = name;
            this.members = new TeamMember[members.length];
            int i = 0;
            while (i < members.length) {
                this.members[i] = new TeamMember(members[i], this);
                ++i;
            }
        }

        public void addMember(String person) {
            TeamMember newMember = new TeamMember(person, this);
            TeamMember[] newMembers = new TeamMember[this.members.length + 1];
            System.arraycopy(this.members, 0, newMembers, 0, this.members.length);
            newMembers[newMembers.length - 1] = newMember;
            this.members = null;
            this.members = newMembers;
            newMembers = null;
            this.fireModelChanged(new ComparatorModelChange(1, this, newMember));
        }

        public void addListener(IComparatorModelListener listener) {
            this.fListeners.addElement(listener);
        }

        public void fireModelChanged(ComparatorModelChange change) {
            for (IComparatorModelListener listener : this.fListeners) {
                listener.modelChanged(change);
            }
        }

        public void removeListener(IComparatorModelListener listener) {
            this.fListeners.removeElement(listener);
        }
    }

    protected static class TeamMember {
        String name;
        Team team;

        public TeamMember(String name, Team team) {
            this.name = name;
            this.team = team;
        }
    }

    protected class TeamModelContentProvider
    implements IComparatorModelListener,
    IStructuredContentProvider {
        protected TeamModelContentProvider() {
        }

        public Object[] getElements(Object inputElement) {
            if (inputElement instanceof Team) {
                Team team = (Team)inputElement;
                return team.members;
            }
            return new Object[0];
        }

        public void dispose() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
            if (oldInput != null) {
                ((Team)oldInput).removeListener(this);
            }
            if (newInput != null) {
                ((Team)newInput).addListener(this);
            }
        }

        @Override
        public void modelChanged(ComparatorModelChange change) {
            Object element;
            switch (change.getKind()) {
                case 1: {
                    this.doInsert(change);
                    break;
                }
                case 2: {
                    this.doRemove(change);
                    break;
                }
                case 3: {
                    this.doStructureChange(change);
                    break;
                }
                case 4: {
                    this.doNonStructureChange(change);
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Unknown kind of change");
                }
            }
            StructuredSelection selection = new StructuredSelection((Object[])change.getChildren());
            if ((change.getModifiers() & 0x20) != 0) {
                ViewerComparatorTest.this.fViewer.setSelection((ISelection)selection);
            }
            if ((change.getModifiers() & 0x10) != 0 && (element = selection.getFirstElement()) != null) {
                ViewerComparatorTest.this.fViewer.reveal(element);
            }
        }

        protected void doInsert(ComparatorModelChange change) {
            StructuredViewer structuredViewer = ViewerComparatorTest.this.fViewer;
            if (structuredViewer instanceof ListViewer) {
                ListViewer viewer = (ListViewer)structuredViewer;
                if (change.getParent() != null && change.getParent().equals(ViewerComparatorTest.this.fViewer.getInput())) {
                    viewer.add((Object[])change.getChildren());
                }
            } else {
                StructuredViewer structuredViewer2 = ViewerComparatorTest.this.fViewer;
                if (structuredViewer2 instanceof TableViewer) {
                    TableViewer viewer = (TableViewer)structuredViewer2;
                    if (change.getParent() != null && change.getParent().equals(ViewerComparatorTest.this.fViewer.getInput())) {
                        viewer.add((Object[])change.getChildren());
                    }
                } else {
                    StructuredViewer structuredViewer3 = ViewerComparatorTest.this.fViewer;
                    if (structuredViewer3 instanceof AbstractTreeViewer) {
                        AbstractTreeViewer viewer = (AbstractTreeViewer)structuredViewer3;
                        viewer.add((Object)change.getParent(), (Object[])change.getChildren());
                    } else {
                        StructuredViewer structuredViewer4 = ViewerComparatorTest.this.fViewer;
                        if (structuredViewer4 instanceof ComboViewer) {
                            ComboViewer viewer = (ComboViewer)structuredViewer4;
                            viewer.add((Object[])change.getChildren());
                        } else {
                            Assert.isTrue((boolean)false, (String)"Unknown kind of viewer");
                        }
                    }
                }
            }
        }

        protected void doNonStructureChange(ComparatorModelChange change) {
            ViewerComparatorTest.this.fViewer.update((Object)change.getParent(), new String[]{"org.eclipse.jface.text"});
        }

        protected void doRemove(ComparatorModelChange change) {
            StructuredViewer structuredViewer = ViewerComparatorTest.this.fViewer;
            if (structuredViewer instanceof ListViewer) {
                ListViewer viewer = (ListViewer)structuredViewer;
                viewer.remove((Object[])change.getChildren());
            } else {
                StructuredViewer structuredViewer2 = ViewerComparatorTest.this.fViewer;
                if (structuredViewer2 instanceof TableViewer) {
                    TableViewer viewer = (TableViewer)structuredViewer2;
                    viewer.remove((Object[])change.getChildren());
                } else {
                    StructuredViewer structuredViewer3 = ViewerComparatorTest.this.fViewer;
                    if (structuredViewer3 instanceof AbstractTreeViewer) {
                        AbstractTreeViewer viewer = (AbstractTreeViewer)structuredViewer3;
                        viewer.remove((Object[])change.getChildren());
                    } else {
                        StructuredViewer structuredViewer4 = ViewerComparatorTest.this.fViewer;
                        if (structuredViewer4 instanceof ComboViewer) {
                            ComboViewer viewer = (ComboViewer)structuredViewer4;
                            viewer.remove((Object[])change.getChildren());
                        } else {
                            Assert.isTrue((boolean)false, (String)"Unknown kind of viewer");
                        }
                    }
                }
            }
        }

        protected void doStructureChange(ComparatorModelChange change) {
            ViewerComparatorTest.this.fViewer.refresh((Object)change.getParent());
        }
    }

    protected static class TeamModelLabelProvider
    extends LabelProvider {
        protected TeamModelLabelProvider() {
        }

        public String getText(Object element) {
            if (element instanceof Team) {
                Team team = (Team)element;
                return team.name;
            }
            if (element instanceof TeamMember) {
                TeamMember member = (TeamMember)element;
                return member.name;
            }
            return element.toString();
        }
    }
}

