/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jface.tests.viewers;

import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.tests.viewers.TestElement;
import org.eclipse.jface.tests.viewers.TestModel;
import org.eclipse.jface.util.ILogger;
import org.eclipse.jface.util.ISafeRunnableRunner;
import org.eclipse.jface.util.Policy;
import org.eclipse.jface.util.SafeRunnable;
import org.eclipse.jface.util.Util;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;

public abstract class ViewerTestCase {
    Display fDisplay;
    protected Shell fShell;
    protected StructuredViewer fViewer;
    protected TestElement fRootElement;
    public TestModel fModel;
    protected boolean disableTestsBug347491 = false;
    protected boolean eventLoopAdjustmentBug531048 = false;
    private ILogger oldLogger;
    private ISafeRunnableRunner oldRunner;

    @Before
    public void initializeOsDependentStates() {
        this.disableTestsBug347491 = Util.isCocoa();
        this.eventLoopAdjustmentBug531048 = Util.isGtk();
    }

    protected void assertSelectionEquals(String message, TestElement expected) {
        IStructuredSelection structuredSelection = this.fViewer.getStructuredSelection();
        StructuredSelection expectedSelection = new StructuredSelection((Object)expected);
        Assert.assertEquals((String)("selectionEquals - " + message), (Object)structuredSelection, (Object)expectedSelection);
    }

    protected abstract StructuredViewer createViewer(Composite var1);

    public void interact() {
        Display display;
        Shell shell = this.fShell;
        if (shell != null && !shell.isDisposed() && (display = shell.getDisplay()) != null) {
            while (shell.isVisible()) {
                display.readAndDispatch();
            }
        }
    }

    protected void openBrowser() {
        this.fDisplay = Display.getCurrent();
        if (this.fDisplay == null) {
            this.fDisplay = new Display();
        }
        this.fShell = new Shell(this.fDisplay, this.getShellStyle());
        this.fShell.setSize(500, 500);
        this.fShell.setLayout((Layout)new FillLayout());
        this.fViewer = this.createViewer((Composite)this.fShell);
        this.fViewer.setUseHashlookup(true);
        this.setInput();
        this.fShell.open();
    }

    protected int getShellStyle() {
        return 1264;
    }

    protected void setInput() {
        this.fViewer.setInput((Object)this.fRootElement);
    }

    public void processEvents() {
        Display display;
        Shell shell = this.fShell;
        if (shell != null && !shell.isDisposed() && (display = shell.getDisplay()) != null) {
            while (display.readAndDispatch()) {
            }
        }
    }

    @Before
    public void setUp() {
        this.oldLogger = Policy.getLog();
        this.oldRunner = SafeRunnable.getRunner();
        Policy.setLog(status -> Assert.fail((String)status.getMessage()));
        SafeRunnable.setRunner(code -> {
            try {
                code.run();
            }
            catch (Throwable th) {
                throw new RuntimeException(th);
            }
        });
        this.setUpModel();
        this.openBrowser();
    }

    protected void setUpModel() {
        this.fRootElement = TestElement.createModel(3, 10);
        this.fModel = this.fRootElement.getModel();
    }

    protected static void sleep(long millis) {
        try {
            Thread.sleep(millis);
        }
        catch (InterruptedException e) {
            return;
        }
    }

    @After
    public void tearDown() {
        Policy.setLog((ILogger)this.oldLogger);
        SafeRunnable.setRunner((ISafeRunnableRunner)this.oldRunner);
        this.processEvents();
        this.fViewer = null;
        if (this.fShell != null) {
            this.fShell.dispose();
            this.fShell = null;
        }
        this.fRootElement = null;
        this.fModel = null;
    }

    public void waitForJobs(long minTimeMs, long maxTimeMs) {
        if (maxTimeMs < minTimeMs) {
            throw new IllegalArgumentException("Max time is smaller as min time!");
        }
        long start = System.currentTimeMillis();
        while (System.currentTimeMillis() - start < minTimeMs) {
            this.processEvents();
            ViewerTestCase.sleep(10L);
        }
        while (!Job.getJobManager().isIdle() && System.currentTimeMillis() - start < maxTimeMs) {
            this.processEvents();
            ViewerTestCase.sleep(10L);
        }
    }
}

