/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jface.tests.viewers;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.jface.tests.viewers.TestElement;
import org.eclipse.jface.tests.viewers.TestLazyModelContentProvider;
import org.eclipse.jface.tests.viewers.TestModelContentProvider;
import org.eclipse.jface.tests.viewers.VirtualTableViewerTest;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.swt.widgets.Table;
import org.junit.After;
import org.junit.Assert;
import org.junit.Ignore;
import org.junit.Test;

public class VirtualLazyTableViewerTest
extends VirtualTableViewerTest {
    private List<Integer> updatedElements;
    int updatedElementFailureTriggerIndex = -1;

    @Override
    protected TestModelContentProvider getContentProvider() {
        return new TestLazyModelContentProvider(this);
    }

    @Override
    public void setUp() {
        this.updatedElements = new ArrayList<Integer>();
        super.setUp();
    }

    @Override
    protected void setUpModel() {
        this.fRootElement = TestElement.createModel(2, 100);
        this.fModel = this.fRootElement.getModel();
    }

    @Override
    @After
    public void tearDown() {
        super.tearDown();
        this.updatedElements = null;
    }

    public void updateElementCalled(int index) {
        this.updatedElements.add(index);
        if (this.updatedElementFailureTriggerIndex != -1 && this.updatedElements.size() >= this.updatedElementFailureTriggerIndex) {
            Assert.fail((String)("unexpected call to updateElement, this is the " + this.updatedElements.size() + "th call"));
        }
    }

    @Test
    public void testSetIndexedSelection() {
        TestElement[] children = this.fRootElement.getChildren();
        int selectionSize = children.length / 2;
        int[] indices = new int[selectionSize];
        int i = 0;
        while (i < indices.length) {
            indices[i] = i * 2;
            ++i;
        }
        Table table = ((TableViewer)this.fViewer).getTable();
        table.setSelection(indices);
        indices = table.getSelectionIndices();
        selectionSize = indices.length;
        Assert.assertTrue((String)"Expected at least one selected element", (selectionSize > 0 ? 1 : 0) != 0);
        table.showSelection();
        IStructuredSelection result = this.fViewer.getStructuredSelection();
        Assert.assertEquals((long)selectionSize, (long)result.size());
        Assert.assertEquals((String)"First elements do not match ", (Object)result.getFirstElement(), (Object)children[indices[0]]);
        int lastIndex = indices[indices.length - 1];
        Assert.assertEquals((String)"Last elements do not match ", (Object)result.toArray()[result.size() - 1], (Object)children[lastIndex]);
    }

    @Test
    public void testSetInputDoesNotMaterializeEverything() {
        this.fViewer.setInput(null);
        this.updatedElements.clear();
        this.updatedElementFailureTriggerIndex = this.fRootElement.getChildCount();
        this.fViewer.setInput((Object)this.fRootElement);
        int materializedSize = this.updatedElements.size();
        Assert.assertTrue((String)("Expected less than " + this.fRootElement.getChildCount() + ", actual " + materializedSize), (materializedSize < this.fRootElement.getChildCount() ? 1 : 0) != 0);
        this.setUpModel();
        this.updatedElements.clear();
        this.fViewer.setInput((Object)this.fRootElement);
        Assert.assertEquals((long)materializedSize, (long)this.updatedElements.size());
    }

    @Test
    public void testBug160153() {
        int childCount = this.fRootElement.getChildCount();
        TestElement lastChild = this.fRootElement.getChildAt(childCount - 1);
        this.fViewer.setSelection((ISelection)new StructuredSelection((Object)lastChild));
        this.processEvents();
        Assert.assertNotNull((String)"last Child should be in the map", (Object)this.fViewer.testFindItem((Object)lastChild));
        ((TableViewer)this.fViewer).setItemCount(childCount - 1);
        Assert.assertNull((String)"last Child should no longer be in the map", (Object)this.fViewer.testFindItem((Object)lastChild));
    }

    @Override
    @Ignore(value="This test is no use here as it is based on the assumption that all items are created.")
    public void testSorter() {
    }

    @Override
    @Ignore(value="This test is no use here as it is based on the assumption that all items are created.")
    public void testRenameWithSorter() {
    }

    @Override
    @Ignore(value="This test is no use here as it is based on the assumption that all items are created.")
    public void testSetFilters() {
    }

    @Override
    @Ignore(value="This test is no use here as it is based on the assumption that all items are created.")
    public void testFilter() {
    }

    @Override
    @Ignore(value="This test is no use here as it is based on the assumption that all items are created.")
    public void testRenameWithFilter() {
    }

    @Override
    @Ignore(value="This test is no use here as it is based on the assumption that all items are created.")
    public void testContains() {
    }
}

