/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jface.tests.viewers;

import org.eclipse.jface.tests.viewers.TestElement;
import org.eclipse.jface.tests.viewers.TestModelLazyTreeContentProvider;
import org.eclipse.jface.tests.viewers.TreeViewerTest;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Tree;
import org.junit.Assert;
import org.junit.Assume;
import org.junit.Ignore;
import org.junit.Test;

public class VirtualLazyTreeViewerTest
extends TreeViewerTest {
    protected volatile int setDataCalls = 0;

    @Override
    protected StructuredViewer createViewer(Composite parent) {
        Tree tree = new Tree(parent, 0x10000000);
        tree.addListener(36, event -> {
            int n = this.setDataCalls;
            int n2 = n;
            this.setDataCalls = n + 1;
        });
        this.fTreeViewer = new TreeViewer(tree);
        this.fTreeViewer.setContentProvider((IContentProvider)new TestModelLazyTreeContentProvider((TreeViewer)this.fTreeViewer));
        return this.fTreeViewer;
    }

    @Override
    public void setUp() {
        super.setUp();
        this.fShell.forceActive();
        this.processEvents();
    }

    @Override
    protected void setInput() {
        super.setInput();
    }

    @Test
    public void testLeafIsExpandable() {
        TestElement leafElement = this.fRootElement.getChildAt(2).getChildAt(3).getChildAt(2);
        Assert.assertEquals((long)0L, (long)leafElement.getChildCount());
        Assert.assertFalse((boolean)this.fTreeViewer.isExpandable((Object)leafElement));
    }

    @Test
    public void testRootIsExpandable() {
        TestElement rootElement = this.fRootElement.getChildAt(2);
        Assert.assertTrue((rootElement.getChildCount() > 0 ? 1 : 0) != 0);
        Assert.assertTrue((boolean)this.fTreeViewer.isExpandable((Object)rootElement));
    }

    @Test
    public void testNodeIsExpandable() {
        TestElement nodeElement = this.fRootElement.getChildAt(2).getChildAt(3);
        Assert.assertTrue((nodeElement.getChildCount() > 0 ? 1 : 0) != 0);
        Assert.assertTrue((boolean)this.fTreeViewer.isExpandable((Object)nodeElement));
    }

    @Override
    @Ignore(value="Test leads to infinite loop. Duplicate children are a bad idea in virtual trees.")
    public void testRefreshWithDuplicateChild() {
    }

    @Override
    @Ignore(value="Test leads to infinite loop. Cycles are a bad idea in virtual trees.")
    public void testSetExpandedWithCycle() {
    }

    @Override
    @Ignore(value="no need to test since virtual trees do not support filtering")
    public void testFilterExpanded() {
    }

    @Override
    @Ignore(value="no need to test since virtual trees do not support filtering")
    public void testFilter() {
    }

    @Override
    @Ignore(value="no need to test since virtual trees do not support filtering")
    public void testSetFilters() {
    }

    @Override
    @Ignore(value="no need to test since virtual trees do not support filtering")
    public void testInsertSiblingWithFilterFiltered() {
    }

    @Override
    @Ignore(value="no need to test since virtual trees do not support filtering")
    public void testInsertSiblingWithFilterNotFiltered() {
    }

    @Override
    @Ignore(value="no need to test since virtual trees do not support sorting")
    public void testInsertSiblingWithSorter() {
    }

    @Override
    @Ignore(value="no need to test since virtual trees do not support filtering")
    public void testRenameWithFilter() {
    }

    @Override
    @Ignore(value="no need to test since virtual trees do not support sorting")
    public void testRenameWithSorter() {
    }

    @Override
    @Ignore(value="no need to test since virtual trees do not support sorting")
    public void testSorter() {
    }

    @Override
    @Ignore(value="test is not relevant for lazy tree viewer")
    public void testChildIsNotDuplicatedWhenCompareEquals() {
    }

    @Override
    @Test
    public void testRefreshWithAddedChildren() {
        Assume.assumeFalse((String)"test disabled because of bug 347491", (boolean)this.disableTestsBug347491);
        Assert.assertTrue((String)"data must have been set", (this.setDataCalls > 0 ? 1 : 0) != 0);
        super.testRefreshWithAddedChildren();
    }

    @Override
    @Test
    public void testDeleteSibling() {
        Assume.assumeFalse((String)"test disabled because of bug 347491", (boolean)this.disableTestsBug347491);
        Assert.assertTrue((String)"data must have been set", (this.setDataCalls > 0 ? 1 : 0) != 0);
        super.testDeleteSibling();
    }

    @Override
    @Test
    public void testInsertSibling() {
        Assume.assumeFalse((String)"test disabled because of bug 347491", (boolean)this.disableTestsBug347491);
        Assert.assertTrue((String)"data must have been set", (this.setDataCalls > 0 ? 1 : 0) != 0);
        super.testInsertSibling();
    }

    @Override
    @Test
    public void testInsertSiblings() {
        Assume.assumeFalse((String)"test disabled because of bug 347491", (boolean)this.disableTestsBug347491);
        Assert.assertTrue((String)"data must have been set", (this.setDataCalls > 0 ? 1 : 0) != 0);
        super.testInsertSiblings();
    }

    @Override
    @Test
    public void testSetInput() {
        Assume.assumeFalse((String)"test disabled because of bug 347491", (boolean)this.disableTestsBug347491);
        Assert.assertTrue((String)"data must have been set", (this.setDataCalls > 0 ? 1 : 0) != 0);
        super.testSetInput();
    }

    @Override
    @Test
    public void testSomeChildrenChanged() {
        Assume.assumeFalse((String)"test disabled because of bug 347491", (boolean)this.disableTestsBug347491);
        Assert.assertTrue((String)"data must have been set", (this.setDataCalls > 0 ? 1 : 0) != 0);
        super.testSomeChildrenChanged();
    }

    @Override
    @Test
    public void testWorldChanged() {
        Assume.assumeFalse((String)"test disabled because of bug 347491", (boolean)this.disableTestsBug347491);
        Assert.assertTrue((String)"data must have been set", (this.setDataCalls > 0 ? 1 : 0) != 0);
        super.testWorldChanged();
    }

    @Override
    @Test
    public void testContains() {
        Assume.assumeFalse((String)"test disabled because of bug 347491", (boolean)this.disableTestsBug347491);
        Assert.assertTrue((String)"data must have been set", (this.setDataCalls > 0 ? 1 : 0) != 0);
        super.testContains();
    }

    @Override
    @Test
    public void testAutoExpandOnSingleChildThroughEvent() {
        Assume.assumeFalse((String)"test disabled because of bug 347491", (boolean)this.disableTestsBug347491);
        Assert.assertTrue((String)"data must have been set", (this.setDataCalls > 0 ? 1 : 0) != 0);
        super.testAutoExpandOnSingleChildThroughEvent();
    }
}

