/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jface.tests.viewers;

import java.time.Duration;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.jface.tests.viewers.StructuredViewerTest;
import org.eclipse.jface.tests.viewers.TableViewerTest;
import org.eclipse.jface.tests.viewers.TestElement;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableItem;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Ignore;
import org.junit.Test;

public class VirtualTableViewerTest
extends TableViewerTest {
    private static final Duration TABLE_DATA_UPDATE_TIMEOUT = Duration.ofSeconds(5L);
    private Set<TableItem> visibleItems = new HashSet<TableItem>();
    protected volatile boolean setDataCalled = false;

    @Override
    @Before
    public void setUp() {
        super.setUp();
        this.waitForDataToBeSet();
    }

    @Override
    protected int getShellStyle() {
        return super.getShellStyle() | 0x4000;
    }

    @Override
    protected TableViewer createTableViewer(Composite parent) {
        TableViewer viewer = new TableViewer(parent, 0x10000002);
        viewer.setUseHashlookup(true);
        Table table = viewer.getTable();
        table.addListener(36, event -> {
            this.setDataCalled = true;
            TableItem item = (TableItem)event.item;
            this.visibleItems.add(item);
        });
        return viewer;
    }

    private void updateTable() {
        this.setDataCalled = false;
        this.fViewer.refresh();
        this.fViewer.getControl().update();
        this.waitForDataToBeSet();
    }

    private void waitForDataToBeSet() {
        Duration timeoutEnd = Duration.ofMillis(System.currentTimeMillis()).plus(TABLE_DATA_UPDATE_TIMEOUT);
        while (!this.setDataCalled && !timeoutEnd.minusMillis(System.currentTimeMillis()).isNegative()) {
            this.fShell.forceActive();
            this.processEvents();
        }
        Assert.assertTrue((String)"waiting for setting table data timed out", (boolean)this.setDataCalled);
    }

    private TableItem[] getVisibleItems() {
        return this.visibleItems.toArray(new TableItem[this.visibleItems.size()]);
    }

    @Test
    public void testElementsCreated() {
        TableItem[] items = this.getVisibleItems();
        int i = 0;
        while (i < items.length) {
            TableItem item = items[i];
            Assert.assertTrue((String)("Missing data in item " + i + " of " + items.length), (boolean)(item.getData() instanceof TestElement));
            ++i;
        }
    }

    @Override
    protected int getItemCount() {
        return this.getVisibleItems().length;
    }

    @Override
    @Test
    public void testFilter() {
        StructuredViewerTest.TestLabelFilter filter = new StructuredViewerTest.TestLabelFilter();
        this.visibleItems = new HashSet<TableItem>();
        this.fViewer.addFilter((ViewerFilter)filter);
        this.updateTable();
        Assert.assertEquals((String)"filtered count", (long)5L, (long)this.getItemCount());
        this.visibleItems = new HashSet<TableItem>();
        this.fViewer.removeFilter((ViewerFilter)filter);
        this.updateTable();
        Assert.assertEquals((String)"unfiltered count", (long)10L, (long)this.getItemCount());
    }

    @Override
    @Test
    public void testSetFilters() {
        StructuredViewerTest.TestLabelFilter filter = new StructuredViewerTest.TestLabelFilter();
        this.visibleItems = new HashSet<TableItem>();
        this.fViewer.setFilters(new ViewerFilter[]{filter, new StructuredViewerTest.TestLabelFilter2()});
        this.updateTable();
        Assert.assertEquals((String)"2 filters count", (long)1L, (long)this.getItemCount());
        this.visibleItems = new HashSet<TableItem>();
        this.fViewer.setFilters(new ViewerFilter[]{filter});
        this.updateTable();
        Assert.assertEquals((String)"1 filtered count", (long)5L, (long)this.getItemCount());
        this.visibleItems = new HashSet<TableItem>();
        this.fViewer.setFilters(new ViewerFilter[0]);
        this.updateTable();
        Assert.assertEquals((String)"unfiltered count", (long)10L, (long)this.getItemCount());
    }

    @Override
    @Ignore(value="This test is no use here as it is based on the assumption that all items are created.")
    public void testInsertSibling() {
    }

    @Override
    @Ignore(value="This test is no use here as it is based on the assumption that all items are created.")
    public void testInsertSiblingReveal() {
    }

    @Override
    @Ignore(value="This test is no use here as it is based on the assumption that all items are created.")
    public void testInsertSiblings() {
    }

    @Override
    @Ignore(value="This test is no use here as it is based on the assumption that all items are created.")
    public void testInsertSiblingWithFilterFiltered() {
    }

    @Override
    @Ignore(value="This test is no use here as it is based on the assumption that all items are created.")
    public void testInsertSiblingWithFilterNotFiltered() {
    }

    @Override
    @Ignore(value="This test is no use here as it is based on the assumption that all items are created.")
    public void testInsertSiblingWithSorter() {
    }

    @Override
    @Test
    public void testRenameWithFilter() {
        this.fViewer.addFilter((ViewerFilter)new StructuredViewerTest.TestLabelFilter());
        TestElement first = this.fRootElement.getFirstChild();
        first.setLabel("name-1111");
        this.updateTable();
        Assert.assertNull((String)"changed sibling is still visible", (Object)this.fViewer.testFindItem((Object)first));
        first.setLabel("name-2222");
        this.updateTable();
        Assert.assertNotNull((String)"changed sibling is not visible", (Object)this.fViewer.testFindItem((Object)first));
    }

    @Override
    @Ignore(value="This test us based on findItem assuming all items are created so it is not valid.")
    public void testSetInput() {
    }

    @Override
    @Test
    public void testRenameWithSorter() {
        this.fViewer.setComparator((ViewerComparator)new StructuredViewerTest.TestLabelComparator());
        TestElement first = this.fRootElement.getFirstChild();
        first.setLabel("name-9999");
        String newElementLabel = first.toString();
        Assert.assertEquals((String)"sorted first", (Object)newElementLabel, (Object)this.getItemText(0));
    }

    @Override
    public void testSorter() {
        TestElement first = this.fRootElement.getFirstChild();
        TestElement last = this.fRootElement.getLastChild();
        String firstLabel = first.toString();
        String lastLabel = last.toString();
        Assert.assertEquals((String)"unsorted", (Object)firstLabel, (Object)this.getItemText(0));
        this.fViewer.setComparator((ViewerComparator)new StructuredViewerTest.TestLabelComparator());
        Assert.assertEquals((String)"reverse sorted", (Object)lastLabel, (Object)this.getItemText(0));
        this.fViewer.setComparator(null);
        Assert.assertEquals((String)"unsorted", (Object)firstLabel, (Object)this.getItemText(0));
    }

    @Override
    @Ignore(value="This test is no use here as it is based on the assumption that all items are created.")
    public void testInsertSiblingSelectExpanded() {
    }

    @Override
    @Ignore(value="This test is no use here as it is based on the assumption that all items are created.")
    public void testSomeChildrenChanged() {
    }

    @Override
    @Ignore(value="This test is no use here as it is based on the assumption that all items are created.")
    public void testWorldChanged() {
    }

    @Override
    @Test
    public void testDeleteSibling() {
        ((TableViewer)this.fViewer).getTable().getItem(0).getText();
        super.testDeleteSibling();
    }

    @Override
    @Test
    public void testSetSelection() {
        ((TableViewer)this.fViewer).getTable().getItem(0).getText();
        super.testSetSelection();
    }

    @Test
    public void testSetAllSelection() {
        Object[] children = this.fRootElement.getChildren();
        StructuredSelection selection = new StructuredSelection(children);
        this.fViewer.setSelection((ISelection)selection);
        IStructuredSelection result = this.fViewer.getStructuredSelection();
        Assert.assertEquals((String)("Size was " + result.size() + " expected " + children.length), (long)result.size(), (long)children.length);
        HashSet<Object> childrenSet = new HashSet<Object>(Arrays.asList(children));
        HashSet selectedSet = new HashSet(result.toList());
        Assert.assertTrue((String)"Elements do not match ", (boolean)childrenSet.equals(selectedSet));
    }
}

