/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jface.tests.viewers.interactive;

import java.lang.invoke.CallSite;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Random;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.tests.viewers.TestComparator;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.deferred.DeferredContentProvider;
import org.eclipse.jface.viewers.deferred.SetModel;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.part.ViewPart;
import org.eclipse.ui.progress.WorkbenchJob;

public class ConcurrentTableTestView
extends ViewPart {
    private TableViewer table;
    private boolean enableSlowComparisons = false;
    private final TestComparator comparator = new TestComparator(){

        @Override
        public int compare(Object arg0, Object arg1) {
            if (ConcurrentTableTestView.this.enableSlowComparisons) {
                int delay = 2;
                long timestamp = System.currentTimeMillis();
                while (System.currentTimeMillis() < timestamp + (long)delay) {
                }
            }
            int result = super.compare(arg0, arg1);
            ConcurrentTableTestView.this.scheduleComparisonUpdate();
            return result;
        }
    };
    private DeferredContentProvider contentProvider;
    private final WorkbenchJob updateCountRunnable = new WorkbenchJob(""){

        public IStatus runInUIThread(IProgressMonitor monitor) {
            ConcurrentTableTestView.this.updateCount.setText("Comparison count = " + ConcurrentTableTestView.this.comparator.comparisons);
            return Status.OK_STATUS;
        }
    };
    private Label updateCount;
    private final SetModel model = new SetModel();
    private final Random rand = new Random();
    private Button slowComparisons;

    public void createPartControl(Composite temp) {
        Composite parent = new Composite(temp, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        parent.setLayout((Layout)layout);
        this.table = new TableViewer(parent, 0x10000000);
        this.contentProvider = new DeferredContentProvider((Comparator)this.comparator);
        this.table.setContentProvider((IContentProvider)this.contentProvider);
        GridData data = new GridData(1808);
        this.table.getControl().setLayoutData((Object)data);
        this.table.setInput((Object)this.model);
        Composite buttonBar = new Composite(parent, 0);
        buttonBar.setLayoutData((Object)new GridData(1808));
        GridLayout buttonBarLayout = new GridLayout();
        buttonBarLayout.numColumns = 1;
        buttonBar.setLayout((Layout)buttonBarLayout);
        this.updateCount = new Label(buttonBar, 0);
        this.updateCount.setLayoutData((Object)new GridData(1808));
        this.slowComparisons = new Button(buttonBar, 32);
        this.slowComparisons.setLayoutData((Object)new GridData(1808));
        this.slowComparisons.setText("Slow comparisons");
        this.slowComparisons.setSelection(this.enableSlowComparisons);
        this.slowComparisons.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ConcurrentTableTestView.this.enableSlowComparisons = ConcurrentTableTestView.this.slowComparisons.getSelection();
                super.widgetSelected(e);
            }
        });
        final Button limitSize = new Button(buttonBar, 32);
        limitSize.setLayoutData((Object)new GridData(1808));
        limitSize.setText("Limit table size to 400");
        limitSize.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (limitSize.getSelection()) {
                    ConcurrentTableTestView.this.contentProvider.setLimit(400);
                } else {
                    ConcurrentTableTestView.this.contentProvider.setLimit(-1);
                }
                super.widgetSelected(e);
            }
        });
        Button resetCountButton = new Button(buttonBar, 8);
        resetCountButton.setLayoutData((Object)new GridData(1808));
        resetCountButton.setText("Reset comparison count");
        resetCountButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ConcurrentTableTestView.this.comparator.comparisons = 0;
                ConcurrentTableTestView.this.scheduleComparisonUpdate();
            }
        });
        Button testButton = new Button(buttonBar, 8);
        testButton.setLayoutData((Object)new GridData(1808));
        testButton.setText("add 100000 elements");
        testButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ConcurrentTableTestView.this.addRandomElements(100000);
            }
        });
        Button removeButton = new Button(buttonBar, 8);
        removeButton.setLayoutData((Object)new GridData(1808));
        removeButton.setText("remove all");
        removeButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ConcurrentTableTestView.this.clear();
            }
        });
    }

    protected void scheduleComparisonUpdate() {
        this.updateCountRunnable.schedule(100L);
    }

    public void addRandomElements(int amount) {
        ArrayList<CallSite> tempList = new ArrayList<CallSite>();
        int counter = 0;
        while (counter < amount) {
            tempList.add((CallSite)((Object)(this.rand.nextLong() + " " + counter)));
            ++counter;
        }
        this.model.addAll(tempList);
    }

    public void clear() {
        this.model.clear();
    }

    public void setFocus() {
    }
}

