/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jface.tests.viewers.interactive;

import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.jface.tests.viewers.interactive.VirtualTableView;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILazyContentProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.ui.progress.UIJob;

public class LazyDeferredVirtualTableView
extends VirtualTableView {
    @Override
    protected IContentProvider getContentProvider() {
        return new ILazyContentProvider(){
            int rangeStart = -1;
            int rangeEnd = -1;
            UIJob updateJob = UIJob.create((String)"Update", m -> {
                if (LazyDeferredVirtualTableView.this.viewer.getControl().isDisposed()) {
                    throw new OperationCanceledException();
                }
                int rangeLength = this.rangeEnd - this.rangeStart;
                int i = 0;
                while (i <= rangeLength) {
                    int index = i + this.rangeStart;
                    LazyDeferredVirtualTableView.this.viewer.replace((Object)("Element " + index), index);
                    ++i;
                }
            });

            public void updateElement(int index) {
                int begin = Math.max(0, index - 50);
                int end = Math.min(begin + 50, 9999);
                if (this.rangeStart == -1 || this.rangeEnd == -1) {
                    this.rangeStart = begin;
                    this.rangeEnd = end;
                    this.updateJob.schedule(1000L);
                    return;
                }
                if (index >= this.rangeStart && index <= this.rangeEnd) {
                    return;
                }
                if (begin > this.rangeEnd || end < this.rangeStart) {
                    LazyDeferredVirtualTableView.this.viewer.getTable().clear(this.rangeStart, this.rangeEnd);
                    this.rangeStart = begin;
                    this.rangeEnd = end;
                    this.updateJob.schedule(1000L);
                    return;
                }
                if (begin < this.rangeStart) {
                    this.rangeStart = begin;
                    int oldEnd = this.rangeEnd;
                    this.rangeEnd = end;
                    LazyDeferredVirtualTableView.this.viewer.getTable().clear(end + 1, oldEnd);
                    this.updateJob.schedule(1000L);
                    return;
                }
                if (end > this.rangeEnd) {
                    this.rangeEnd = end;
                    int oldStart = this.rangeStart;
                    this.rangeStart = begin;
                    LazyDeferredVirtualTableView.this.viewer.getTable().clear(oldStart, this.rangeStart - 1);
                    this.updateJob.schedule(1000L);
                    return;
                }
            }

            public void dispose() {
            }

            public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
            }
        };
    }

    @Override
    protected void resetInput() {
        this.viewer.setItemCount(this.itemCount);
        super.resetInput();
    }
}

