/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jface.tests.viewers.interactive;

import java.text.DecimalFormat;
import java.text.MessageFormat;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.StyledCellLabelProvider;
import org.eclipse.jface.viewers.StyledString;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerCell;
import org.eclipse.swt.custom.StyleRange;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.graphics.TextStyle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;

public class StyledCellLabelProviderTests {
    private static int IMAGE_SIZE = 16;
    private static Image IMAGE1;
    private static Image IMAGE2;
    protected boolean useBold;
    protected boolean useItalicViaFontStyleAttribute;
    protected TableViewerColumn column;
    boolean timerOn = false;
    long startTime;
    int numOperations;
    DecimalFormat decimalFormat = new DecimalFormat("##.#");

    public static void main(String[] args) {
        Display display = new Display();
        JFaceResources.getColorRegistry().put("COUNTER_COLOR", new RGB(0, 127, 174));
        IMAGE1 = new Image((Device)display, display.getSystemImage(8).getImageData().scaledTo(IMAGE_SIZE, IMAGE_SIZE));
        IMAGE2 = new Image((Device)display, display.getSystemImage(1).getImageData().scaledTo(IMAGE_SIZE, IMAGE_SIZE));
        Shell shell = new Shell(display, 80);
        shell.setSize(400, 600);
        shell.setLayout((Layout)new GridLayout(1, false));
        StyledCellLabelProviderTests example = new StyledCellLabelProviderTests();
        Composite composite = example.createPartControl((Composite)shell);
        composite.setLayoutData((Object)new GridData(4, 4, true, true, 1, 1));
        shell.open();
        while (!shell.isDisposed()) {
            if (display.readAndDispatch()) continue;
            display.sleep();
        }
        display.dispose();
    }

    public Composite createPartControl(Composite parent) {
        Composite composite = new Composite(parent, 0);
        composite.setLayout((Layout)new GridLayout(1, true));
        final Label label = new Label(composite, 0);
        label.setLayoutData((Object)new GridData(1, 0x1000000, false, false));
        label.setText("Operations per second: xxxxx");
        final Runnable[] operation = new Runnable[1];
        final Button timeButton = new Button(composite, 32);
        timeButton.setText("Time");
        timeButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                StyledCellLabelProviderTests.this.setTimer(timeButton.getDisplay(), timeButton.getSelection(), operation, label);
            }
        });
        final Button stylingButton = new Button(composite, 32);
        stylingButton.setText("enable styling");
        stylingButton.setSelection(true);
        final Button boldButton = new Button(composite, 32);
        boldButton.setText("use bold (using TextStyle.font)");
        final Button italicViaFontStyleButton = new Button(composite, 32);
        italicViaFontStyleButton.setText("use bold + italic (using StyleRange.fontStyle)");
        final Button leftButton = new Button(composite, 16);
        leftButton.setText("align left");
        leftButton.setSelection(true);
        final Button centerButton = new Button(composite, 16);
        centerButton.setText("align center");
        Button rightButton = new Button(composite, 16);
        rightButton.setText("align right");
        final TableViewer tableViewer = new TableViewer(composite, 770);
        tableViewer.getTable().setHeaderVisible(true);
        FontData[] boldFontData = StyledCellLabelProviderTests.getModifiedFontData(tableViewer.getTable().getFont().getFontData(), 1);
        Font boldFont = new Font((Device)Display.getCurrent(), boldFontData);
        final ExampleLabelProvider labelProvider = new ExampleLabelProvider(boldFont);
        this.createColumn(tableViewer, 16384, (CellLabelProvider)labelProvider);
        boldButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                StyledCellLabelProviderTests.this.useBold = boldButton.getSelection();
                tableViewer.refresh();
            }
        });
        italicViaFontStyleButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                StyledCellLabelProviderTests.this.useItalicViaFontStyleAttribute = italicViaFontStyleButton.getSelection();
                tableViewer.refresh();
            }
        });
        operation[0] = () -> tableViewer.refresh();
        SelectionAdapter adapter = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (((Button)e.getSource()).getSelection()) {
                    StyledCellLabelProviderTests.this.column.getColumn().dispose();
                    int style = e.getSource() == leftButton ? 16384 : (e.getSource() == centerButton ? 0x1000000 : 131072);
                    StyledCellLabelProviderTests.this.createColumn(tableViewer, style, (CellLabelProvider)labelProvider);
                }
            }
        };
        leftButton.addSelectionListener((SelectionListener)adapter);
        centerButton.addSelectionListener((SelectionListener)adapter);
        rightButton.addSelectionListener((SelectionListener)adapter);
        TestContentProvider contentProvider = new TestContentProvider();
        tableViewer.setContentProvider((IContentProvider)contentProvider);
        stylingButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                labelProvider.setOwnerDrawEnabled(stylingButton.getSelection());
                tableViewer.refresh();
            }
        });
        GridData data = new GridData(4, 4, true, true);
        tableViewer.getControl().setLayoutData((Object)data);
        tableViewer.setInput(new Object());
        return composite;
    }

    private void createColumn(TableViewer viewer, int style, CellLabelProvider labelProvider) {
        this.column = new TableViewerColumn(viewer, style);
        this.column.getColumn().setWidth(200);
        this.column.getColumn().setText("Column");
        this.column.setLabelProvider(labelProvider);
        viewer.refresh();
    }

    protected void setTimer(final Display display, boolean selection, final Runnable[] operation, final Label resultLabel) {
        this.timerOn = selection;
        if (this.timerOn) {
            this.startTime = System.currentTimeMillis();
            this.numOperations = 0;
            display.asyncExec(new Runnable(){

                @Override
                public void run() {
                    if (display.isDisposed() || resultLabel.isDisposed()) {
                        return;
                    }
                    if (operation[0] != null) {
                        operation[0].run();
                    }
                    ++StyledCellLabelProviderTests.this.numOperations;
                    long currentTime = System.currentTimeMillis();
                    long elapsedTime = currentTime - StyledCellLabelProviderTests.this.startTime;
                    if (elapsedTime >= 1000L) {
                        double timePerOperation = (double)elapsedTime / 1000.0 / (double)StyledCellLabelProviderTests.this.numOperations;
                        double operationsPerSecond = 1.0 / timePerOperation;
                        resultLabel.setText("Operations per second: " + StyledCellLabelProviderTests.this.decimalFormat.format(operationsPerSecond));
                        StyledCellLabelProviderTests.this.numOperations = 0;
                        StyledCellLabelProviderTests.this.startTime = System.currentTimeMillis();
                    }
                    if (StyledCellLabelProviderTests.this.timerOn) {
                        display.asyncExec((Runnable)this);
                    }
                }
            });
        } else {
            resultLabel.setText("Operations per second: xxxx");
        }
    }

    private static FontData[] getModifiedFontData(FontData[] originalData, int additionalStyle) {
        FontData[] styleData = new FontData[originalData.length];
        int i = 0;
        while (i < styleData.length) {
            FontData base = originalData[i];
            styleData[i] = new FontData(base.getName(), base.getHeight(), base.getStyle() | additionalStyle);
            ++i;
        }
        return styleData;
    }

    private class ExampleLabelProvider
    extends StyledCellLabelProvider {
        private final StyledString.Styler fBoldStyler;
        private final StyledString.Styler fItalicStylerViaFontStyle;

        public ExampleLabelProvider(final Font boldFont) {
            this.fBoldStyler = new StyledString.Styler(){

                public void applyStyles(TextStyle textStyle) {
                    textStyle.font = boldFont;
                }
            };
            this.fItalicStylerViaFontStyle = new StyledString.Styler(){

                public void applyStyles(TextStyle textStyle) {
                    ((StyleRange)textStyle).fontStyle = 3;
                }
            };
        }

        public void update(ViewerCell cell) {
            Object element = cell.getElement();
            if (element instanceof File) {
                File file = (File)element;
                StyledString.Styler style = null;
                if (file.isDirectory()) {
                    if (StyledCellLabelProviderTests.this.useBold) {
                        style = this.fBoldStyler;
                    }
                } else if (StyledCellLabelProviderTests.this.useItalicViaFontStyleAttribute) {
                    style = this.fItalicStylerViaFontStyle;
                }
                StyledString styledString = new StyledString(file.getName(), style);
                String decoration = MessageFormat.format(" ({0} bytes)", file.length());
                styledString.append(decoration, StyledString.COUNTER_STYLER);
                cell.setText(styledString.toString());
                cell.setStyleRanges(styledString.getStyleRanges());
                if (file.isDirectory()) {
                    cell.setImage(IMAGE1);
                } else {
                    cell.setImage(IMAGE2);
                }
            } else {
                cell.setText("Unknown element");
            }
            super.update(cell);
        }

        protected void measure(Event event, Object element) {
            super.measure(event, element);
        }
    }

    static class File {
        private final String name;
        private final int length;
        private final boolean dir;

        File(String name, int length, boolean dir) {
            this.name = name;
            this.length = length;
            this.dir = dir;
        }

        public int length() {
            return this.length;
        }

        public String getName() {
            return this.name;
        }

        boolean isDirectory() {
            return this.dir;
        }
    }

    private static class TestContentProvider
    implements IStructuredContentProvider {
        private TestContentProvider() {
        }

        public Object[] getElements(Object element) {
            return new File[]{new File("asdfkjghfasdkjasdfhjgasdfkjhg", 2348, false), new File("sdafkuyasdfkljh", 2348, false), new File("asdklufhalsdkhlkjhnklj hlh", 2348, true), new File("asdfasdf asdf ", 2348, false), new File("fds sdf", 2348, true), new File(" sdafuh lsdfahj alsdfk hl", 2348, false), new File("sdfahj sdfajk hsdfjkh", 2348, false), new File("sdafkja sdfjkh asdfkhj", 2348, false), new File("sdfakj hasdfljkha sdfljkh sdfa", 348, true), new File("hj ka g", 1334, true), new File("asdfjk hsdfaljkh", 2348, false), new File("asdh gasdflhg ", 3348, true), new File("asd ghasdfkjg sdfkyug ", 4345, false), new File("asdf hjasdflkjh sdfal", 5345, false), new File("asdlfuh afsdhjg fdsalhj", 6648, false), new File("uiy viuh vhj v", 7448, true), new File("sdfauighsdvpyu ghasjkn", 8848, true), new File("asduih cuia ;nac", 9548, false), new File("chju kljhuuklh jk;", 348, false), new File("cdailukhu l;hj .n", 448, false), new File("auihy akl;h l;j", 2348, false), new File("caiugh j l;kjlh jcd", 2328, true), new File("auio;h jkh lhjl h ljjhbvj", 2348, true), new File("ajklkja kj lkjh jklh ", 2248, false), new File("asdfkjghfasdkjasdfhjgasdfkjhg", 2348, true), new File("sdafkuyasdfkljh", 2348, false), new File("asdklufhalsdkhlkjhnklj hlh", 2348, true), new File("asdfasdf asdf ", 2348, false), new File("fds sdf", 2348, true), new File(" sdafuh lsdfahj alsdfk hl", 2348, true), new File("sdfahj sdfajk hsdfjkh", 2348, false), new File("sdafkja sdfjkh asdfkhj", 2348, true), new File("sdfakj hasdfljkha sdfljkh sdfa", 348, true), new File("hj ka g", 1334, false), new File("asdfjk hsdfaljkh", 2348, false), new File("asdh gasdflhg ", 3348, true), new File("asd ghasdfkjg sdfkyug ", 4345, true), new File("asdf hjasdflkjh sdfal", 5345, true), new File("asdlfuh afsdhjg fdsalhj", 6648, false), new File("uiy viuh vhj v", 7448, false), new File("sdfauighsdvpyu ghasjkn", 8848, true), new File("asduih cuia ;nac", 9548, false), new File("chju kljhuuklh jk;", 348, true), new File("cdailukhu l;hj .n", 448, true), new File("auihy akl;h l;j", 2348, false), new File("caiugh j l;kjlh jcd", 2328, true), new File("auio;h jkh lhjl h ljjhbvj", 2348, false), new File("ajklkja kj lkjh jklh ", 2248, true)};
        }

        public void dispose() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }
    }
}

