/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jface.tests.viewers.interactive;

import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.tests.viewers.TestElement;
import org.eclipse.jface.tests.viewers.interactive.AddChildAction;
import org.eclipse.jface.tests.viewers.interactive.AddElementAction;
import org.eclipse.jface.tests.viewers.interactive.AddFilterAction;
import org.eclipse.jface.tests.viewers.interactive.AddSiblingAction;
import org.eclipse.jface.tests.viewers.interactive.ChangeChildLabelAction;
import org.eclipse.jface.tests.viewers.interactive.ChangeLabelAction;
import org.eclipse.jface.tests.viewers.interactive.ClearSelectionAction;
import org.eclipse.jface.tests.viewers.interactive.CreateModelAction;
import org.eclipse.jface.tests.viewers.interactive.DeleteAction;
import org.eclipse.jface.tests.viewers.interactive.DeleteChildrenAction;
import org.eclipse.jface.tests.viewers.interactive.DeleteSiblingsAction;
import org.eclipse.jface.tests.viewers.interactive.FlushInputAction;
import org.eclipse.jface.tests.viewers.interactive.ResetFilterAction;
import org.eclipse.jface.tests.viewers.interactive.ResetSorterAction;
import org.eclipse.jface.tests.viewers.interactive.SetLabelProviderAction;
import org.eclipse.jface.tests.viewers.interactive.SetSorterAction;
import org.eclipse.jface.tests.viewers.interactive.WorldChangedAction;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.window.ApplicationWindow;
import org.eclipse.swt.custom.CLabel;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.custom.ViewForm;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;

public abstract class TestBrowser
extends ApplicationWindow {
    TestElement fInput;
    Viewer fViewer;
    Action fChangeLabelAction;
    Action fChangeInputLabelAction;
    Action fChangeChildLabelAction;
    Action fReloadAction;
    Action fReloadActionLarge;
    Action fReloadActionFlat;
    Action fDeleteAction;
    Action fDeleteChildrenAction;
    Action fDeleteSomeChildrenAction;
    Action fDeleteSiblingsAction;
    Action fFlushInputAction;
    Action fAddElementAction;
    Action fAddSiblingAction;
    Action fAddSiblingRevealAction;
    Action fAddSiblingSelectAction;
    Action fAddChildAction;
    Action fAddChildRevealAction;
    Action fAddChildSelectAction;
    Action fWorldChangedAction;
    Action fSetLabelProvider;
    Action fAddFilterAction;
    Action fResetFilters;
    Action fSetSorter;
    Action fResetSorter;
    Action fClearSelection;
    int fPanes = 1;

    public TestBrowser() {
        super(null);
        this.addMenuBar();
    }

    protected void configureShell(Shell shell) {
        super.configureShell(shell);
        shell.setText("Test Browser");
    }

    protected void createActions() {
        this.fChangeLabelAction = new ChangeLabelAction("Change Label", this);
        this.fChangeChildLabelAction = new ChangeChildLabelAction("Change Child Label", this);
        this.fReloadAction = new CreateModelAction("Reload Test Data (small)", this, 3, 10);
        this.fReloadActionLarge = new CreateModelAction("Reload Test Data (large)", this, 3, 33);
        this.fReloadActionFlat = new CreateModelAction("Reload Test Data (flat)", this, 1, 2000);
        this.fDeleteAction = new DeleteAction("Delete", this);
        this.fDeleteChildrenAction = new DeleteChildrenAction("Delete Children", this, true);
        this.fDeleteSomeChildrenAction = new DeleteChildrenAction("Delete Odd Children", this, false);
        this.fDeleteSiblingsAction = new DeleteSiblingsAction("Delete Siblings", this, true);
        this.fFlushInputAction = new FlushInputAction("Flush Input", this);
        this.fAddElementAction = new AddElementAction("Add Element to Input", this);
        this.fAddSiblingAction = new AddSiblingAction("Add Sibling", this);
        this.fAddSiblingRevealAction = new AddSiblingAction("Add Sibling and Reveal", this, 17);
        this.fAddSiblingSelectAction = new AddSiblingAction("Add Sibling and Select", this, 49);
        this.fAddChildAction = new AddChildAction("Add Child", this);
        this.fAddChildRevealAction = new AddChildAction("Add Child and Reveal", this, 17);
        this.fAddChildSelectAction = new AddChildAction("Add Child and Select", this, 49);
        this.fWorldChangedAction = new WorldChangedAction("World Changed", this);
        this.fSetLabelProvider = new SetLabelProviderAction("Set Custom Label Provider", this);
        this.fAddFilterAction = new AddFilterAction("Add Filter", this);
        this.fResetFilters = new ResetFilterAction("Reset All Filters", this);
        this.fSetSorter = new SetSorterAction("Set Sorter", this);
        this.fResetSorter = new ResetSorterAction("Reset Sorter", this);
        this.fClearSelection = new ClearSelectionAction("Clear Selection", this);
    }

    protected Control createContents(Composite parent) {
        ViewForm form = new ViewForm(parent, 0);
        CLabel label = new CLabel((Composite)form, 0);
        form.setTopLeft((Control)label);
        TestElement input = this.getInput();
        label.setText(((Object)input).toString());
        if (this.fPanes == 1) {
            Viewer viewer = this.createViewer((Composite)form);
            form.setContent(viewer.getControl());
            this.fViewer = viewer;
            this.setInput(input);
        } else if (this.fPanes == 2) {
            Viewer viewer;
            SashForm sashForm = new SashForm((Composite)form, 512);
            form.setContent((Control)sashForm);
            this.fViewer = viewer = this.createViewer((Composite)sashForm);
            viewer.setInput((Object)input);
            viewer = this.createViewer((Composite)sashForm);
            viewer.setInput((Object)input);
        }
        this.createActions();
        this.fillMenuBar(this.getMenuBarManager());
        this.viewerFillMenuBar(this.getMenuBarManager());
        this.getMenuBarManager().updateAll(false);
        return form;
    }

    public abstract Viewer createViewer(Composite var1);

    protected void fillMenuBar(MenuManager mgr) {
        MenuManager setupMenu = new MenuManager("Setup", "Setup");
        mgr.add((IContributionItem)setupMenu);
        setupMenu.add((IAction)this.fReloadAction);
        setupMenu.add((IAction)this.fReloadActionLarge);
        setupMenu.add((IAction)this.fReloadActionFlat);
        setupMenu.add((IContributionItem)new Separator());
        setupMenu.add((IAction)this.fFlushInputAction);
        setupMenu.add((IContributionItem)new Separator());
        setupMenu.add((IAction)this.fSetLabelProvider);
        setupMenu.add((IContributionItem)new Separator());
        setupMenu.add((IAction)this.fAddFilterAction);
        setupMenu.add((IAction)this.fResetFilters);
        setupMenu.add((IContributionItem)new Separator());
        setupMenu.add((IAction)this.fSetSorter);
        setupMenu.add((IAction)this.fResetSorter);
        MenuManager testMenu = new MenuManager("Tests", "Tests");
        mgr.add((IContributionItem)testMenu);
        testMenu.add((IAction)this.fChangeLabelAction);
        testMenu.add((IAction)this.fChangeChildLabelAction);
        testMenu.add((IContributionItem)new Separator());
        testMenu.add((IAction)this.fDeleteAction);
        testMenu.add((IAction)this.fDeleteChildrenAction);
        testMenu.add((IAction)this.fDeleteSomeChildrenAction);
        testMenu.add((IAction)this.fDeleteSiblingsAction);
        testMenu.add((IContributionItem)new Separator());
        testMenu.add((IAction)this.fAddElementAction);
        testMenu.add((IContributionItem)new Separator());
        testMenu.add((IAction)this.fAddSiblingAction);
        testMenu.add((IAction)this.fAddSiblingRevealAction);
        testMenu.add((IAction)this.fAddSiblingSelectAction);
        testMenu.add((IContributionItem)new Separator());
        testMenu.add((IAction)this.fAddChildAction);
        testMenu.add((IAction)this.fAddChildRevealAction);
        testMenu.add((IAction)this.fAddChildSelectAction);
        testMenu.add((IContributionItem)new Separator());
        testMenu.add((IAction)this.fClearSelection);
        testMenu.add((IContributionItem)new Separator());
        testMenu.add((IAction)this.fWorldChangedAction);
    }

    public TestElement getInput() {
        return this.fInput;
    }

    public Viewer getViewer() {
        return this.fViewer;
    }

    public Composite getViewerContainer() {
        return null;
    }

    public void open(TestElement input) {
        this.setInput(input);
        super.open();
    }

    public void setInput(TestElement input) {
        this.fInput = input;
        if (this.getViewer() != null) {
            this.getViewer().setInput((Object)input);
        }
    }

    public void show2Panes() {
        this.fPanes = 2;
    }

    protected abstract void viewerFillMenuBar(MenuManager var1);
}

