/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jface.tests.viewers.interactive;

import org.eclipse.jface.tests.viewers.TestElement;
import org.eclipse.jface.tests.viewers.TestLabelProvider;
import org.eclipse.jface.tests.viewers.TestModelContentProvider;
import org.eclipse.jface.tests.viewers.interactive.TestTree;
import org.eclipse.jface.viewers.CheckboxTreeViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ITreeViewerListener;
import org.eclipse.jface.viewers.TreeExpansionEvent;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.widgets.Composite;

public class TestCheckboxTree
extends TestTree {
    CheckboxTreeViewer fCheckboxViewer;

    public void checkChildren(TestElement element, boolean state) {
        int numChildren = element.getChildCount();
        int i = 0;
        while (i < numChildren) {
            TestElement child = element.getChildAt(i);
            if (this.fCheckboxViewer.setChecked((Object)child, state)) {
                this.checkChildren(child, state);
            }
            ++i;
        }
    }

    @Override
    public Viewer createViewer(Composite parent) {
        CheckboxTreeViewer viewer = new CheckboxTreeViewer(parent);
        viewer.setContentProvider((IContentProvider)new TestModelContentProvider());
        viewer.setLabelProvider((IBaseLabelProvider)new TestLabelProvider());
        viewer.addTreeListener(new ITreeViewerListener(){

            public void treeExpanded(TreeExpansionEvent e) {
                TestCheckboxTree.this.handleTreeExpanded((TestElement)e.getElement());
            }

            public void treeCollapsed(TreeExpansionEvent e) {
            }
        });
        viewer.addCheckStateListener(e -> this.checkChildren((TestElement)e.getElement(), e.getChecked()));
        this.fCheckboxViewer = viewer;
        this.fViewer2 = viewer;
        return viewer;
    }

    public void handleTreeExpanded(TestElement element) {
        boolean checked = this.fCheckboxViewer.getChecked((Object)element);
        int numChildren = element.getChildCount();
        int i = 0;
        while (i < numChildren) {
            TestElement child = element.getChildAt(i);
            this.fCheckboxViewer.setChecked((Object)child, checked);
            ++i;
        }
    }

    public static void main(String[] args) {
        TestCheckboxTree browser = new TestCheckboxTree();
        if (args.length > 0 && args[0].equals("-twopanes")) {
            browser.show2Panes();
        }
        browser.setBlockOnOpen(true);
        browser.open(TestElement.createModel(3, 10));
    }
}

