/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jface.tests.viewers.interactive;

import org.eclipse.jface.tests.viewers.TestElement;
import org.eclipse.jface.tests.viewers.TestModelContentProvider;
import org.eclipse.jface.tests.viewers.interactive.TestTree;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeItem;

public class TestVirtualTree
extends TestTree {
    @Override
    public Viewer createViewer(Composite parent) {
        Tree tree = new Tree(parent, 0x10000000);
        tree.addListener(36, new Listener(){

            private String getPosition(TreeItem item) {
                TreeItem parentItem = item.getParentItem();
                if (parentItem == null) {
                    return "" + item.getParent().indexOf(item);
                }
                return this.getPosition(parentItem) + "." + parentItem.indexOf(item);
            }

            public void handleEvent(Event event) {
                String position = this.getPosition((TreeItem)event.item);
                if (position.endsWith(".32")) {
                    Thread.dumpStack();
                }
                System.out.println("updating " + position);
            }
        });
        TreeViewer viewer = new TreeViewer(tree);
        viewer.setContentProvider((IContentProvider)new TestModelContentProvider());
        viewer.setUseHashlookup(true);
        if (this.fViewer2 == null) {
            this.fViewer2 = viewer;
        }
        return viewer;
    }

    public static void main(String[] args) {
        TestVirtualTree browser = new TestVirtualTree();
        if (args.length > 0 && args[0].equals("-twopanes")) {
            browser.show2Panes();
        }
        browser.setBlockOnOpen(true);
        browser.open(TestElement.createModel(3, 10));
    }
}

